/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.machine.MachineDiFurnaceRTG;
import com.hbm.inventory.container.ContainerMachineDiFurnaceRTG;
import com.hbm.inventory.gui.GUIMachineDiFurnaceRTG;
import com.hbm.inventory.recipes.BlastFurnaceRecipes;
import com.hbm.items.machine.ItemRTGPellet;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.RTGUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityDiFurnaceRTG
extends TileEntityMachineBase
implements IGUIProvider,
IInfoProviderEC {
    public short progress;
    private short processSpeed = 0;
    private static final short timeRequired = 1200;
    private static final int[] rtgIn = new int[]{3, 4, 5, 6, 7, 8};
    private String name;
    public byte sideUpper = 1;
    public byte sideLower = 1;

    public TileEntityDiFurnaceRTG() {
        super(9);
    }

    public boolean canProcess() {
        if (!(this.slots[0] != null && this.slots[1] != null || this.hasPower())) {
            return false;
        }
        ItemStack recipeResult = BlastFurnaceRecipes.getOutput(this.slots[0], this.slots[1]);
        if (recipeResult == null) {
            return false;
        }
        if (this.slots[2] == null) {
            return true;
        }
        if (!this.slots[2].func_77969_a(recipeResult)) {
            return false;
        }
        if (this.slots[2].field_77994_a + recipeResult.field_77994_a > this.func_70297_j_()) {
            return false;
        }
        if (this.slots[2].field_77994_a < this.func_70297_j_() && this.slots[2].field_77994_a < this.slots[2].func_77976_d()) {
            return true;
        }
        return this.slots[2].field_77994_a < recipeResult.func_77976_d();
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canProcess() && this.hasPower()) {
            this.progress = (short)(this.progress + this.processSpeed);
            if (this.progress >= 1200) {
                this.processItem();
                this.progress = 0;
            }
        } else {
            this.progress = 0;
        }
        MachineDiFurnaceRTG.updateBlockState(this.isProcessing() || this.canProcess() && this.hasPower(), this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.networkPackNT(10);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeShort((int)this.progress);
        buf.writeShort((int)this.processSpeed);
        buf.writeBytes(new byte[]{this.sideUpper, this.sideLower});
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.progress = buf.readShort();
        this.processSpeed = buf.readShort();
        byte[] bytes = new byte[2];
        buf.readBytes(bytes);
        this.sideUpper = bytes[0];
        this.sideLower = bytes[1];
    }

    private void processItem() {
        if (this.canProcess()) {
            ItemStack recipeOut = BlastFurnaceRecipes.getOutput(this.slots[0], this.slots[1]);
            if (this.slots[2] == null) {
                this.slots[2] = recipeOut.func_77946_l();
            } else if (this.slots[2].func_77969_a(recipeOut)) {
                this.slots[2].field_77994_a += recipeOut.field_77994_a;
            }
            for (int i = 0; i < 2; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b().func_77664_n());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
            this.func_70296_d();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74765_d("progress");
        this.processSpeed = nbt.func_74765_d("speed");
        byte[] modes = nbt.func_74770_j("modes");
        this.sideUpper = modes[0];
        this.sideLower = modes[1];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("progress", this.progress);
        nbt.func_74777_a("speed", this.processSpeed);
        nbt.func_74773_a("modes", new byte[]{this.sideUpper, this.sideLower});
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.progress * i / 1200;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        this.slots[i] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    @Override
    public void setCustomName(String name) {
        this.name = name;
    }

    public boolean hasPower() {
        this.processSpeed = (short)RTGUtil.updateRTGs(this.slots, rtgIn);
        return this.processSpeed >= 15;
    }

    public int getPower() {
        return this.processSpeed;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.name : "container.diFurnaceRTG";
    }

    @Override
    public boolean func_145818_k_() {
        return this.name != null && this.name.length() > 0;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        if (i == 0 && this.sideUpper != j) {
            return false;
        }
        if (i == 1 && this.sideLower != j) {
            return false;
        }
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 2) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemRTGPellet) {
            return i > 2;
        }
        return !(stack.func_77973_b() instanceof ItemRTGPellet);
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (slot > 2) {
            return !(stack.func_77973_b() instanceof ItemRTGPellet);
        }
        return slot == 2;
    }

    @Override
    public String getName() {
        return "container.diFurnaceRTG";
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineDiFurnaceRTG(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineDiFurnaceRTG(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74772_a("fuel", (long)this.getPower());
        data.func_74768_a("progress", (int)this.progress);
    }
}

