/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.inventory.container.ContainerAutocrafter;
import com.hbm.inventory.gui.GUIAutocrafter;
import com.hbm.lib.Library;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.tileentity.IControlReceiverFilter;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineAutocrafter
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IGUIProvider,
IControlReceiverFilter {
    public List<IRecipe> recipes = new ArrayList<IRecipe>();
    public int recipeIndex;
    public int recipeCount;
    public ModulePatternMatcher matcher;
    protected InventoryCraftingAuto craftingInventory = new InventoryCraftingAuto(3, 3);
    public int[] access = new int[]{10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    public static int consumption = 100;
    public static long maxPower = consumption * 100;
    public long power;

    public TileEntityMachineAutocrafter() {
        super(21);
        this.matcher = new ModulePatternMatcher(9);
    }

    @Override
    public void nextMode(int i) {
        this.matcher.nextMode(this.field_145850_b, this.slots[i], i);
    }

    public void nextTemplate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.recipeIndex;
        if (this.recipeIndex >= this.recipes.size()) {
            this.recipeIndex = 0;
        }
        this.slots[9] = !this.recipes.isEmpty() ? this.recipes.get(this.recipeIndex).func_77572_b(this.getTemplateGrid()) : null;
    }

    @Override
    public String getName() {
        return "container.autocrafter";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 20, this.power, maxPower);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            if (!this.recipes.isEmpty()) {
                ItemStack stack;
                IRecipe recipe;
                if (this.power >= (long)consumption && (recipe = this.recipes.get(this.recipeIndex)).func_77569_a(this.getRecipeGrid(), this.field_145850_b) && (stack = recipe.func_77572_b(this.getRecipeGrid())) != null) {
                    boolean didCraft = false;
                    if (this.slots[19] == null) {
                        this.slots[19] = stack.func_77946_l();
                        didCraft = true;
                    } else if (this.slots[19].func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.slots[19]) && this.slots[19].field_77994_a + stack.field_77994_a <= this.slots[19].func_77976_d()) {
                        this.slots[19].field_77994_a += stack.field_77994_a;
                        didCraft = true;
                    }
                    if (didCraft) {
                        for (int i = 10; i < 19; ++i) {
                            ItemStack container;
                            ItemStack ingredient = this.func_70301_a(i);
                            if (ingredient == null) continue;
                            this.func_70298_a(i, 1);
                            if (this.slots[i] != null || !ingredient.func_77973_b().hasContainerItem(ingredient) || (container = ingredient.func_77973_b().getContainerItem(ingredient)) != null && container.func_77984_f() && container.func_77960_j() > container.func_77958_k()) continue;
                            this.func_70299_a(i, container);
                        }
                        this.power -= (long)consumption;
                    }
                }
            }
            this.networkPackNT(15);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        this.matcher.serialize(buf);
        buf.writeInt(this.recipeCount);
        buf.writeInt(this.recipeIndex);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.matcher.deserialize(buf);
        this.recipeCount = buf.readInt();
        this.recipeIndex = buf.readInt();
    }

    public void updateTemplateGrid() {
        this.recipes = this.getMatchingRecipes(this.getTemplateGrid());
        this.recipeCount = this.recipes.size();
        this.recipeIndex = 0;
        this.slots[9] = !this.recipes.isEmpty() ? this.recipes.get(this.recipeIndex).func_77572_b(this.getTemplateGrid()) : null;
    }

    public List<IRecipe> getMatchingRecipes(InventoryCrafting grid) {
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        for (Object o : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe recipe = (IRecipe)o;
            if (!recipe.func_77569_a(grid, this.field_145850_b)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    @Override
    public int[] func_94128_d(int side) {
        return this.access;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        if (i == 19) {
            return true;
        }
        if (i > 9 && i < 19) {
            ItemStack filter = this.slots[i - 10];
            if (filter == null || this.matcher.modes[i - 10] == null || this.matcher.modes[i - 10].isEmpty()) {
                return true;
            }
            return !this.matcher.isValidForFilter(filter, i - 10, stack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.field_77994_a > 1 && stack.func_77973_b().hasContainerItem(stack)) {
            return false;
        }
        if (slot < 10 || slot > 18) {
            return false;
        }
        if (this.slots[slot - 10] == null) {
            return false;
        }
        if (this.slots[slot] != null && this.slots[slot].field_77994_a + stack.field_77994_a > 4) {
            return false;
        }
        if (stack.field_77994_a > 4) {
            return false;
        }
        ArrayList<Integer> validSlots = new ArrayList<Integer>();
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.slots[i];
            if (filter == null || this.matcher.modes[i] == null || this.matcher.modes[i].isEmpty() || !this.matcher.isValidForFilter(filter, i, stack)) continue;
            validSlots.add(i + 10);
            if (i + 10 != slot || this.slots[slot] != null) continue;
            return true;
        }
        if (!validSlots.contains(slot)) {
            return false;
        }
        int size = this.slots[slot].field_77994_a;
        for (Integer i : validSlots) {
            ItemStack valid = this.slots[i];
            if (valid == null) {
                return false;
            }
            if (!valid.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)valid, (ItemStack)stack) || valid.field_77994_a >= size) continue;
            return false;
        }
        return !stack.func_77973_b().hasContainerItem(stack);
    }

    public InventoryCrafting getTemplateGrid() {
        this.craftingInventory.loadIventory(this.slots, 0);
        return this.craftingInventory;
    }

    public InventoryCrafting getRecipeGrid() {
        this.craftingInventory.loadIventory(this.slots, 10);
        return this.craftingInventory;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.matcher.readFromNBT(nbt);
        this.recipes = this.getMatchingRecipes(this.getTemplateGrid());
        this.recipeCount = this.recipes.size();
        this.recipeIndex = nbt.func_74762_e("rec");
        this.slots[9] = !this.recipes.isEmpty() ? this.recipes.get(this.recipeIndex).func_77572_b(this.getTemplateGrid()) : null;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.matcher.writeToNBT(nbt);
        nbt.func_74768_a("rec", this.recipeIndex);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerAutocrafter(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIAutocrafter(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void setFilterContents(NBTTagCompound nbt) {
        TileEntityMachineAutocrafter tile = this;
        TileEntityMachineAutocrafter inv = this;
        int slot = nbt.func_74762_e("slot");
        if (slot > 8) {
            return;
        }
        NBTTagCompound stack = nbt.func_74775_l("stack");
        ItemStack item = ItemStack.func_77949_a((NBTTagCompound)stack);
        inv.func_70299_a(slot, item);
        this.matcher.initPatternSmart(this.func_145831_w(), item, slot);
        tile.func_145831_w().func_147476_b(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (TileEntity)tile);
        this.updateTemplateGrid();
    }

    @Override
    public int[] getFilterSlots() {
        return new int[]{0, 9};
    }

    public static class InventoryCraftingAuto
    extends InventoryCrafting {
        public InventoryCraftingAuto(int width, int height) {
            super((Container)new ContainerBlank(), width, height);
        }

        public void loadIventory(ItemStack[] slots, int start) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.func_70299_a(i, slots[start + i]);
            }
        }

        public void clear() {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.func_70299_a(i, null);
            }
        }

        public static class ContainerBlank
        extends Container {
            public void func_75130_a(IInventory inventory) {
            }

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        }
    }
}

