/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.tile.IInfoProviderEC;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerCentrifuge;
import com.hbm.inventory.gui.GUIMachineCentrifuge;
import com.hbm.inventory.recipes.CentrifugeRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCentrifuge
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IGUIProvider,
IUpgradeInfoProvider,
IInfoProviderEC,
IConfigurableMachine {
    public int progress;
    public long power;
    public boolean isProgressing;
    private int audioDuration = 0;
    private AudioWrapper audio;
    public static int maxPower = 100000;
    public static int processingSpeed = 200;
    public static int baseConsumption = 200;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    private static final int[] slot_io = new int[]{0, 2, 3, 4, 5};
    AxisAlignedBB bb = null;

    @Override
    public String getConfigName() {
        return "centrifuge";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "I:powerCap", maxPower);
        processingSpeed = IConfigurableMachine.grab(obj, "I:timeToProcess", processingSpeed);
        baseConsumption = IConfigurableMachine.grab(obj, "I:consumption", baseConsumption);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:powerCap").value((long)maxPower);
        writer.name("I:timeToProcess").value((long)processingSpeed);
        writer.name("I:consumption").value((long)baseConsumption);
    }

    public TileEntityMachineCentrifuge() {
        super(8);
    }

    @Override
    public String getName() {
        return "container.centrifuge";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 0;
    }

    @Override
    public int[] func_94128_d(int side) {
        return slot_io;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74765_d("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74777_a("progress", (short)this.progress);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i > 1;
    }

    public int getCentrifugeProgressScaled(int i) {
        return this.progress * i / processingSpeed;
    }

    public long getPowerRemainingScaled(int i) {
        return this.power * (long)i / (long)maxPower;
    }

    public boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack[] out = CentrifugeRecipes.getOutput(this.slots[0]);
        if (out == null) {
            return false;
        }
        for (int i = 0; i < Math.min(4, out.length); ++i) {
            if (this.slots[i + 2] == null || out[i] == null || this.slots[i + 2].func_77969_a(out[i]) && this.slots[i + 2].field_77994_a + out[i].field_77994_a <= out[i].func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private void processItem() {
        ItemStack[] out = CentrifugeRecipes.getOutput(this.slots[0]);
        for (int i = 0; i < Math.min(4, out.length); ++i) {
            if (out[i] == null) continue;
            if (this.slots[i + 2] == null) {
                this.slots[i + 2] = out[i].func_77946_l();
                continue;
            }
            this.slots[i + 2].field_77994_a += out[i].field_77994_a;
        }
        this.func_70298_a(0, 1);
        this.func_70296_d();
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, maxPower);
            int consumption = baseConsumption;
            int speed = 1;
            this.upgradeManager.checkSlots(this, this.slots, 6, 7);
            speed += this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED).intValue();
            consumption += this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED) * baseConsumption;
            speed *= 1 + this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE) * 5;
            consumption += this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE) * baseConsumption * 50;
            consumption /= 1 + this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            if (this.hasPower() && this.isProcessing()) {
                this.power -= (long)consumption;
                if (this.power < 0L) {
                    this.power = 0L;
                }
            }
            this.isProgressing = this.hasPower() && this.canProcess();
            if (this.isProgressing) {
                this.progress += speed;
                if (this.progress >= processingSpeed) {
                    this.progress = 0;
                    this.processItem();
                }
            } else {
                this.progress = 0;
            }
            this.networkPackNT(50);
        } else {
            this.audioDuration = this.isProgressing ? (this.audioDuration += 2) : (this.audioDuration -= 3);
            this.audioDuration = MathHelper.func_76125_a((int)this.audioDuration, (int)0, (int)60);
            if (this.audioDuration > 10) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.updateVolume(this.getVolume(1.0f));
                this.audio.updatePitch((float)(this.audioDuration - 10) / 100.0f + 0.5f);
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.progress);
        buf.writeBoolean(this.isProgressing);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.progress = buf.readInt();
        this.isProgressing = buf.readBoolean();
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.centrifugeOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 1));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCentrifuge(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCentrifuge(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_centrifuge));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + (100 - 100 / (level + 1)) + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 100 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + (100 - 100 / (level + 1)) + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.progress > 0);
        data.func_74768_a("active", this.progress);
    }
}

