/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerChemfac;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIChemfac;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.machine.TileEntityMachineChemplantBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineChemfac
extends TileEntityMachineChemplantBase
implements IUpgradeInfoProvider,
IFluidCopiable {
    float rotSpeed;
    public float rot;
    public float prevRot;
    public FluidTank water;
    public FluidTank steam;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    protected List<DirPos> conPos;
    DirPos[] inpos;
    DirPos[] outpos;
    AxisAlignedBB bb = null;

    public TileEntityMachineChemfac() {
        super(77);
        this.water = new FluidTank(Fluids.WATER, 64000);
        this.steam = new FluidTank(Fluids.SPENTSTEAM, 64000);
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 1 && i <= 4 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 60L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    for (FluidTank tank : this.inTanks()) {
                        if (tank.getTankType() == Fluids.NONE) continue;
                        this.trySubscribe(tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    }
                }
            }
            for (DirPos pos : this.getConPos()) {
                for (FluidTank tank : this.outTanks()) {
                    if (tank.getTankType() == Fluids.NONE || tank.getFill() <= 0) continue;
                    this.tryProvide(tank, this.field_145850_b, pos);
                }
            }
            this.speed = 100;
            this.consumption = 100;
            this.upgradeManager.checkSlots(this, this.slots, 1, 4);
            int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            int overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.speed -= speedLevel * 15;
            this.consumption += speedLevel * 300;
            this.speed += powerLevel * 5;
            this.consumption -= powerLevel * 20;
            this.speed /= overLevel + 1;
            this.consumption *= overLevel + 1;
            if (this.speed <= 0) {
                this.speed = 1;
            }
            this.networkPackNT(150);
        } else {
            float maxSpeed = 30.0f;
            if (this.isProgressing) {
                this.rotSpeed = (float)((double)this.rotSpeed + 0.1);
                if (this.rotSpeed > maxSpeed) {
                    this.rotSpeed = maxSpeed;
                }
                if (this.rotSpeed == maxSpeed && this.field_145850_b.func_82737_E() % 5L == 0L) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
                    ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                    Random rand = this.field_145850_b.field_73012_v;
                    double x = (double)this.field_145851_c + 0.5 - (double)rot.offsetX * 0.5;
                    double y = this.field_145848_d + 3;
                    double z = (double)this.field_145849_e + 0.5 - (double)rot.offsetZ * 0.5;
                    this.field_145850_b.func_72869_a("cloud", x + (double)dir.offsetX * 1.5 + rand.nextGaussian() * 0.15, y, z + (double)dir.offsetZ * 1.5 + rand.nextGaussian() * 0.15, 0.0, 0.15, 0.0);
                    this.field_145850_b.func_72869_a("cloud", x - (double)dir.offsetX * 0.5 + rand.nextGaussian() * 0.15, y, z - (double)dir.offsetZ * 0.5 + rand.nextGaussian() * 0.15, 0.0, 0.15, 0.0);
                }
            } else {
                this.rotSpeed = (float)((double)this.rotSpeed - 0.1);
                if (this.rotSpeed < 0.0f) {
                    this.rotSpeed = 0.0f;
                }
            }
            this.prevRot = this.rot;
            this.rot += this.rotSpeed;
            if (this.rot >= 360.0f) {
                this.rot -= 360.0f;
                this.prevRot -= 360.0f;
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        int i;
        super.serialize(buf);
        buf.writeLong(this.power);
        for (i = 0; i < this.getRecipeCount(); ++i) {
            buf.writeInt(this.progress[i]);
            buf.writeInt(this.maxProgress[i]);
        }
        buf.writeBoolean(this.isProgressing);
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
        this.water.serialize(buf);
        this.steam.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int i;
        super.deserialize(buf);
        this.power = buf.readLong();
        for (i = 0; i < this.getRecipeCount(); ++i) {
            this.progress[i] = buf.readInt();
            this.maxProgress[i] = buf.readInt();
        }
        this.isProgressing = buf.readBoolean();
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
        this.water.deserialize(buf);
        this.steam.deserialize(buf);
    }

    private int getWaterRequired() {
        return 1000 / this.speed;
    }

    @Override
    protected boolean canProcess(int index) {
        return super.canProcess(index) && this.water.getFill() >= this.getWaterRequired() && this.steam.getFill() + this.getWaterRequired() <= this.steam.getMaxFill();
    }

    @Override
    protected void process(int index) {
        super.process(index);
        this.water.setFill(this.water.getFill() - this.getWaterRequired());
        this.steam.setFill(this.steam.getFill() + this.getWaterRequired());
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    protected List<DirPos> getConPos() {
        if (this.conPos != null && !this.conPos.isEmpty()) {
            return this.conPos;
        }
        this.conPos = new ArrayList<DirPos>();
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        for (int i = 0; i < 6; ++i) {
            this.conPos.add(new DirPos(this.field_145851_c + dir.offsetX * (3 - i) + rot.offsetX * 3, this.field_145848_d + 4, this.field_145849_e + dir.offsetZ * (3 - i) + rot.offsetZ * 3, Library.POS_Y));
            this.conPos.add(new DirPos(this.field_145851_c + dir.offsetX * (3 - i) - rot.offsetX * 2, this.field_145848_d + 4, this.field_145849_e + dir.offsetZ * (3 - i) - rot.offsetZ * 2, Library.POS_Y));
            for (int j = 0; j < 2; ++j) {
                this.conPos.add(new DirPos(this.field_145851_c + dir.offsetX * (3 - i) + rot.offsetX * 5, this.field_145848_d + 1 + j, this.field_145849_e + dir.offsetZ * (3 - i) + rot.offsetZ * 5, rot));
                this.conPos.add(new DirPos(this.field_145851_c + dir.offsetX * (3 - i) - rot.offsetX * 4, this.field_145848_d + 1 + j, this.field_145849_e + dir.offsetZ * (3 - i) - rot.offsetZ * 4, rot.getOpposite()));
            }
        }
        return this.conPos;
    }

    @Override
    public int getRecipeCount() {
        return 8;
    }

    @Override
    public int getTankCapacity() {
        return 32000;
    }

    @Override
    public int getTemplateIndex(int index) {
        return 13 + index * 9;
    }

    @Override
    public int[] getSlotIndicesFromIndex(int index) {
        return new int[]{5 + index * 9, 8 + index * 9, 9 + index * 9, 12 + index * 9};
    }

    @Override
    public DirPos[] getInputPositions() {
        if (this.inpos != null) {
            return this.inpos;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.inpos = new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4 - rot.offsetX * 1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 - rot.offsetZ * 1, dir), new DirPos(this.field_145851_c - dir.offsetX * 5 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 5 + rot.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX * 4, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ * 4, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 1 + rot.offsetX * 5, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * 5, rot)};
        return this.inpos;
    }

    @Override
    public DirPos[] getOutputPositions() {
        if (this.outpos != null) {
            return this.outpos;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.outpos = new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ * 2, dir), new DirPos(this.field_145851_c - dir.offsetX * 5 - rot.offsetX * 1, this.field_145848_d, this.field_145849_e - dir.offsetZ * 5 - rot.offsetZ * 1, dir.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 1 - rot.offsetX * 4, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 - rot.offsetZ * 4, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX * 5, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * 5, rot)};
        return this.outpos;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.water.readFromNBT(nbt, "w");
        this.steam.readFromNBT(nbt, "s");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.water.writeToNBT(nbt, "w");
        this.steam.writeToNBT(nbt, "s");
    }

    @Override
    public String getName() {
        return "container.machineChemFac";
    }

    @Override
    protected List<FluidTank> inTanks() {
        List<FluidTank> inTanks = super.inTanks();
        inTanks.add(this.water);
        return inTanks;
    }

    @Override
    protected List<FluidTank> outTanks() {
        List<FluidTank> outTanks = super.outTanks();
        outTanks.add(this.steam);
        return outTanks;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)this.field_145848_d, (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 5));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerChemfac(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIChemfac(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_chemfac));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 15 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 300 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 30 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+" + level * 5 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 6);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 12);
        return upgrades;
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

