/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineCyclotron;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineCyclotron;
import com.hbm.inventory.recipes.CyclotronRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConditionalInvAccess;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.I18nUtil;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCyclotron
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IGUIProvider,
IConditionalInvAccess,
IUpgradeInfoProvider,
IInfoProviderEC,
IFluidCopiable {
    public long power;
    public static final long maxPower = 100000000L;
    public static int consumption = 1000000;
    private byte plugs;
    public int progress;
    public static final int duration = 690;
    public FluidTank[] tanks;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();

    public TileEntityMachineCyclotron() {
        super(12);
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(Fluids.WATER, 32000);
        this.tanks[1] = new FluidTank(Fluids.SPENTSTEAM, 32000);
        this.tanks[2] = new FluidTank(Fluids.AMAT, 8000);
    }

    @Override
    public String getName() {
        return "container.cyclotron";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 9, this.power, 100000000L);
            this.upgradeManager.checkSlots(this, this.slots, 10, 11);
            if (this.canProcess()) {
                this.progress += this.getSpeed();
                this.power -= (long)this.getConsumption();
                int convert = this.getCoolantConsumption();
                this.tanks[0].setFill(this.tanks[0].getFill() - convert);
                this.tanks[1].setFill(this.tanks[1].getFill() + convert);
                if (this.progress >= 690) {
                    this.process();
                    this.progress = 0;
                    this.func_70296_d();
                }
            } else {
                this.progress = 0;
            }
            this.sendFluid();
            this.networkPackNT(25);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.progress);
        buf.writeByte((int)this.plugs);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.progress = buf.readInt();
        this.plugs = buf.readByte();
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private void sendFluid() {
        for (int i = 1; i < 3; ++i) {
            if (this.tanks[i].getFill() <= 0) continue;
            for (DirPos pos : this.getConPos()) {
                this.sendFluid(this.tanks[i], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 3, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 3, Library.NEG_Z)};
    }

    public boolean canProcess() {
        if (this.power < (long)this.getConsumption()) {
            return false;
        }
        int convert = this.getCoolantConsumption();
        if (this.tanks[0].getFill() < convert) {
            return false;
        }
        if (this.tanks[1].getFill() + convert > this.tanks[1].getMaxFill()) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack out;
            Object[] res = CyclotronRecipes.getOutput(this.slots[i + 3], this.slots[i]);
            if (res == null || (out = (ItemStack)res[0]) == null) continue;
            if (this.slots[i + 6] == null) {
                return true;
            }
            if (this.slots[i + 6].func_77973_b() != out.func_77973_b() || this.slots[i + 6].func_77960_j() != out.func_77960_j() || this.slots[i + 6].field_77994_a >= out.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public void process() {
        for (int i = 0; i < 3; ++i) {
            ItemStack out;
            Object[] res = CyclotronRecipes.getOutput(this.slots[i + 3], this.slots[i]);
            if (res == null || (out = (ItemStack)res[0]) == null) continue;
            if (this.slots[i + 6] == null) {
                this.func_70298_a(i, 1);
                this.func_70298_a(i + 3, 1);
                this.slots[i + 6] = out;
                this.tanks[2].setFill(this.tanks[2].getFill() + (Integer)res[1]);
                continue;
            }
            if (this.slots[i + 6].func_77973_b() != out.func_77973_b() || this.slots[i + 6].func_77960_j() != out.func_77960_j() || this.slots[i + 6].field_77994_a >= out.func_77976_d()) continue;
            this.func_70298_a(i, 1);
            this.func_70298_a(i + 3, 1);
            ++this.slots[i + 6].field_77994_a;
            this.tanks[2].setFill(this.tanks[2].getFill() + (Integer)res[1]);
        }
        if (this.tanks[2].getFill() > this.tanks[2].getMaxFill()) {
            this.tanks[2].setFill(this.tanks[2].getMaxFill());
        }
    }

    public int getSpeed() {
        return this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED) + 1;
    }

    public int getConsumption() {
        int efficiency = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
        return consumption - 100000 * efficiency;
    }

    public int getCoolantConsumption() {
        int efficiency = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.EFFECT);
        return 500 / (efficiency + 1) * this.getSpeed();
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 690;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 3));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
        this.progress = nbt.func_74762_e("progress");
        this.power = nbt.func_74763_f("power");
        this.plugs = nbt.func_74771_c("plugs");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74772_a("power", this.power);
        nbt.func_74774_a("plugs", this.plugs);
    }

    public void setPlug(int index) {
        this.plugs = (byte)(this.plugs | 1 << index);
        this.func_70296_d();
    }

    public boolean getPlug(int index) {
        return (this.plugs & 1 << index) > 0;
    }

    public static Item getItemForPlug(int i) {
        switch (i) {
            case 0: {
                return ModItems.powder_balefire;
            }
            case 1: {
                return ModItems.book_of_;
            }
            case 2: {
                return ModItems.diamond_gavel;
            }
            case 3: {
                return ModItems.coin_maskman;
            }
        }
        return null;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 14 && i <= 15 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.5f, 1.0f);
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineCyclotron(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCyclotron(player.field_71071_by, this);
    }

    @Override
    public boolean isItemValidForSlot(int x, int y, int z, int slot, ItemStack stack) {
        block3: {
            block2: {
                if (slot >= 3) break block2;
                for (Map.Entry<Tuple.Pair<RecipesCommon.ComparableStack, RecipesCommon.AStack>, Tuple.Pair<ItemStack, Integer>> entry : CyclotronRecipes.recipes.entrySet()) {
                    if (!entry.getKey().getKey().matchesRecipe(stack, true)) continue;
                    return true;
                }
                break block3;
            }
            if (slot >= 6) break block3;
            for (Map.Entry<Tuple.Pair<RecipesCommon.ComparableStack, RecipesCommon.AStack>, Tuple.Pair<ItemStack, Integer>> entry : CyclotronRecipes.recipes.entrySet()) {
                if (!entry.getKey().getValue().matchesRecipe(stack, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canInsertItem(int x, int y, int z, int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(x, y, z, slot, stack);
    }

    @Override
    public boolean canExtractItem(int x, int y, int z, int slot, ItemStack stack, int side) {
        return slot >= 6 && slot <= 8;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(int x, int y, int z, int side) {
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            if (x == this.field_145851_c + dir.offsetX * 2 + rot.offsetX && z == this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ) {
                return new int[]{0, 3, 6, 7, 8};
            }
            if (x == this.field_145851_c + dir.offsetX * 2 && z == this.field_145849_e + dir.offsetZ * 2) {
                return new int[]{1, 4, 6, 7, 8};
            }
            if (x != this.field_145851_c + dir.offsetX * 2 - rot.offsetX || z != this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ) continue;
            return new int[]{2, 5, 6, 7, 8};
        }
        return new int[]{6, 7, 8};
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.EFFECT;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_cyclotron));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + (100 - 100 / (level + 1)) + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.coolantConsumption", "+" + level * 100 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 10 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.EFFECT) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.coolantConsumption", "-" + (100 - 100 / (level + 1)) + "%"));
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.EFFECT, 3);
        return upgrades;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.progress > 0);
        data.func_74780_a("consumptionHE", this.progress > 0 ? (double)this.getConsumption() : 0.0);
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

