/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerMachineEPress;
import com.hbm.inventory.gui.GUIMachineEPress;
import com.hbm.inventory.recipes.PressRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.items.machine.ItemStamp;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineEPress
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IGUIProvider,
IUpgradeInfoProvider,
IInfoProviderEC {
    public long power = 0L;
    public static final long maxPower = 50000L;
    public int press;
    public double renderPress;
    public double lastPress;
    private int syncPress;
    private int turnProgress;
    public static final int maxPress = 200;
    boolean isRetracting = false;
    private int delay;
    public ItemStack syncStack;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    AxisAlignedBB aabb;

    public TileEntityMachineEPress() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.epress";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 50000L);
            boolean canProcess = this.canProcess();
            if ((canProcess || this.isRetracting || this.delay > 0) && this.power >= 100L) {
                this.power -= 100L;
                if (this.delay <= 0) {
                    this.upgradeManager.checkSlots(this, this.slots, 4, 4);
                    int speed = 1 + this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
                    int stampSpeed = this.isRetracting ? 20 : 45;
                    stampSpeed = (int)((double)stampSpeed * (1.0 + (double)speed / 4.0));
                    if (this.isRetracting) {
                        this.press -= stampSpeed;
                        if (this.press <= 0) {
                            this.isRetracting = false;
                            this.delay = 5 - speed + 1;
                        }
                    } else if (canProcess) {
                        this.press += stampSpeed;
                        if (this.press >= 200) {
                            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.pressOperate", this.getVolume(1.5f), 1.0f);
                            ItemStack output = PressRecipes.getOutput(this.slots[2], this.slots[1]);
                            if (this.slots[3] == null) {
                                this.slots[3] = output.func_77946_l();
                            } else {
                                this.slots[3].field_77994_a += output.field_77994_a;
                            }
                            this.func_70298_a(2, 1);
                            if (this.slots[1].func_77958_k() != 0) {
                                this.slots[1].func_77964_b(this.slots[1].func_77960_j() + 1);
                                if (this.slots[1].func_77960_j() >= this.slots[1].func_77958_k()) {
                                    this.slots[1] = null;
                                }
                            }
                            this.isRetracting = true;
                            this.delay = 5 - speed + 1;
                            this.func_70296_d();
                        }
                    } else if (this.press > 0) {
                        this.isRetracting = true;
                    }
                } else {
                    --this.delay;
                }
            }
            this.networkPackNT(50);
        } else {
            this.lastPress = this.renderPress;
            if (this.turnProgress > 0) {
                this.renderPress += ((double)this.syncPress - this.renderPress) / (double)this.turnProgress;
                --this.turnProgress;
            } else {
                this.renderPress = this.syncPress;
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.press);
        if (this.slots[2] == null) {
            buf.writeShort(-1);
        } else {
            BufferUtil.writeNBT(buf, this.slots[2].field_77990_d);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.syncPress = buf.readInt();
        NBTTagCompound stack = BufferUtil.readNBT(buf);
        this.syncStack = ItemStack.func_77949_a((NBTTagCompound)stack);
        this.turnProgress = 2;
    }

    public boolean canProcess() {
        if (this.power < 100L) {
            return false;
        }
        if (this.slots[1] == null || this.slots[2] == null) {
            return false;
        }
        ItemStack output = PressRecipes.getOutput(this.slots[2], this.slots[1]);
        if (output == null) {
            return false;
        }
        if (this.slots[3] == null) {
            return true;
        }
        return this.slots[3].field_77994_a + output.field_77994_a <= this.slots[3].func_77976_d() && this.slots[3].func_77973_b() == output.func_77973_b() && this.slots[3].func_77960_j() == output.func_77960_j();
    }

    private void updateConnections() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemStamp) {
            return i == 1;
        }
        return i == 2;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{1, 2, 3};
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.press = nbt.func_74762_e("press");
        this.power = nbt.func_74762_e("power");
        this.isRetracting = nbt.func_74767_n("ret");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("press", this.press);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("ret", this.isRetracting);
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.aabb != null) {
            return this.aabb;
        }
        this.aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
        return this.aabb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineEPress(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineEPress(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_epress));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + 50 * level / 3 + "%"));
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        return upgrades;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74768_a("progress", this.press);
    }
}

