/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.machine.TileEntityMachinePumpBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import io.netty.buffer.ByteBuf;

public class TileEntityMachinePumpElectric
extends TileEntityMachinePumpBase
implements IEnergyReceiverMK2 {
    public long power;
    public static final long maxPower = 10000L;

    public TileEntityMachinePumpElectric() {
        this.water = new FluidTank(Fluids.WATER, electricSpeed * 100);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
        super.func_145845_h();
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
    }

    @Override
    protected boolean canOperate() {
        return this.power >= 1000L && this.water.getFill() < this.water.getMaxFill();
    }

    @Override
    protected void operate() {
        this.power -= 1000L;
        this.water.setFill(Math.min(this.water.getFill() + electricSpeed, this.water.getMaxFill()));
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }
}

