/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.machine.TileEntityMachinePumpBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import io.netty.buffer.ByteBuf;

public class TileEntityMachinePumpSteam
extends TileEntityMachinePumpBase {
    public FluidTank steam;
    public FluidTank lps;

    public TileEntityMachinePumpSteam() {
        this.water = new FluidTank(Fluids.WATER, steamSpeed * 100);
        this.steam = new FluidTank(Fluids.STEAM, 1000);
        this.lps = new FluidTank(Fluids.SPENTSTEAM, 10);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.steam.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                if (this.lps.getFill() <= 0) continue;
                this.sendFluid(this.lps, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
        super.func_145845_h();
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.water, this.steam, this.lps};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.water, this.lps};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.steam};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.steam.serialize(buf);
        this.lps.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.steam.deserialize(buf);
        this.lps.deserialize(buf);
    }

    @Override
    protected boolean canOperate() {
        return this.steam.getFill() >= 100 && this.lps.getMaxFill() - this.lps.getFill() > 0 && this.water.getFill() < this.water.getMaxFill();
    }

    @Override
    protected void operate() {
        this.steam.setFill(this.steam.getFill() - 100);
        this.lps.setFill(this.lps.getFill() + 1);
        this.water.setFill(Math.min(this.water.getFill() + steamSpeed, this.water.getMaxFill()));
    }
}

