/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerMachineRadGen;
import com.hbm.inventory.gui.GUIMachineRadGen;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemWasteLong;
import com.hbm.items.special.ItemWasteShort;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.Tuple;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineRadGen
extends TileEntityMachineBase
implements IEnergyProviderMK2,
IGUIProvider,
IInfoProviderEC {
    public int[] progress = new int[12];
    public int[] maxProgress = new int[12];
    public int[] production = new int[12];
    public ItemStack[] processing = new ItemStack[12];
    protected int output;
    public long power;
    public static final long maxPower = 1000000L;
    public boolean isOn = false;
    public static final HashMap<RecipesCommon.ComparableStack, Tuple.Triplet<Integer, Integer, ItemStack>> fuels;

    public TileEntityMachineRadGen() {
        super(24);
    }

    @Override
    public String getName() {
        return "container.radGen";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            this.output = 0;
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            this.tryProvide(this.field_145850_b, this.field_145851_c - dir.offsetX * 4, this.field_145848_d, this.field_145849_e - dir.offsetZ * 4, dir.getOpposite());
            for (i = 0; i < 12; ++i) {
                if (this.processing[i] != null || this.slots[i] == null || this.getDurationFromItem(this.slots[i]) <= 0 || this.getOutputFromItem(this.slots[i]) != null && this.slots[i + 12] != null && (this.getOutputFromItem(this.slots[i]).func_77973_b() != this.slots[i + 12].func_77973_b() || this.getOutputFromItem(this.slots[i]).func_77960_j() != this.slots[i + 12].func_77960_j() || this.getOutputFromItem((ItemStack)this.slots[i]).field_77994_a + this.slots[i + 12].field_77994_a > this.slots[i + 12].func_77976_d())) continue;
                this.progress[i] = 0;
                this.maxProgress[i] = this.getDurationFromItem(this.slots[i]);
                this.production[i] = this.getPowerFromItem(this.slots[i]);
                this.processing[i] = new ItemStack(this.slots[i].func_77973_b(), 1, this.slots[i].func_77960_j());
                this.func_70298_a(i, 1);
                this.func_70296_d();
            }
            this.isOn = false;
            for (i = 0; i < 12; ++i) {
                if (this.processing[i] == null) continue;
                this.isOn = true;
                this.power += (long)this.production[i];
                this.output += this.production[i];
                int n = i;
                this.progress[n] = this.progress[n] + 1;
                if (this.progress[i] < this.maxProgress[i]) continue;
                this.progress[i] = 0;
                ItemStack out = this.getOutputFromItem(this.processing[i]);
                if (out != null) {
                    if (this.slots[i + 12] == null) {
                        this.slots[i + 12] = out;
                    } else {
                        this.slots[i + 12].field_77994_a += out.field_77994_a;
                    }
                }
                this.processing[i] = null;
                this.func_70296_d();
            }
            if (this.power > 1000000L) {
                this.power = 1000000L;
            }
            this.networkPackNT(50);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        BufferUtil.writeIntArray(buf, this.progress);
        BufferUtil.writeIntArray(buf, this.maxProgress);
        BufferUtil.writeIntArray(buf, this.production);
        buf.writeLong(this.power);
        buf.writeBoolean(this.isOn);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.progress = BufferUtil.readIntArray(buf);
        this.maxProgress = BufferUtil.readIntArray(buf);
        this.production = BufferUtil.readIntArray(buf);
        this.power = buf.readLong();
        this.isOn = buf.readBoolean();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74759_k("progress");
        if (this.progress.length != 12) {
            this.progress = new int[12];
            return;
        }
        this.maxProgress = nbt.func_74759_k("maxProgress");
        this.production = nbt.func_74759_k("production");
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        NBTTagList list = nbt.func_150295_c("progressing", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.processing.length) continue;
            this.processing[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
        this.power = nbt.func_74763_f("power");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74783_a("progress", this.progress);
        nbt.func_74783_a("maxProgress", this.maxProgress);
        nbt.func_74783_a("production", this.production);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("isOn", this.isOn);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.processing.length; ++i) {
            if (this.processing[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.processing[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("progressing", (NBTBase)list);
        nbt.func_74772_a("power", this.power);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (i >= 12 || this.getDurationFromItem(stack) <= 0) {
            return false;
        }
        if (this.slots[i] == null) {
            return true;
        }
        int size = this.slots[i].field_77994_a;
        for (int j = 0; j < 12; ++j) {
            if (this.slots[j] == null) {
                return false;
            }
            if (this.slots[j].func_77973_b() != stack.func_77973_b() || this.slots[j].func_77960_j() != stack.func_77960_j() || this.slots[j].field_77994_a >= size) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] func_94128_d(int i) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i >= 12;
    }

    private Tuple.Triplet<Integer, Integer, ItemStack> grabResult(ItemStack stack) {
        return fuels.get(new RecipesCommon.ComparableStack(stack).makeSingular());
    }

    private int getPowerFromItem(ItemStack stack) {
        Tuple.Triplet<Integer, Integer, ItemStack> result = this.grabResult(stack);
        if (result == null) {
            return 0;
        }
        return result.getX();
    }

    private int getDurationFromItem(ItemStack stack) {
        Tuple.Triplet<Integer, Integer, ItemStack> result = this.grabResult(stack);
        if (result == null) {
            return 0;
        }
        return result.getY();
    }

    private ItemStack getOutputFromItem(ItemStack stack) {
        Tuple.Triplet<Integer, Integer, ItemStack> result = this.grabResult(stack);
        if (result == null) {
            return null;
        }
        if (result.getZ() == null) {
            return null;
        }
        return result.getZ().func_77946_l();
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineRadGen(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineRadGen(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74780_a("output", (double)this.output);
    }

    static {
        int i;
        fuels = new HashMap();
        for (i = 0; i < ItemWasteShort.WasteClass.values().length; ++i) {
            fuels.put(new RecipesCommon.ComparableStack(ModItems.nuclear_waste_short, 1, i), new Tuple.Triplet<Integer, Integer, ItemStack>(1500, 36000, new ItemStack(ModItems.nuclear_waste_short_depleted, 1, i)));
            fuels.put(new RecipesCommon.ComparableStack(ModItems.nuclear_waste_short_tiny, 1, i), new Tuple.Triplet<Integer, Integer, ItemStack>(150, 3600, new ItemStack(ModItems.nuclear_waste_short_depleted_tiny, 1, i)));
        }
        for (i = 0; i < ItemWasteLong.WasteClass.values().length; ++i) {
            fuels.put(new RecipesCommon.ComparableStack(ModItems.nuclear_waste_long, 1, i), new Tuple.Triplet<Integer, Integer, ItemStack>(500, 144000, new ItemStack(ModItems.nuclear_waste_long_depleted, 1, i)));
            fuels.put(new RecipesCommon.ComparableStack(ModItems.nuclear_waste_long_tiny, 1, i), new Tuple.Triplet<Integer, Integer, ItemStack>(50, 14400, new ItemStack(ModItems.nuclear_waste_long_depleted_tiny, 1, i)));
        }
        fuels.put(new RecipesCommon.ComparableStack(ModItems.scrap_nuclear), new Tuple.Triplet<Integer, Integer, Object>(50, 6000, null));
        fuels.put(new RecipesCommon.ComparableStack(ModItems.gem_rad), new Tuple.Triplet<Integer, Integer, ItemStack>(25000, 36000, new ItemStack(Items.field_151045_i)));
    }
}

