/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.inventory.container.ContainerMachineShredder;
import com.hbm.inventory.gui.GUIMachineShredder;
import com.hbm.inventory.recipes.ShredderRecipes;
import com.hbm.items.machine.ItemBlades;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineShredder
extends TileEntityLoadedBase
implements ISidedInventory,
IEnergyReceiverMK2,
IGUIProvider {
    private ItemStack[] slots = new ItemStack[30];
    public long power;
    public int progress;
    public int soundCycle = 0;
    public static final long maxPower = 10000L;
    public static final int processingSpeed = 60;
    private static final int[] slots_io = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.machineShredder";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i < 9) {
            return ShredderRecipes.getShredderResult(stack) != null && !(stack.func_77973_b() instanceof ItemBlades);
        }
        if (i == 29) {
            return stack.func_77973_b() instanceof IBatteryItem;
        }
        if (i == 27 || i == 28) {
            return stack.func_77973_b() instanceof ItemBlades;
        }
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int side) {
        return slots_io;
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        if (slot >= 9 && slot != 27 && slot != 28 || !this.func_94041_b(slot, itemStack)) {
            return false;
        }
        if (this.slots[slot] == null) {
            return true;
        }
        int size = this.slots[slot].field_77994_a;
        for (int k = 0; k < 9; ++k) {
            if (this.slots[k] == null) {
                return false;
            }
            if (this.slots[k].func_77973_b() != itemStack.func_77973_b() || this.slots[k].func_77960_j() != itemStack.func_77960_j() || this.slots[k].field_77994_a >= size) continue;
            return false;
        }
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i >= 9 && i <= 26) {
            return true;
        }
        return i >= 27 && i <= 28 && itemStack.func_77960_j() == itemStack.func_77958_k() && itemStack.func_77958_k() > 0;
    }

    public int getDiFurnaceProgressScaled(int i) {
        return this.progress * i / 60;
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    public void func_145845_h() {
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            if (this.hasPower() && this.canProcess()) {
                ++this.progress;
                this.power -= 5L;
                if (this.progress == 60) {
                    for (int i = 27; i <= 28; ++i) {
                        if (this.slots[i].func_77958_k() <= 0) continue;
                        this.slots[i].func_77964_b(this.slots[i].func_77960_j() + 1);
                    }
                    this.progress = 0;
                    this.processItem();
                    flag1 = true;
                }
                if (this.soundCycle == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "minecart.base", this.getVolume(1.0f), 0.75f);
                }
                ++this.soundCycle;
                if (this.soundCycle >= 50) {
                    this.soundCycle = 0;
                }
            } else {
                this.progress = 0;
            }
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.progress == 0) {
                trigger = false;
            }
            if (trigger) {
                flag1 = true;
            }
            this.power = Library.chargeTEFromItems(this.slots, 29, this.power, 10000L);
            this.networkPackNT(50);
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
    }

    private void updateConnections() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
        }
    }

    public void processItem() {
        for (int inpSlot = 0; inpSlot < 9; ++inpSlot) {
            int outSlot;
            if (this.slots[inpSlot] == null || !this.hasSpace(this.slots[inpSlot])) continue;
            ItemStack inp = this.slots[inpSlot];
            ItemStack outp = ShredderRecipes.getShredderResult(inp);
            boolean flag = false;
            for (outSlot = 9; outSlot < 27; ++outSlot) {
                if (this.slots[outSlot] == null || this.slots[outSlot].func_77973_b() != outp.func_77973_b() || this.slots[outSlot].func_77960_j() != outp.func_77960_j() || this.slots[outSlot].field_77994_a + outp.field_77994_a > outp.func_77976_d()) continue;
                this.slots[outSlot].field_77994_a += outp.field_77994_a;
                --this.slots[inpSlot].field_77994_a;
                flag = true;
                break;
            }
            if (!flag) {
                for (outSlot = 9; outSlot < 27; ++outSlot) {
                    if (this.slots[outSlot] != null) continue;
                    this.slots[outSlot] = outp.func_77946_l();
                    --this.slots[inpSlot].field_77994_a;
                    break;
                }
            }
            if (this.slots[inpSlot].field_77994_a > 0) continue;
            this.slots[inpSlot] = null;
        }
    }

    public boolean canProcess() {
        if (this.slots[27] != null && this.slots[28] != null && this.getGearLeft() > 0 && this.getGearLeft() < 3 && this.getGearRight() > 0 && this.getGearRight() < 3) {
            for (int i = 0; i < 9; ++i) {
                if (this.slots[i] == null || this.slots[i].field_77994_a <= 0 || !this.hasSpace(this.slots[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSpace(ItemStack stack) {
        ItemStack result = ShredderRecipes.getShredderResult(stack);
        if (result != null) {
            for (int i = 9; i < 27; ++i) {
                if (this.slots[i] == null) {
                    return true;
                }
                if (this.slots[i] == null || !this.slots[i].func_77973_b().equals(result.func_77973_b()) || this.slots[i].field_77994_a + result.field_77994_a > result.func_77976_d()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 10000L;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    public int getGearLeft() {
        if (this.slots[27] != null && this.slots[27].func_77973_b() instanceof ItemBlades) {
            if (this.slots[27].func_77958_k() == 0) {
                return 1;
            }
            if (this.slots[27].func_77960_j() < this.slots[27].func_77973_b().func_77612_l() / 2) {
                return 1;
            }
            if (this.slots[27].func_77960_j() != this.slots[27].func_77973_b().func_77612_l()) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    public int getGearRight() {
        if (this.slots[28] != null && this.slots[28].func_77973_b() instanceof ItemBlades) {
            if (this.slots[28].func_77958_k() == 0) {
                return 1;
            }
            if (this.slots[28].func_77960_j() < this.slots[28].func_77973_b().func_77612_l() / 2) {
                return 1;
            }
            if (this.slots[28].func_77960_j() != this.slots[28].func_77973_b().func_77612_l()) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineShredder(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineShredder(player.field_71071_by, this);
    }
}

