/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.ICrucibleAcceptor;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.container.ContainerMachineStrandCaster;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineStrandCaster;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMold;
import com.hbm.items.machine.ItemScraps;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.machine.TileEntityFoundryCastingBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineStrandCaster
extends TileEntityFoundryCastingBase
implements IGUIProvider,
ICrucibleAcceptor,
ISidedInventory,
IFluidStandardTransceiver,
IInventory {
    public FluidTank water = new FluidTank(Fluids.WATER, 64000);
    public FluidTank steam = new FluidTank(Fluids.SPENTSTEAM, 64000);
    private long lastCastTick = 0L;
    AxisAlignedBB bb = null;
    public boolean isLoaded = true;

    public String getName() {
        return "container.machineStrandCaster";
    }

    @Override
    public String func_145825_b() {
        return this.getName();
    }

    public TileEntityMachineStrandCaster() {
        super(7);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int itemsCasted;
            if (this.lastType != this.type || this.lastAmount != this.amount) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.lastType = this.type;
                this.lastAmount = this.amount;
            }
            if (this.amount >= this.getCapacity()) {
                if (this.amount > this.getCapacity()) {
                    ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(this.type, Math.max(this.amount - this.getCapacity(), 0)));
                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5, scrap);
                    this.field_145850_b.func_72838_d((Entity)item);
                }
                this.amount = this.getCapacity();
            }
            if (this.amount == 0) {
                this.type = null;
            }
            this.updateConnections();
            ItemMold.Mold mold = this.getInstalledMold();
            if (mold != null && this.canProcess(itemsCasted = this.amount / mold.getCost())) {
                int minAmount = mold.getCost() * 9;
                if (this.field_145850_b.func_72820_D() >= this.lastCastTick + 200L) {
                    minAmount = mold.getCost();
                }
                if (this.amount >= minAmount) {
                    block0: for (int j = 0; j < itemsCasted; ++j) {
                        this.amount -= mold.getCost();
                        ItemStack out = mold.getOutput(this.type);
                        for (int i = 1; i < 7; ++i) {
                            if (this.slots[i] == null) {
                                this.slots[i] = out.func_77946_l();
                                continue block0;
                            }
                            if (!this.slots[i].func_77969_a(out) || this.slots[i].field_77994_a + out.field_77994_a > out.func_77976_d()) continue;
                            this.slots[i].field_77994_a += out.field_77994_a;
                            continue block0;
                        }
                    }
                    this.markChanged();
                    this.water.setFill(this.water.getFill() - this.getWaterRequired() * itemsCasted);
                    this.steam.setFill(this.steam.getFill() + this.getWaterRequired() * itemsCasted);
                    this.lastCastTick = this.field_145850_b.func_72820_D();
                }
            }
            this.networkPackNT(150);
        }
    }

    public boolean canProcess(int itemsCasted) {
        ItemMold.Mold mold = this.getInstalledMold();
        if (this.type != null && mold != null && mold.getOutput(this.type) != null) {
            for (int i = 1; i < 7; ++i) {
                if (this.slots[i] != null && (!this.slots[i].func_77969_a(mold.getOutput(this.type)) || this.slots[i].field_77994_a + mold.getOutput((NTMMaterial)this.type).field_77994_a > mold.getOutput(this.type).func_77976_d())) continue;
                return this.water.getFill() >= this.getWaterRequired() * itemsCasted && this.steam.getFill() < this.steam.getMaxFill();
            }
        }
        return false;
    }

    public DirPos[] getFluidConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ, rot), new DirPos(this.field_145851_c - rot.offsetX - dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ - dir.offsetZ, rot.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX * 5, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ * 5, rot), new DirPos(this.field_145851_c - rot.offsetX - dir.offsetX * 5, this.field_145848_d, this.field_145849_e - rot.offsetZ - dir.offsetZ * 5, rot.getOpposite())};
    }

    public int[][] getMetalPourPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new int[][]{{this.field_145851_c + rot.offsetX - dir.offsetX, this.field_145848_d + 2, this.field_145849_e + rot.offsetZ - dir.offsetZ}, {this.field_145851_c - dir.offsetX, this.field_145848_d + 2, this.field_145849_e - dir.offsetZ}, {this.field_145851_c + rot.offsetX, this.field_145848_d + 2, this.field_145849_e + rot.offsetZ}, {this.field_145851_c, this.field_145848_d + 2, this.field_145849_e}};
    }

    @Override
    public ItemMold.Mold getInstalledMold() {
        if (this.slots[0] == null) {
            return null;
        }
        if (this.slots[0].func_77973_b() == ModItems.mold) {
            return ((ItemMold)this.slots[0].func_77973_b()).getMold(this.slots[0]);
        }
        return null;
    }

    @Override
    public int getMoldSize() {
        return this.getInstalledMold().size;
    }

    @Override
    public boolean canAcceptPartialPour(World world, int x, int y, int z, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        if (side != ForgeDirection.UP) {
            return false;
        }
        for (int[] pos : this.getMetalPourPos()) {
            if (pos[0] != x || pos[1] != y || pos[2] != z) continue;
            return this.standardCheck(world, x, y, z, side, stack);
        }
        return false;
    }

    @Override
    public boolean standardCheck(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        if (this.type != null && this.type != stack.material) {
            return false;
        }
        int limit = this.getInstalledMold() != null ? this.getInstalledMold().getCost() * 9 : this.getCapacity();
        return this.amount < limit && this.getInstalledMold() != null;
    }

    @Override
    public int getCapacity() {
        ItemMold.Mold mold = this.getInstalledMold();
        return mold == null ? 50000 : mold.getCost() * 10;
    }

    private int getWaterRequired() {
        return this.getInstalledMold() != null ? 5 * this.getInstalledMold().getCost() : 50;
    }

    private void updateConnections() {
        for (DirPos pos : this.getFluidConPos()) {
            this.trySubscribe(this.water.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.sendFluid(this.steam, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    @Override
    public Mats.MaterialStack standardAdd(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        int limit;
        this.type = stack.material;
        int n = limit = this.getInstalledMold() != null ? this.getInstalledMold().getCost() * 9 : this.getCapacity();
        if (stack.amount + this.amount <= limit) {
            this.amount += stack.amount;
            return null;
        }
        int required = limit - this.amount;
        this.amount = limit;
        stack.amount -= required;
        return stack;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.steam};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.water};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.water, this.steam};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineStrandCaster(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineStrandCaster(player.field_71071_by, this);
    }

    @Override
    public void serialize(ByteBuf buf) {
        this.water.serialize(buf);
        this.steam.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.water.deserialize(buf);
        this.steam.deserialize(buf);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.water.writeToNBT(nbt, "w");
        this.steam.writeToNBT(nbt, "s");
        nbt.func_74772_a("t", this.lastCastTick);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.water.readFromNBT(nbt, "w");
        this.steam.readFromNBT(nbt, "s");
        this.lastCastTick = nbt.func_74763_f("t");
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0) {
            return stack.func_77973_b() == ModItems.mold;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{1, 2, 3, 4, 5, 6};
    }

    public void markChanged() {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return this.func_94041_b(slot, itemStack);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return !this.func_94041_b(slot, itemStack);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 7), (double)this.field_145848_d, (double)(this.field_145849_e - 7), (double)(this.field_145851_c + 7), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 7));
        }
        return this.bb;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.isLoaded = false;
    }
}

