/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IInfoProviderEC;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.container.ContainerMachineTurbine;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.inventory.gui.GUIMachineTurbine;
import com.hbm.lib.Library;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityMachineTurbine
extends TileEntityLoadedBase
implements ISidedInventory,
IEnergyProviderMK2,
IFluidStandardTransceiver,
IBufPacketReceiver,
IGUIProvider,
SimpleComponent,
IInfoProviderEC,
CompatHandler.OCComponent,
IConfigurableMachine,
IFluidCopiable {
    private ItemStack[] slots;
    public long power;
    public int age = 0;
    public FluidTank[] tanks;
    private static final int[] slots_top = new int[]{4};
    private static final int[] slots_bottom = new int[]{6};
    private static final int[] slots_side = new int[]{4};
    private String customName;
    protected double[] info = new double[3];
    public static long maxPower = 1000000L;
    public static int inputTankSize = 64000;
    public static int outputTankSize = 128000;
    public static int maxSteamPerTick = 6000;
    public static double efficiency = 0.85;

    public TileEntityMachineTurbine() {
        this.slots = new ItemStack[7];
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.STEAM, inputTankSize);
        this.tanks[1] = new FluidTank(Fluids.SPENTSTEAM, outputTankSize);
    }

    @Override
    public String getConfigName() {
        return "steamturbine";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "L:maxPower", maxPower);
        inputTankSize = IConfigurableMachine.grab(obj, "I:inputTankSize", inputTankSize);
        outputTankSize = IConfigurableMachine.grab(obj, "I:outputTankSize", outputTankSize);
        maxSteamPerTick = IConfigurableMachine.grab(obj, "I:maxSteamPerTick", maxSteamPerTick);
        efficiency = IConfigurableMachine.grab(obj, "D:efficiency", efficiency);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:maxPower").value(maxPower);
        writer.name("I:inputTankSize").value((long)inputTankSize);
        writer.name("I:outputTankSize").value((long)outputTankSize);
        writer.name("I:maxSteamPerTick").value((long)maxSteamPerTick);
        writer.name("D:efficiency").value(efficiency);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.machineTurbine";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 4 && stack != null && stack.func_77973_b() instanceof IBatteryItem;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.power = nbt.func_74763_f("power");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74772_a("power", this.power);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / maxPower;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            FT_Coolable trait;
            double eff;
            this.info = new double[3];
            ++this.age;
            if (this.age >= 2) {
                this.age = 0;
            }
            this.subscribeToAllAround(this.tanks[0].getTankType(), this);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.tryProvide(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            this.tanks[0].setType(0, 1, this.slots);
            this.tanks[0].loadTank(2, 3, this.slots);
            this.power = Library.chargeItemsFromTE(this.slots, 4, this.power, maxPower);
            FluidType in = this.tanks[0].getTankType();
            boolean valid = false;
            if (in.hasTrait(FT_Coolable.class) && (eff = (trait = in.getTrait(FT_Coolable.class)).getEfficiency(FT_Coolable.CoolingType.TURBINE) * efficiency) > 0.0) {
                this.tanks[1].setTankType(trait.coolsTo);
                int inputOps = this.tanks[0].getFill() / trait.amountReq;
                int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / trait.amountProduced;
                int cap = maxSteamPerTick / trait.amountReq;
                int ops = Math.min(inputOps, Math.min(outputOps, cap));
                this.tanks[0].setFill(this.tanks[0].getFill() - ops * trait.amountReq);
                this.tanks[1].setFill(this.tanks[1].getFill() + ops * trait.amountProduced);
                this.power = (long)((double)this.power + (double)(ops * trait.heatEnergy) * eff);
                this.info[0] = ops * trait.amountReq;
                this.info[1] = ops * trait.amountProduced;
                this.info[2] = (double)(ops * trait.heatEnergy) * eff;
                valid = true;
            }
            if (!valid) {
                this.tanks[1].setTankType(Fluids.NONE);
            }
            if (this.power > maxPower) {
                this.power = maxPower;
            }
            this.sendFluidToAll(this.tanks[1], this);
            this.tanks[1].unloadTank(5, 6, this.slots);
            this.networkPackNT(25);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeLong(this.power);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.power = buf.readLong();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_turbine";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluid(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getType(Context context, Arguments args) {
        return CompatHandler.steamTypeToInt(this.tanks[1].getTankType());
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setType(Context context, Arguments args) {
        this.tanks[0].setTankType(CompatHandler.intToSteamType(args.checkInteger(0)));
        return new Object[]{true};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.tanks[0].getFill(), this.tanks[0].getMaxFill(), this.tanks[1].getFill(), this.tanks[1].getMaxFill(), CompatHandler.steamTypeToInt(this.tanks[0].getTankType())};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineTurbine(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineTurbine(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.info[1] > 0.0);
        data.func_74780_a("consumption", this.info[0]);
        data.func_74780_a("outputmb", this.info[1]);
        data.func_74780_a("output", this.info[2]);
    }
}

