/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.container.ContainerMachineWoodBurner;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.gui.GUIMachineWoodBurner;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.module.ModuleBurnTime;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityFireboxBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineWoodBurner
extends TileEntityMachineBase
implements IFluidStandardReceiver,
IControlReceiver,
IEnergyProviderMK2,
IGUIProvider,
IInfoProviderEC,
IFluidCopiable {
    public long power;
    public static final long maxPower = 100000L;
    public int burnTime;
    public int maxBurnTime;
    public boolean liquidBurn = false;
    public boolean isOn = false;
    protected int powerGen = 0;
    public FluidTank tank = new FluidTank(Fluids.WOODOIL, 16000);
    public static ModuleBurnTime burnModule = new ModuleBurnTime().setLogTimeMod(4.0).setWoodTimeMod(2.0);
    public int ashLevelWood;
    public int ashLevelCoal;
    public int ashLevelMisc;
    AxisAlignedBB bb = null;

    public TileEntityMachineWoodBurner() {
        super(6);
    }

    @Override
    public String getName() {
        return "container.machineWoodBurner";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int toBurn;
            FT_Flammable trait;
            this.powerGen = 0;
            this.tank.setType(2, this.slots);
            this.tank.loadTank(3, 4, this.slots);
            this.power = Library.chargeItemsFromTE(this.slots, 5, this.power, 100000L);
            for (DirPos pos : this.getConPos()) {
                if (this.power > 0L) {
                    this.tryProvide(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                if (this.field_145850_b.func_82737_E() % 20L != 0L) continue;
                this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (!this.liquidBurn) {
                if (this.burnTime <= 0) {
                    if (this.slots[0] != null) {
                        int burn = burnModule.getBurnTime(this.slots[0]);
                        if (burn > 0) {
                            int threshold;
                            ItemEnums.EnumAshType type = TileEntityFireboxBase.getAshFromFuel(this.slots[0]);
                            if (type == ItemEnums.EnumAshType.WOOD) {
                                this.ashLevelWood += burn;
                            }
                            if (type == ItemEnums.EnumAshType.COAL) {
                                this.ashLevelCoal += burn;
                            }
                            if (type == ItemEnums.EnumAshType.MISC) {
                                this.ashLevelMisc += burn;
                            }
                            if (this.processAsh(this.ashLevelWood, ItemEnums.EnumAshType.WOOD, threshold = 2000)) {
                                this.ashLevelWood -= threshold;
                            }
                            if (this.processAsh(this.ashLevelCoal, ItemEnums.EnumAshType.COAL, threshold)) {
                                this.ashLevelCoal -= threshold;
                            }
                            if (this.processAsh(this.ashLevelMisc, ItemEnums.EnumAshType.MISC, threshold)) {
                                this.ashLevelMisc -= threshold;
                            }
                            this.maxBurnTime = this.burnTime = burn;
                            ItemStack container = this.slots[0].func_77973_b().getContainerItem(this.slots[0]);
                            this.func_70298_a(0, 1);
                            if (this.slots[0] == null && container != null) {
                                this.slots[0] = container.func_77946_l();
                            }
                            this.markChanged();
                        }
                    }
                } else if (this.power < 100000L && this.isOn) {
                    --this.burnTime;
                    this.powerGen += 100;
                    if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                        PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.04f);
                    }
                }
            } else if (this.power < 100000L && this.tank.getFill() > 0 && this.isOn && (trait = this.tank.getTankType().getTrait(FT_Flammable.class)) != null && (toBurn = Math.min(this.tank.getFill(), 2)) > 0) {
                this.powerGen = (int)((long)this.powerGen + trait.getHeatEnergy() * (long)toBurn / 2000L);
                this.tank.setFill(this.tank.getFill() - toBurn);
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.04f * (float)toBurn / 2.0f);
                }
            }
            this.power += (long)this.powerGen;
            if (this.power > 100000L) {
                this.power = 100000L;
            }
            this.networkPackNT(25);
        } else if (this.powerGen > 0) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.5 - (double)dir.offsetX + (double)rot.offsetX, (double)(this.field_145848_d + 4), (double)this.field_145849_e + 0.5 - (double)dir.offsetZ + (double)rot.offsetZ, 0.0, 0.05, 0.0);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.burnTime);
        buf.writeInt(this.powerGen);
        buf.writeInt(this.maxBurnTime);
        buf.writeBoolean(this.isOn);
        buf.writeBoolean(this.liquidBurn);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.burnTime = buf.readInt();
        this.powerGen = buf.readInt();
        this.maxBurnTime = buf.readInt();
        this.isOn = buf.readBoolean();
        this.liquidBurn = buf.readBoolean();
        this.tank.deserialize(buf);
    }

    private DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite())};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
        this.isOn = nbt.func_74767_n("isOn");
        this.liquidBurn = nbt.func_74767_n("liquidBurn");
        this.tank.readFromNBT(nbt, "t");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("maxBurnTime", this.maxBurnTime);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("liquidBurn", this.liquidBurn);
        this.tank.writeToNBT(nbt, "t");
    }

    protected boolean processAsh(int level, ItemEnums.EnumAshType type, int threshold) {
        if (level >= threshold) {
            if (this.slots[1] == null) {
                this.slots[1] = OreDictManager.DictFrame.fromOne(ModItems.powder_ash, (Enum)type);
                return true;
            }
            if (this.slots[1].field_77994_a < this.slots[1].func_77976_d() && this.slots[1].func_77973_b() == ModItems.powder_ash && this.slots[1].func_77960_j() == type.ordinal()) {
                ++this.slots[1].field_77994_a;
                return true;
            }
        }
        return false;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toggle")) {
            this.isOn = !this.isOn;
            this.markChanged();
        }
        if (data.func_74764_b("switch")) {
            this.liquidBurn = !this.liquidBurn;
            this.markChanged();
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineWoodBurner(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineWoodBurner(player.field_71071_by, this);
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{0, 1};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 0 && burnModule.getBurnTime(itemStack) > 0;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot == 1;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        ForgeDirection rot = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return dir == rot.getOpposite();
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        ForgeDirection rot = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return dir == rot.getOpposite();
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 6), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74757_a("active", this.isOn);
        if (this.liquidBurn) {
            data.func_74780_a("consumption", 1.0);
        }
        data.func_74780_a("output", (double)this.power);
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tank;
    }
}

