/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.EntityProcessorCrossSmooth;
import com.hbm.explosion.vanillant.standard.ExplosionEffectWeapon;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.ICopiable;
import com.hbm.inventory.container.ContainerMicrowave;
import com.hbm.inventory.gui.GUIMicrowave;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityMicrowave
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IGUIProvider,
SimpleComponent,
CompatHandler.OCComponent,
ICopiable {
    public long power;
    public static final long maxPower = 50000L;
    public static final int consumption = 50;
    public static final int maxTime = 300;
    public int time;
    public int speed;
    public static final int maxSpeed = 5;

    public TileEntityMicrowave() {
        super(3);
    }

    @Override
    public String getName() {
        return "container.microwave";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            this.power = Library.chargeTEFromItems(this.slots, 2, this.power, 50000L);
            if (this.canProcess()) {
                if (this.speed >= 5) {
                    this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                    ExplosionVNT vnt = new ExplosionVNT(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 5.0f);
                    vnt.setEntityProcessor(new EntityProcessorCrossSmooth(1.0, 50.0f));
                    vnt.setPlayerProcessor(new PlayerProcessorStandard());
                    vnt.setSFX(new ExplosionEffectWeapon(10, 2.5f, 1.0f));
                    vnt.explode();
                    return;
                }
                if (this.time >= 300) {
                    this.process();
                    this.time = 0;
                }
                if (this.canProcess()) {
                    this.power -= 50L;
                    this.time += this.speed * 2;
                }
            }
            this.networkPackNT(50);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.time);
        buf.writeInt(this.speed);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.time = buf.readInt();
        this.speed = buf.readInt();
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (value == 0) {
            ++this.speed;
        }
        if (value == 1) {
            --this.speed;
        }
        if (this.speed < 0) {
            this.speed = 0;
        }
        if (this.speed > 5) {
            this.speed = 5;
        }
    }

    private void process() {
        ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]).func_77946_l();
        if (this.slots[1] == null) {
            this.slots[1] = stack;
        } else {
            this.slots[1].field_77994_a += stack.field_77994_a;
        }
        this.func_70298_a(0, 1);
        this.func_70296_d();
    }

    private boolean canProcess() {
        if (this.speed == 0) {
            return false;
        }
        if (this.power < 50L) {
            return false;
        }
        if (this.slots[0] != null && FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]) != null) {
            ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
            if (!(this.slots[0].func_77973_b() instanceof ItemFood) && !(stack.func_77973_b() instanceof ItemFood)) {
                return false;
            }
            if (this.slots[1] == null) {
                return true;
            }
            if (!stack.func_77969_a(this.slots[1])) {
                return false;
            }
            return stack.field_77994_a + this.slots[1].field_77994_a <= stack.func_77976_d();
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 0 && FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 50000L;
    }

    public int getProgressScaled(int i) {
        return this.time * i / 300;
    }

    public int getSpeedScaled(int i) {
        return this.speed * i / 5;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.speed = nbt.func_74762_e("speed");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("speed", this.speed);
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "microwave";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] test(Context context, Arguments args) {
        return new Object[]{"This is a testing device for everything OC."};
    }

    @Callback(direct=true, getter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] variableget(Context context, Arguments args) {
        return new Object[]{this.speed, "test of the `getter` callback function"};
    }

    @Callback(direct=true, setter=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] variableset(Context context, Arguments args) {
        this.speed = MathHelper.func_76125_a((int)args.checkInteger(0), (int)0, (int)5);
        return new Object[]{"test of the `setter` callback function"};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMicrowave(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMicrowave(player.field_71071_by, this);
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("microSpeed", this.speed);
        return null;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        if (nbt.func_74764_b("microSpeed")) {
            this.speed = nbt.func_74762_e("microSpeed");
        }
    }

    @Override
    public String[] infoForDisplay(World world, int x, int y, int z) {
        return new String[]{"copyTool.speed"};
    }
}

