/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.albion;

import com.hbm.inventory.container.ContainerPADetector;
import com.hbm.inventory.gui.GUIPADetector;
import com.hbm.inventory.recipes.ParticleAcceleratorRecipes;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.machine.albion.IParticleUser;
import com.hbm.tileentity.machine.albion.TileEntityCooledBase;
import com.hbm.tileentity.machine.albion.TileEntityPASource;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPADetector
extends TileEntityCooledBase
implements IGUIProvider,
IParticleUser {
    public static final long usage = 100000L;
    AxisAlignedBB bb = null;

    public TileEntityPADetector() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.paDetector";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
        }
        super.func_145845_h();
    }

    @Override
    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - rot.offsetX * 5, this.field_145848_d, this.field_145849_e - rot.offsetZ * 5, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 5, this.field_145848_d + 1, this.field_145849_e - rot.offsetZ * 5, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 5, this.field_145848_d - 1, this.field_145849_e - rot.offsetZ * 5, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 5 + dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 5 + dir.offsetZ, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 5 - dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 5 - dir.offsetZ, rot.getOpposite())};
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 1 || slot == 2;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 3 || slot == 4;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{1, 2, 3, 4};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 5));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerPADetector(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIPADetector(player.field_71071_by, this);
    }

    @Override
    public boolean canParticleEnter(TileEntityPASource.Particle particle, ForgeDirection dir, int x, int y, int z) {
        ForgeDirection detectorDir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.DOWN);
        BlockPos input = new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e).offset(detectorDir, -4);
        return input.compare(x, y, z) && detectorDir == dir;
    }

    @Override
    public void onEnter(TileEntityPASource.Particle particle, ForgeDirection dir) {
        particle.invalid = true;
        if (particle.defocus > 0) {
            particle.crash(TileEntityPASource.PAState.CRASH_DEFOCUS);
            return;
        }
        if (this.power < 100000L) {
            particle.crash(TileEntityPASource.PAState.CRASH_NOPOWER);
            return;
        }
        if (!this.isCool()) {
            particle.crash(TileEntityPASource.PAState.CRASH_NOCOOL);
            return;
        }
        this.power -= 100000L;
        for (ParticleAcceleratorRecipes.ParticleAcceleratorRecipe recipe : ParticleAcceleratorRecipes.recipes) {
            if (!recipe.matchesRecipe(particle.input1, particle.input2)) continue;
            if (particle.momentum < recipe.momentum) {
                particle.crash(TileEntityPASource.PAState.CRASH_UNDERSPEED);
                return;
            }
            if (this.canAccept(recipe)) {
                if (recipe.output1.func_77973_b().hasContainerItem(recipe.output1)) {
                    this.func_70298_a(1, 1);
                }
                if (recipe.output2 != null && recipe.output2.func_77973_b().hasContainerItem(recipe.output2)) {
                    this.func_70298_a(2, 1);
                }
                if (this.slots[3] == null) {
                    this.slots[3] = recipe.output1.func_77946_l();
                } else {
                    this.slots[3].field_77994_a += recipe.output1.field_77994_a;
                }
                if (recipe.output2 != null) {
                    if (this.slots[4] == null) {
                        this.slots[4] = recipe.output2.func_77946_l();
                    } else {
                        this.slots[4].field_77994_a += recipe.output2.field_77994_a;
                    }
                }
            }
            particle.crash(TileEntityPASource.PAState.SUCCESS);
            return;
        }
        particle.crash(TileEntityPASource.PAState.CRASH_NORECIPE);
    }

    public boolean canAccept(ParticleAcceleratorRecipes.ParticleAcceleratorRecipe recipe) {
        return this.checkSlot(recipe.output1, 1, 3) && this.checkSlot(recipe.output2, 2, 4);
    }

    public boolean checkSlot(ItemStack output, int containerSlot, int outputSlot) {
        if (output != null) {
            if (this.slots[outputSlot] != null && (this.slots[outputSlot].func_77973_b() != output.func_77973_b() || this.slots[outputSlot].func_77960_j() != output.func_77960_j() || this.slots[outputSlot].field_77994_a + output.field_77994_a > output.func_77976_d())) {
                return false;
            }
            if (output.func_77973_b().hasContainerItem(output)) {
                ItemStack container = output.func_77973_b().getContainerItem(output);
                if (this.slots[containerSlot] == null || this.slots[containerSlot].func_77973_b() != container.func_77973_b() || this.slots[containerSlot].func_77960_j() != container.func_77960_j()) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public BlockPos getExitPos(TileEntityPASource.Particle particle) {
        return null;
    }
}

