/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.albion;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerPADipole;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.gui.GUIPADipole;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemPACoil;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.machine.albion.IParticleUser;
import com.hbm.tileentity.machine.albion.TileEntityCooledBase;
import com.hbm.tileentity.machine.albion.TileEntityPASource;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPADipole
extends TileEntityCooledBase
implements IGUIProvider,
IControlReceiver,
IParticleUser {
    public int dirLower;
    public int dirUpper;
    public int dirRedstone;
    public int threshold;
    public static final long usage = 100000L;
    AxisAlignedBB bb = null;

    public TileEntityPADipole() {
        super(2);
    }

    @Override
    public long getMaxPower() {
        return 2500000L;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
    }

    @Override
    public String getName() {
        return "container.paDipole";
    }

    @Override
    public boolean canParticleEnter(TileEntityPASource.Particle particle, ForgeDirection dir, int x, int y, int z) {
        return this.field_145848_d == y && (this.field_145851_c == x || this.field_145849_e == z);
    }

    @Override
    public void onEnter(TileEntityPASource.Particle particle, ForgeDirection dir) {
        ItemPACoil.EnumCoilType type = null;
        int mult = 1;
        if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.pa_coil) {
            type = (ItemPACoil.EnumCoilType)((Object)EnumUtil.grabEnumSafely(ItemPACoil.EnumCoilType.class, this.slots[1].func_77960_j()));
            if (type.diMin > particle.momentum) {
                mult *= 10;
            }
            if (type.diDistMin > particle.distanceTraveled) {
                mult *= 10;
            }
        }
        if (!this.isCool()) {
            particle.crash(TileEntityPASource.PAState.CRASH_NOCOOL);
        }
        if (this.power < 100000L * (long)mult) {
            particle.crash(TileEntityPASource.PAState.CRASH_NOPOWER);
        }
        if (type == null) {
            particle.crash(TileEntityPASource.PAState.CRASH_NOCOIL);
        }
        if (type != null && type.diMax < particle.momentum) {
            particle.crash(TileEntityPASource.PAState.CRASH_OVERSPEED);
        }
        if (particle.invalid) {
            return;
        }
        particle.resetDistance();
        this.power -= 100000L * (long)mult;
    }

    @Override
    public BlockPos getExitPos(TileEntityPASource.Particle particle) {
        ForgeDirection dir;
        if (particle.momentum >= this.threshold) {
            ForgeDirection dir2;
            particle.dir = dir2 = TileEntityPADipole.ditToForgeDir(this.checkRedstone() ? this.dirRedstone : this.dirUpper);
            return new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e).offset(dir2, 2);
        }
        particle.dir = dir = TileEntityPADipole.ditToForgeDir(this.dirLower);
        return new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e).offset(dir, 2);
    }

    public boolean checkRedstone() {
        for (DirPos pos : this.getConPos()) {
            if (!this.field_145850_b.func_72864_z(pos.getX(), pos.getY(), pos.getZ())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
        }
        super.func_145845_h();
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.dirLower);
        buf.writeInt(this.dirUpper);
        buf.writeInt(this.dirRedstone);
        buf.writeInt(this.threshold);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.dirLower = buf.readInt();
        this.dirUpper = buf.readInt();
        this.dirRedstone = buf.readInt();
        this.threshold = buf.readInt();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.dirLower = nbt.func_74762_e("dirLower");
        this.dirUpper = nbt.func_74762_e("dirUpper");
        this.dirRedstone = nbt.func_74762_e("dirRedstone");
        this.threshold = nbt.func_74762_e("threshold");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("dirLower", this.dirLower);
        nbt.func_74768_a("dirUpper", this.dirUpper);
        nbt.func_74768_a("dirRedstone", this.dirRedstone);
        nbt.func_74768_a("threshold", this.threshold);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e + 1, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e - 1, Library.POS_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d - 2, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c - 1, this.field_145848_d - 2, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e + 1, Library.NEG_Y), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e - 1, Library.NEG_Y)};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerPADipole(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIPADipole(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("lower")) {
            ++this.dirLower;
        }
        if (data.func_74764_b("upper")) {
            ++this.dirUpper;
        }
        if (data.func_74764_b("redstone")) {
            ++this.dirRedstone;
        }
        if (data.func_74764_b("threshold")) {
            this.threshold = data.func_74762_e("threshold");
        }
        if (this.dirLower > 3) {
            this.dirLower -= 4;
        }
        if (this.dirUpper > 3) {
            this.dirUpper -= 4;
        }
        if (this.dirRedstone > 3) {
            this.dirRedstone -= 4;
        }
        this.threshold = MathHelper.func_76125_a((int)this.threshold, (int)0, (int)999999999);
    }

    public static ForgeDirection ditToForgeDir(int dir) {
        if (dir == 1) {
            return ForgeDirection.EAST;
        }
        if (dir == 2) {
            return ForgeDirection.SOUTH;
        }
        if (dir == 3) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.NORTH;
    }
}

