/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.container.ContainerMachineOilWell;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineOilWell;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.machine.oil.TileEntityOilDrillBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.world.feature.OilSpot;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class TileEntityMachineFrackingTower
extends TileEntityOilDrillBase {
    protected static int maxPower = 5000000;
    protected static int consumption = 5000;
    protected static int solutionRequired = 10;
    protected static int delay = 20;
    protected static int oilPerDepsoit = 1000;
    protected static int gasPerDepositMin = 100;
    protected static int gasPerDepositMax = 500;
    protected static double drainChance = 0.02;
    protected static int oilPerBedrockDepsoit = 100;
    protected static int gasPerBedrockDepositMin = 10;
    protected static int gasPerBedrockDepositMax = 50;
    protected static int destructionRange = 75;

    public TileEntityMachineFrackingTower() {
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(Fluids.OIL, 64000);
        this.tanks[1] = new FluidTank(Fluids.GAS, 64000);
        this.tanks[2] = new FluidTank(Fluids.FRACKSOL, 64000);
    }

    @Override
    public String getName() {
        return "container.frackingTower";
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public int getPowerReq() {
        return consumption;
    }

    @Override
    public int getDelay() {
        return delay;
    }

    @Override
    public int getDrillDepth() {
        return 0;
    }

    @Override
    public boolean canPump() {
        boolean b;
        boolean bl = b = this.tanks[2].getFill() >= solutionRequired;
        if (!b) {
            this.indicator = 3;
        }
        return b;
    }

    @Override
    public boolean canSuckBlock(Block b) {
        return super.canSuckBlock(b) || b == ModBlocks.ore_bedrock_oil;
    }

    @Override
    public void doSuck(int x, int y, int z) {
        super.doSuck(x, y, z);
        if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.ore_bedrock_oil) {
            this.onSuck(x, y, z);
        }
    }

    @Override
    public void onSuck(int x, int y, int z) {
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        int oil = 0;
        int gas = 0;
        if (b == ModBlocks.ore_oil) {
            oil = oilPerDepsoit;
            gas = gasPerDepositMin + this.field_145850_b.field_73012_v.nextInt(gasPerDepositMax - gasPerDepositMin + 1);
            if (this.field_145850_b.field_73012_v.nextDouble() < drainChance) {
                this.field_145850_b.func_147449_b(x, y, z, ModBlocks.ore_oil_empty);
            }
        }
        if (b == ModBlocks.ore_bedrock_oil) {
            oil = oilPerBedrockDepsoit;
            gas = gasPerBedrockDepositMin + this.field_145850_b.field_73012_v.nextInt(gasPerBedrockDepositMax - gasPerBedrockDepositMin + 1);
        }
        this.tanks[0].setFill(this.tanks[0].getFill() + oil);
        if (this.tanks[0].getFill() > this.tanks[0].getMaxFill()) {
            this.tanks[0].setFill(this.tanks[0].getMaxFill());
        }
        this.tanks[1].setFill(this.tanks[1].getFill() + gas);
        if (this.tanks[1].getFill() > this.tanks[1].getMaxFill()) {
            this.tanks[1].setFill(this.tanks[1].getMaxFill());
        }
        this.tanks[2].setFill(this.tanks[2].getFill() - solutionRequired);
        OilSpot.generateOilSpot(this.field_145850_b, this.field_145851_c, this.field_145849_e, destructionRange, 10, false);
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[2]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z)};
    }

    @Override
    protected void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[2].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    @Override
    public String getConfigName() {
        return "frackingtower";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "I:powerCap", maxPower);
        consumption = IConfigurableMachine.grab(obj, "I:consumption", consumption);
        solutionRequired = IConfigurableMachine.grab(obj, "I:solutionRequired", solutionRequired);
        delay = IConfigurableMachine.grab(obj, "I:delay", delay);
        oilPerDepsoit = IConfigurableMachine.grab(obj, "I:oilPerDeposit", oilPerDepsoit);
        gasPerDepositMin = IConfigurableMachine.grab(obj, "I:gasPerDepositMin", gasPerDepositMin);
        gasPerDepositMax = IConfigurableMachine.grab(obj, "I:gasPerDepositMax", gasPerDepositMax);
        drainChance = IConfigurableMachine.grab(obj, "D:drainChance", drainChance);
        oilPerBedrockDepsoit = IConfigurableMachine.grab(obj, "I:oilPerBedrockDeposit", oilPerBedrockDepsoit);
        gasPerBedrockDepositMin = IConfigurableMachine.grab(obj, "I:gasPerBedrockDepositMin", gasPerBedrockDepositMin);
        gasPerBedrockDepositMax = IConfigurableMachine.grab(obj, "I:gasPerBedrockDepositMax", gasPerBedrockDepositMax);
        destructionRange = IConfigurableMachine.grab(obj, "I:destructionRange", destructionRange);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:powerCap").value((long)maxPower);
        writer.name("I:consumption").value((long)consumption);
        writer.name("I:solutionRequired").value((long)solutionRequired);
        writer.name("I:delay").value((long)delay);
        writer.name("I:oilPerDeposit").value((long)oilPerDepsoit);
        writer.name("I:gasPerDepositMin").value((long)gasPerDepositMin);
        writer.name("I:gasPerDepositMax").value((long)gasPerDepositMax);
        writer.name("D:drainChance").value(drainChance);
        writer.name("I:oilPerBedrockDeposit").value((long)oilPerBedrockDepsoit);
        writer.name("I:gasPerBedrockDepositMin").value((long)gasPerBedrockDepositMin);
        writer.name("I:gasPerBedrockDepositMax").value((long)gasPerBedrockDepositMax);
        writer.name("I:destructionRange").value((long)destructionRange);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineOilWell(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineOilWell(player.field_71071_by, this);
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_fracking_tower));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 25 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+" + level * 10 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.AFTERBURN) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.burn", level * 10, level * 50));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }
}

