/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerPyroOven;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIPyroOven;
import com.hbm.inventory.recipes.PyroOvenRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachinePyroOven
extends TileEntityMachinePolluting
implements IEnergyReceiverMK2,
IFluidStandardTransceiver,
IGUIProvider,
IUpgradeInfoProvider,
IFluidCopiable {
    public long power;
    public static final long maxPower = 10000000L;
    public boolean isVenting;
    public boolean isProgressing;
    public float progress;
    public static int consumption = 10000;
    public int prevAnim;
    public int anim = 0;
    public FluidTank[] tanks;
    private AudioWrapper audio;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    protected PyroOvenRecipes.PyroOvenRecipe lastValidRecipe;
    AxisAlignedBB bb = null;

    public TileEntityMachinePyroOven() {
        super(6, 50);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.NONE, 24000);
        this.tanks[1] = new FluidTank(Fluids.NONE, 24000);
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && stack.func_77973_b() instanceof ItemMachineUpgrade && i >= 4 && i <= 5) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    @Override
    public String getName() {
        return "container.machinePyroOven";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 10000000L);
            this.tanks[0].setType(3, this.slots);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                if (this.tanks[0].getTankType() != Fluids.NONE) {
                    this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                if (this.tanks[1].getFill() <= 0) continue;
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
            if (this.smoke.getFill() > 0) {
                this.sendFluid(this.smoke, this.field_145850_b, this.field_145851_c - rot.offsetX, this.field_145848_d + 3, this.field_145849_e - rot.offsetZ, Library.POS_Y);
            }
            this.upgradeManager.checkSlots(this, this.slots, 4, 5);
            int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerSaving = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            int overdrive = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.isProgressing = false;
            this.isVenting = false;
            if (this.canProcess()) {
                PyroOvenRecipes.PyroOvenRecipe recipe = this.getMatchingRecipe();
                this.progress += 1.0f / (float)Math.max((recipe.duration - speed * (recipe.duration / 4)) / (overdrive * 2 + 1), 1);
                this.isProgressing = true;
                this.power -= (long)TileEntityMachinePyroOven.getConsumption(speed + overdrive * 2, powerSaving);
                if (this.progress >= 1.0f) {
                    this.progress = 0.0f;
                    this.finishRecipe(recipe);
                    this.func_70296_d();
                }
                this.pollute(PollutionHandler.PollutionType.SOOT, 0.04f);
            } else {
                this.progress = 0.0f;
            }
            this.networkPackNT(50);
        } else {
            this.prevAnim = this.anim++;
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
            if (this.isProgressing) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updateVolume(this.getVolume(1.0f));
                if (MainRegistry.proxy.me().func_70011_f((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 3), (double)this.field_145849_e + 0.5) < 50.0) {
                    if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                        this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 - (double)rot.offsetX - (double)dir.offsetX * 0.875, (double)(this.field_145848_d + 3), (double)this.field_145849_e + 0.5 - (double)rot.offsetZ - (double)dir.offsetZ * 0.875, 0.0, 0.05, 0.0);
                    }
                    if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                        this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 - (double)rot.offsetX - (double)dir.offsetX * 2.375, (double)(this.field_145848_d + 3), (double)this.field_145849_e + 0.5 - (double)rot.offsetZ - (double)dir.offsetZ * 2.375, 0.0, 0.05, 0.0);
                    }
                    if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                        this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 - (double)rot.offsetX + (double)dir.offsetX * 0.875, (double)(this.field_145848_d + 3), (double)this.field_145849_e + 0.5 - (double)rot.offsetZ + (double)dir.offsetZ * 0.875, 0.0, 0.05, 0.0);
                    }
                    if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                        this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.5 - (double)rot.offsetX + (double)dir.offsetX * 2.375, (double)(this.field_145848_d + 3), (double)this.field_145849_e + 0.5 - (double)rot.offsetZ + (double)dir.offsetZ * 2.375, 0.0, 0.05, 0.0);
                    }
                }
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
            if (this.isVenting && this.field_145850_b.func_82737_E() % 2L == 0L) {
                NBTTagCompound fx = new NBTTagCompound();
                fx.func_74778_a("type", "tower");
                fx.func_74776_a("lift", 10.0f);
                fx.func_74776_a("base", 0.25f);
                fx.func_74776_a("max", 2.5f);
                fx.func_74768_a("life", 100 + this.field_145850_b.field_73012_v.nextInt(20));
                fx.func_74768_a("color", 0x202020);
                fx.func_74780_a("posX", (double)this.field_145851_c + 0.5 - (double)rot.offsetX);
                fx.func_74780_a("posY", (double)(this.field_145848_d + 3));
                fx.func_74780_a("posZ", (double)this.field_145849_e + 0.5 - (double)rot.offsetZ);
                MainRegistry.proxy.effectNT(fx);
            }
        }
    }

    public static int getConsumption(int speed, int powerSaving) {
        return (int)((double)consumption * Math.pow(speed + 1, 2.0)) / (powerSaving + 1);
    }

    public PyroOvenRecipes.PyroOvenRecipe getMatchingRecipe() {
        if (this.lastValidRecipe != null && this.doesRecipeMatch(this.lastValidRecipe)) {
            return this.lastValidRecipe;
        }
        for (PyroOvenRecipes.PyroOvenRecipe rec : PyroOvenRecipes.recipes) {
            if (!this.doesRecipeMatch(rec)) continue;
            this.lastValidRecipe = rec;
            return rec;
        }
        return null;
    }

    public boolean doesRecipeMatch(PyroOvenRecipes.PyroOvenRecipe recipe) {
        if (recipe.inputFluid != null && this.tanks[0].getTankType() != recipe.inputFluid.type) {
            return false;
        }
        if (recipe.inputItem != null) {
            if (this.slots[1] == null) {
                return false;
            }
            if (!recipe.inputItem.matchesRecipe(this.slots[1], true)) {
                return false;
            }
        } else if (this.slots[1] != null) {
            return false;
        }
        return true;
    }

    public boolean canProcess() {
        int speed = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
        int powerSaving = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
        if (this.power < (long)TileEntityMachinePyroOven.getConsumption(speed, powerSaving)) {
            return false;
        }
        PyroOvenRecipes.PyroOvenRecipe recipe = this.getMatchingRecipe();
        if (recipe == null) {
            return false;
        }
        if (recipe.inputFluid != null && this.tanks[0].getFill() < recipe.inputFluid.fill) {
            return false;
        }
        if (recipe.inputItem != null && this.slots[1].field_77994_a < recipe.inputItem.stacksize) {
            return false;
        }
        if (recipe.outputFluid != null && recipe.outputFluid.fill + this.tanks[1].getFill() > this.tanks[1].getMaxFill() && recipe.outputFluid.type == this.tanks[1].getTankType()) {
            return false;
        }
        if (recipe.outputItem != null && this.slots[2] != null && recipe.outputItem.field_77994_a + this.slots[2].field_77994_a > this.slots[2].func_77976_d()) {
            return false;
        }
        if (recipe.outputItem != null && this.slots[2] != null && recipe.outputItem.func_77973_b() != this.slots[2].func_77973_b()) {
            return false;
        }
        return recipe.outputItem == null || this.slots[2] == null || recipe.outputItem.func_77960_j() == this.slots[2].func_77960_j();
    }

    public void finishRecipe(PyroOvenRecipes.PyroOvenRecipe recipe) {
        if (recipe.outputItem != null) {
            if (this.slots[2] == null) {
                this.slots[2] = recipe.outputItem.func_77946_l();
            } else {
                this.slots[2].field_77994_a += recipe.outputItem.field_77994_a;
            }
        }
        if (recipe.outputFluid != null) {
            this.tanks[1].setTankType(recipe.outputFluid.type);
            this.tanks[1].setFill(this.tanks[1].getFill() + recipe.outputFluid.fill);
        }
        if (recipe.inputItem != null) {
            this.func_70298_a(1, recipe.inputItem.stacksize);
        }
        if (recipe.inputFluid != null) {
            this.tanks[0].setFill(this.tanks[0].getFill() - recipe.inputFluid.fill);
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c + dir.offsetX * 1 + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - dir.offsetX * 1 + rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ * 1 + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * 3, rot)};
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
        buf.writeLong(this.power);
        buf.writeBoolean(this.isVenting);
        buf.writeBoolean(this.isProgressing);
        buf.writeFloat(this.progress);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
        this.power = buf.readLong();
        this.isVenting = buf.readBoolean();
        this.isProgressing = buf.readBoolean();
        this.progress = buf.readFloat();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
        this.progress = nbt.func_74760_g("prog");
        this.power = nbt.func_74763_f("power");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
        nbt.func_74776_a("prog", this.progress);
        nbt.func_74772_a("power", this.power);
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{1, 2};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 1;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 2;
    }

    @Override
    public void pollute(PollutionHandler.PollutionType type, float amount) {
        FluidTank tank = type == PollutionHandler.PollutionType.SOOT ? this.smoke : (type == PollutionHandler.PollutionType.HEAVYMETAL ? this.smoke_leaded : this.smoke_poison);
        int fluidAmount = (int)Math.ceil(amount * 100.0f);
        tank.setFill(tank.getFill() + fluidAmount);
        if (tank.getFill() > tank.getMaxFill()) {
            int overflow = tank.getFill() - tank.getMaxFill();
            tank.setFill(tank.getMaxFill());
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, type, (float)overflow / 100.0f);
            this.isVenting = true;
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.pyroOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 15.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)((double)this.field_145848_d + 3.5), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1], this.smoke};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.smoke};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerPyroOven(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIPyroOven(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_pyrooven));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 25 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + (Math.pow(level + 1, 2.0) * 100.0 - 100.0) + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + (100 - 100 / (level + 1)) + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 3);
        return upgrades;
    }
}

