/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.pile;

import api.hbm.block.IPileNeutronReceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.machine.pile.TileEntityPileBase;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class TileEntityPileFuel
extends TileEntityPileBase
implements IPileNeutronReceiver {
    public int heat;
    public static final int maxHeat = 1000;
    public int neutrons;
    public int lastNeutrons;
    public int progress;
    public static final int maxProgress = GeneralConfig.enable528 ? 75000 : 50000;

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.dissipateHeat();
            this.checkRedstone(this.react());
            this.transmute();
            if (this.heat >= 1000) {
                this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 4.0f, true, true);
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.gas_radon_dense);
            }
            if (this.field_145850_b.field_73012_v.nextFloat() * 2.0f <= (float)this.heat / 1000.0f) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaExt");
                data.func_74778_a("mode", "smoke");
                data.func_74780_a("mY", 0.05);
                PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, this.field_145848_d + 1, (double)this.field_145849_e + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 20.0));
            }
            if (this.progress >= maxProgress) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.block_graphite_plutonium, this.func_145832_p() & 7, 3);
            }
        }
    }

    private void dissipateHeat() {
        this.heat = (int)((double)this.heat - ((this.func_145832_p() & 4) == 4 ? (double)this.heat * 0.065 : (double)this.heat * 0.05));
    }

    private int react() {
        int reaction = (int)((double)this.neutrons * (1.0 - (double)this.heat / 1000.0 * 0.5));
        this.lastNeutrons = this.neutrons;
        this.neutrons = 0;
        int lastProgress = this.progress;
        this.progress += reaction;
        if (reaction <= 0) {
            return lastProgress;
        }
        this.heat += reaction;
        for (int i = 0; i < 12; ++i) {
            this.castRay((int)Math.max((double)reaction * 0.25, 1.0));
        }
        return lastProgress;
    }

    private void checkRedstone(int lastProgress) {
        int newLevel;
        int lastLevel = MathHelper.func_76125_a((int)(lastProgress * 16 / maxProgress), (int)0, (int)15);
        if (lastLevel != (newLevel = MathHelper.func_76125_a((int)(this.progress * 16 / maxProgress), (int)0, (int)15))) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    private void transmute() {
        if ((this.func_145832_p() & 8) == 8) {
            if (this.progress < maxProgress - 1000) {
                this.progress = maxProgress - 1000;
            }
            return;
        }
        if (this.progress >= maxProgress - 1000) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() | 8, 3);
            return;
        }
    }

    @Override
    public void receiveNeutrons(int n) {
        this.neutrons += n;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74762_e("heat");
        this.progress = nbt.func_74762_e("progress");
        this.neutrons = nbt.func_74762_e("neutrons");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("neutrons", this.neutrons);
    }
}

