/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.lib.Library;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import cpw.mods.fml.common.Optional;
import io.netty.buffer.ByteBuf;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRBMKCooler
extends TileEntityRBMKBase
implements IFluidStandardReceiver,
SimpleComponent,
CompatHandler.OCComponent {
    private FluidTank tank = new FluidTank(Fluids.CRYOGEL, 8000);
    private int lastCooled;

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y);
            }
            if ((int)this.heat > 750) {
                int heatProvided = (int)(this.heat - 750.0);
                int cooling = Math.min(heatProvided, this.tank.getFill());
                this.heat -= (double)cooling;
                this.tank.setFill(this.tank.getFill() - cooling);
                this.lastCooled = cooling;
                if (this.lastCooled > 0) {
                    List entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d + 4), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 8), (double)(this.field_145849_e + 1)));
                    for (Entity e : entities) {
                        e.func_70015_d(5);
                        e.func_70097_a(DamageSource.field_76372_a, 10.0f);
                    }
                }
            } else {
                this.lastCooled = 0;
            }
        } else if (this.lastCooled > 100) {
            for (int i = 0; i < 2; ++i) {
                this.field_145850_b.func_72869_a("flame", (double)this.field_145851_c + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)this.field_145848_d + 4.5, (double)this.field_145849_e + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, 0.0, 0.2, 0.0);
                this.field_145850_b.func_72869_a("smoke", (double)this.field_145851_c + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)this.field_145848_d + 4.5, (double)this.field_145849_e + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, 0.0, 0.2, 0.0);
            }
            if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                this.field_145850_b.func_72869_a("lava", (double)this.field_145851_c + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)this.field_145848_d + 4.5, (double)this.field_145849_e + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, 0.0, 0.0, 0.0);
            }
        } else if (this.lastCooled > 50) {
            for (int i = 0; i < 2; ++i) {
                this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)this.field_145848_d + 4.5, (double)this.field_145849_e + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, this.field_145850_b.field_73012_v.nextGaussian() * 0.05, 0.2, this.field_145850_b.field_73012_v.nextGaussian() * 0.05);
            }
        } else if (this.lastCooled > 0 && this.field_145850_b.func_82737_E() % 2L == 0L) {
            this.field_145850_b.func_72869_a("cloud", (double)this.field_145851_c + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)this.field_145848_d + 4.5, (double)this.field_145849_e + 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, 0.0, 0.2, 0.0);
        }
        super.func_145845_h();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "cryo");
        this.lastCooled = nbt.func_74762_e("cooled");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "cryo");
        nbt.func_74768_a("cooled", this.lastCooled);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.tank.serialize(buf);
        buf.writeInt(this.lastCooled);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.tank.deserialize(buf);
        this.lastCooled = buf.readInt();
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.COOLER;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "rbmk_cooler";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getHeat(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCryo(Context context, Arguments args) {
        return new Object[]{this.tank.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCryoMax(Context context, Arguments args) {
        return new Object[]{this.tank.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoordinates(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.heat, this.tank.getFill(), this.tank.getMaxFill(), this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }
}

