/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import api.hbm.fluid.IFluidStandardSender;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.neutron.NeutronStream;
import com.hbm.handler.neutron.RBMKNeutronHandler;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerRBMKOutgasser;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIRBMKOutgasser;
import com.hbm.inventory.recipes.OutgasserRecipes;
import com.hbm.lib.Library;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRBMKOutgasser
extends TileEntityRBMKSlottedBase
implements IRBMKFluxReceiver,
IFluidStandardSender,
SimpleComponent,
CompatHandler.OCComponent {
    public FluidTank gas = new FluidTank(Fluids.TRITIUM, 64000);
    public double progress;
    public static final int duration = 10000;

    public TileEntityRBMKOutgasser() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.rbmkOutgasser";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.canProcess()) {
                this.progress = 0.0;
            }
            for (DirPos pos : this.getOutputPos()) {
                if (this.gas.getFill() <= 0) continue;
                this.sendFluid(this.gas, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
        super.func_145845_h();
    }

    protected DirPos[] getOutputPos() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == ModBlocks.rbmk_loader) {
            return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1, Library.NEG_Z), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, Library.NEG_Y)};
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e) == ModBlocks.rbmk_loader) {
            return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d - 2, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d - 2, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e - 1, Library.NEG_Z), new DirPos(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, Library.NEG_Y)};
        }
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, Library.POS_Y)};
    }

    @Override
    public void receiveFlux(NeutronStream stream) {
        if (this.canProcess()) {
            double efficiency = Math.min(1.0 - stream.fluxRatio * 0.8, 1.0);
            this.progress += stream.fluxQuantity * efficiency * RBMKDials.getOutgasserMod(this.field_145850_b);
            if (this.progress > 10000.0) {
                this.process();
                this.func_70296_d();
            }
        }
    }

    public boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        Tuple.Pair<ItemStack, FluidStack> output = OutgasserRecipes.getOutput(this.slots[0]);
        if (output == null) {
            return false;
        }
        FluidStack fluid = output.getValue();
        if (fluid != null) {
            if (this.gas.getTankType() != fluid.type && this.gas.getFill() > 0) {
                return false;
            }
            this.gas.setTankType(fluid.type);
            if (this.gas.getFill() + fluid.fill > this.gas.getMaxFill()) {
                return false;
            }
        }
        ItemStack out = output.getKey();
        if (this.slots[1] == null || out == null) {
            return true;
        }
        return this.slots[1].func_77973_b() == out.func_77973_b() && this.slots[1].func_77960_j() == out.func_77960_j() && this.slots[1].field_77994_a + out.field_77994_a <= this.slots[1].func_77976_d();
    }

    private void process() {
        ItemStack out;
        Tuple.Pair<ItemStack, FluidStack> output = OutgasserRecipes.getOutput(this.slots[0]);
        this.func_70298_a(0, 1);
        this.progress = 0.0;
        if (output.getValue() != null) {
            this.gas.setFill(this.gas.getFill() + output.getValue().fill);
        }
        if ((out = output.getKey()) != null) {
            if (this.slots[1] == null) {
                this.slots[1] = out.func_77946_l();
            } else {
                this.slots[1].field_77994_a += out.field_77994_a;
            }
        }
    }

    @Override
    public void onMelt(int reduce) {
        int count = 4 + this.field_145850_b.field_73012_v.nextInt(2);
        for (int i = 0; i < count; ++i) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.BLANK);
        }
        super.onMelt(reduce);
    }

    @Override
    public RBMKNeutronHandler.RBMKType getRBMKType() {
        return RBMKNeutronHandler.RBMKType.OUTGASSER;
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.OUTGASSER;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("gas", this.gas.getFill());
        data.func_74768_a("maxGas", this.gas.getMaxFill());
        data.func_74777_a("type", (short)this.gas.getTankType().getID());
        data.func_74780_a("progress", this.progress);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74769_h("progress");
        this.gas.readFromNBT(nbt, "gas");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("progress", this.progress);
        this.gas.writeToNBT(nbt, "gas");
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.gas.serialize(buf);
        buf.writeDouble(this.progress);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.gas.deserialize(buf);
        this.progress = buf.readDouble();
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return OutgasserRecipes.getOutput(itemStack) != null && i == 0;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 1;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{0, 1};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.gas};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.gas};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "rbmk_outgasser";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getGas(Context context, Arguments args) {
        return new Object[]{this.gas.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getGasMax(Context context, Arguments args) {
        return new Object[]{this.gas.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getGasType(Context context, Arguments args) {
        return new Object[]{this.gas.getTankType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getProgress(Context context, Arguments args) {
        return new Object[]{this.progress};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoordinates(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.gas.getFill(), this.gas.getMaxFill(), this.progress, this.gas.getTankType().getID(), this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRBMKOutgasser(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKOutgasser(player.field_71071_by, this);
    }
}

