/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.blocks.machine.rbmk.RBMKRod;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.neutron.NeutronNodeWorld;
import com.hbm.handler.neutron.NeutronStream;
import com.hbm.handler.neutron.RBMKNeutronHandler;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.inventory.container.ContainerRBMKRod;
import com.hbm.inventory.gui.GUIRBMKRod;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemRBMKRod;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.IRBMKLoadable;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.ParticleUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRBMKRod
extends TileEntityRBMKSlottedBase
implements IRBMKFluxReceiver,
IRBMKLoadable,
IInfoProviderEC,
SimpleComponent,
CompatHandler.OCComponent {
    public double fluxFastRatio;
    public double fluxQuantity;
    public double lastFluxQuantity;
    public double lastFluxRatio;
    public boolean hasRod;
    private String fuelYield;
    private String fuelXenon;
    private String fuelHeat;
    public static final ForgeDirection[] fluxDirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    private BlockPos pos;

    public TileEntityRBMKRod() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.rbmkRod";
    }

    @Override
    public boolean isModerated() {
        return ((RBMKRod)this.func_145838_q()).moderated;
    }

    @Override
    public int trackingRange() {
        return 25;
    }

    @Override
    public void receiveFlux(NeutronStream stream) {
        double fastFlux = this.fluxQuantity * this.fluxFastRatio;
        double fastFluxIn = stream.fluxQuantity * stream.fluxRatio;
        this.fluxQuantity += stream.fluxQuantity;
        this.fluxFastRatio = (fastFlux + fastFluxIn) / this.fluxQuantity;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
                double fluxQuantityOut;
                double fluxRatioOut;
                ItemRBMKRod rod = (ItemRBMKRod)this.slots[0].func_77973_b();
                if (rod.specialFluxCurve) {
                    fluxRatioOut = rod.fluxRatioOut(this.fluxFastRatio, ItemRBMKRod.getEnrichment(this.slots[0]));
                    double fluxIn = rod.fluxFromRatio(this.fluxQuantity, this.fluxFastRatio);
                    fluxQuantityOut = rod.burn(this.field_145850_b, this.slots[0], fluxIn);
                } else {
                    IRBMKFluxReceiver.NType rType = rod.rType;
                    fluxRatioOut = rType == IRBMKFluxReceiver.NType.SLOW ? 0.0 : 1.0;
                    double fluxIn = this.fluxFromType(rod.nType);
                    fluxQuantityOut = rod.burn(this.field_145850_b, this.slots[0], fluxIn);
                }
                rod.updateHeat(this.field_145850_b, this.slots[0], 1.0);
                this.heat += rod.provideHeat(this.field_145850_b, this.slots[0], this.heat, 1.0);
                if (!this.hasLid()) {
                    ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (float)(this.fluxQuantity * (double)0.05f));
                }
                super.func_145845_h();
                if (this.heat > this.maxHeat()) {
                    if (RBMKDials.getMeltdownsDisabled(this.field_145850_b)) {
                        ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b)) + 0.5, (double)this.field_145849_e + 0.5, 0.0, 0.2, 0.0);
                    } else {
                        this.meltdown();
                    }
                    this.lastFluxRatio = 0.0;
                    this.lastFluxQuantity = 0.0;
                    this.fluxQuantity = 0.0;
                    return;
                }
                if (this.heat > 10000.0) {
                    this.heat = 10000.0;
                }
                this.lastFluxQuantity = this.fluxQuantity;
                this.lastFluxRatio = this.fluxFastRatio;
                this.fluxQuantity = 0.0;
                this.fluxFastRatio = 0.0;
                this.spreadFlux(fluxQuantityOut, fluxRatioOut);
                this.hasRod = true;
            } else {
                this.lastFluxRatio = 0.0;
                this.lastFluxQuantity = 0.0;
                this.fluxQuantity = 0.0;
                this.fluxFastRatio = 0.0;
                this.hasRod = false;
                super.func_145845_h();
            }
        }
    }

    private double fluxFromType(IRBMKFluxReceiver.NType type) {
        double fastFlux = this.fluxQuantity * this.fluxFastRatio;
        double slowFlux = this.fluxQuantity * (1.0 - this.fluxFastRatio);
        switch (type) {
            case SLOW: {
                return slowFlux + fastFlux * 0.5;
            }
            case FAST: {
                return fastFlux + slowFlux * 0.3;
            }
            case ANY: {
                return this.fluxQuantity;
            }
        }
        return 0.0;
    }

    public void spreadFlux(double flux, double ratio) {
        if (this.pos == null) {
            this.pos = new BlockPos(this);
        }
        if (flux == 0.0) {
            NeutronNodeWorld.removeNode(this.field_145850_b, this.pos);
            return;
        }
        NeutronNodeWorld.StreamWorld streamWorld = NeutronNodeWorld.getOrAddWorld(this.field_145850_b);
        RBMKNeutronHandler.RBMKNeutronNode node = (RBMKNeutronHandler.RBMKNeutronNode)streamWorld.getNode(this.pos);
        if (node == null) {
            node = RBMKNeutronHandler.makeNode(streamWorld, this);
            streamWorld.addNode(node);
        }
        for (ForgeDirection dir : fluxDirs) {
            Vec3 neutronVector = Vec3.func_72443_a((double)dir.offsetX, (double)dir.offsetY, (double)dir.offsetZ);
            new RBMKNeutronHandler.RBMKNeutronStream(node, neutronVector, flux, ratio);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("fluxFast") || nbt.func_74764_b("fluxSlow")) {
            this.fluxQuantity = nbt.func_74769_h("fluxFast") + nbt.func_74769_h("fluxSlow");
            this.fluxFastRatio = this.fluxQuantity > 0.0 ? nbt.func_74769_h("fluxFast") / this.fluxQuantity : 0.0;
        } else {
            this.fluxQuantity = nbt.func_74769_h("fluxQuantity");
            this.fluxFastRatio = nbt.func_74769_h("fluxMod");
        }
        this.hasRod = nbt.func_74767_n("hasRod");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (!diag) {
            nbt.func_74780_a("fluxQuantity", this.lastFluxQuantity);
            nbt.func_74780_a("fluxMod", this.lastFluxRatio);
        } else {
            nbt.func_74780_a("fluxSlow", this.fluxQuantity * (1.0 - this.fluxFastRatio));
            nbt.func_74780_a("fluxFast", this.fluxQuantity * this.fluxFastRatio);
        }
        nbt.func_74757_a("hasRod", this.hasRod);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeDouble(this.lastFluxQuantity);
        buf.writeDouble(this.lastFluxRatio);
        buf.writeBoolean(this.hasRod);
        if (this.hasRod) {
            ItemRBMKRod rod = (ItemRBMKRod)this.slots[0].func_77973_b();
            BufferUtil.writeString(buf, ItemRBMKRod.getYield(this.slots[0]) + " / " + rod.yield + " (" + ItemRBMKRod.getEnrichment(this.slots[0]) * 100.0 + "%)");
            BufferUtil.writeString(buf, ItemRBMKRod.getPoison(this.slots[0]) + "%");
            BufferUtil.writeString(buf, ItemRBMKRod.getCoreHeat(this.slots[0]) + " / " + ItemRBMKRod.getHullHeat(this.slots[0]) + " / " + rod.meltingPoint);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.fluxQuantity = buf.readDouble();
        this.fluxFastRatio = buf.readDouble();
        this.hasRod = buf.readBoolean();
        if (this.hasRod) {
            this.fuelYield = BufferUtil.readString(buf);
            this.fuelXenon = BufferUtil.readString(buf);
            this.fuelHeat = BufferUtil.readString(buf);
        } else {
            this.fuelHeat = null;
            this.fuelXenon = null;
            this.fuelYield = null;
        }
    }

    @Override
    public void getDiagData(NBTTagCompound nbt) {
        diag = true;
        this.func_145841_b(nbt);
        diag = false;
        if (this.fuelYield != null && this.fuelXenon != null && this.fuelHeat != null) {
            nbt.func_74778_a("f_yield", this.fuelYield);
            nbt.func_74778_a("f_xenon", this.fuelXenon);
            nbt.func_74778_a("f_heat", this.fuelHeat);
        }
    }

    @Override
    public void onMelt(int reduce) {
        int i;
        int count;
        boolean corium;
        boolean moderated = this.isModerated();
        int h = RBMKDials.getColumnHeight(this.field_145850_b);
        reduce = MathHelper.func_76125_a((int)reduce, (int)1, (int)h);
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            ++reduce;
        }
        boolean bl = corium = this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod;
        if (corium && this.slots[0].func_77973_b() == ModItems.rbmk_fuel_drx) {
            RBMKBase.digamma = true;
        }
        this.slots[0] = null;
        if (corium) {
            for (int i2 = h; i2 >= 0; --i2) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + i2, this.field_145849_e, ModBlocks.corium_block, 5, 3);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + i2, this.field_145849_e);
            }
            count = 1 + this.field_145850_b.field_73012_v.nextInt(RBMKDials.getColumnHeight(this.field_145850_b));
            for (i = 0; i < count; ++i) {
                this.spawnDebris(EntityRBMKDebris.DebrisType.FUEL);
            }
        } else {
            this.standardMelt(reduce);
        }
        if (moderated) {
            count = 2 + this.field_145850_b.field_73012_v.nextInt(2);
            for (i = 0; i < count; ++i) {
                this.spawnDebris(EntityRBMKDebris.DebrisType.GRAPHITE);
            }
        }
        this.spawnDebris(EntityRBMKDebris.DebrisType.ELEMENT);
        if (this.func_145832_p() == RBMKBase.DIR_NORMAL_LID.ordinal() + 10) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.LID);
        }
    }

    @Override
    public RBMKNeutronHandler.RBMKType getRBMKType() {
        return RBMKNeutronHandler.RBMKType.ROD;
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.FUEL;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            ItemRBMKRod rod = (ItemRBMKRod)this.slots[0].func_77973_b();
            data.func_74780_a("enrichment", ItemRBMKRod.getEnrichment(this.slots[0]));
            data.func_74780_a("xenon", ItemRBMKRod.getPoison(this.slots[0]));
            data.func_74780_a("c_heat", ItemRBMKRod.getHullHeat(this.slots[0]));
            data.func_74780_a("c_coreHeat", ItemRBMKRod.getCoreHeat(this.slots[0]));
            data.func_74780_a("c_maxHeat", rod.meltingPoint);
        }
        return data;
    }

    @Override
    public boolean canLoad(ItemStack toLoad) {
        return toLoad != null && this.slots[0] == null;
    }

    @Override
    public void load(ItemStack toLoad) {
        this.slots[0] = toLoad.func_77946_l();
        this.func_70296_d();
    }

    @Override
    public boolean canUnload() {
        return this.slots[0] != null;
    }

    @Override
    public ItemStack provideNext() {
        return this.slots[0];
    }

    @Override
    public void unload() {
        this.slots[0] = null;
        this.func_70296_d();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "rbmk_fuel_rod";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getHeat(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluxQuantity(Context context, Arguments args) {
        return new Object[]{this.lastFluxQuantity};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluxRatio(Context context, Arguments args) {
        return new Object[]{this.fluxFastRatio};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getDepletion(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getEnrichment(this.slots[0])};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getXenonPoison(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getPoison(this.slots[0])};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoreHeat(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getCoreHeat(this.slots[0])};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSkinHeat(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getHullHeat(this.slots[0])};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getType(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{this.slots[0].func_77973_b().func_77658_a()};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            returnValues.add(ItemRBMKRod.getHullHeat(this.slots[0]));
            returnValues.add(ItemRBMKRod.getCoreHeat(this.slots[0]));
            returnValues.add(ItemRBMKRod.getEnrichment(this.slots[0]));
            returnValues.add(ItemRBMKRod.getPoison(this.slots[0]));
            returnValues.add(this.slots[0].func_77973_b().func_77658_a());
        } else {
            for (int i = 0; i < 5; ++i) {
                returnValues.add("N/A");
            }
        }
        return new Object[]{this.heat, returnValues.get(0), returnValues.get(1), this.fluxQuantity, this.fluxFastRatio, returnValues.get(2), returnValues.get(3), returnValues.get(4), ((RBMKRod)this.func_145838_q()).moderated, this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getModerated(Context context, Arguments args) {
        return new Object[]{((RBMKRod)this.func_145838_q()).moderated};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoordinates(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRBMKRod(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKRod(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            data.func_74780_a("depletion", (1.0 - ItemRBMKRod.getEnrichment(this.slots[0])) * 100000.0 / 1000.0);
            data.func_74780_a("xenon", ItemRBMKRod.getPoison(this.slots[0]));
            data.func_74780_a("skin", ItemRBMKRod.getHullHeat(this.slots[0]));
            data.func_74780_a("c_heat", ItemRBMKRod.getCoreHeat(this.slots[0]));
            data.func_74780_a("melt", ((ItemRBMKRod)this.slots[0].func_77973_b()).meltingPoint);
        }
    }
}

