/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.entity.projectile.EntityBulletBaseMK4;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.inventory.gui.GUITurretFritz;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import com.hbm.items.weapon.sedna.factory.XFactoryFlamer;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.turret.TileEntityTurretBaseNT;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTurretFritz
extends TileEntityTurretBaseNT
implements IFluidStandardReceiver,
IFluidCopiable {
    public FluidTank tank = new FluidTank(Fluids.DIESEL, 16000);

    @Override
    public String getName() {
        return "container.turretFritz";
    }

    @Override
    protected List<Integer> getAmmoList() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAmmoTypesForDisplay() {
        if (this.ammoStacks != null) {
            return this.ammoStacks;
        }
        this.ammoStacks = new ArrayList();
        this.ammoStacks.add(new ItemStack(ModItems.ammo_standard, 1, GunFactory.EnumAmmo.FLAME_DIESEL.ordinal()));
        for (FluidType type : Fluids.getInNiceOrder()) {
            if (!type.hasTrait(FT_Combustible.class) || !type.hasTrait(FluidTraitSimple.FT_Liquid.class)) continue;
            this.ammoStacks.add(new ItemStack(ModItems.fluid_icon, 1, type.getID()));
        }
        return this.ammoStacks;
    }

    @Override
    public double getDecetorRange() {
        return 32.0;
    }

    @Override
    public double getDecetorGrace() {
        return 2.0;
    }

    @Override
    public double getTurretElevation() {
        return 45.0;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    @Override
    public double getBarrelLength() {
        return 2.25;
    }

    @Override
    public double getAcceptableInaccuracy() {
        return 15.0;
    }

    @Override
    public void updateFiringTick() {
        if (this.tank.getTankType().hasTrait(FT_Flammable.class) && this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Liquid.class) && this.tank.getFill() >= 2) {
            FT_Flammable trait = this.tank.getTankType().getTrait(FT_Flammable.class);
            this.tank.setFill(this.tank.getFill() - 2);
            Vec3 pos = this.getTurretPos();
            Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
            vec.func_72446_c((float)(-this.rotationPitch));
            vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
            EntityBulletBaseMK4 proj = new EntityBulletBaseMK4(this.field_145850_b, XFactoryFlamer.flame_nograv, (float)trait.getHeatEnergy() / 500000.0f, 0.05f, (float)this.rotationYaw, (float)this.rotationPitch);
            proj.func_70080_a(pos.field_72450_a + vec.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c, proj.field_70177_z, proj.field_70125_A);
            this.field_145850_b.func_72838_d((Entity)proj);
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:weapon.flamethrowerShoot", 2.0f, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "vanillaburst");
            data.func_74778_a("mode", "flame");
            data.func_74768_a("count", 2);
            data.func_74780_a("motion", 0.025);
            PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, pos.field_72450_a + vec.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    public int getDelay() {
        return 2;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.tank.setType(9, 9, this.slots);
            this.tank.loadTank(0, 1, this.slots);
            for (int i = 1; i < 10; ++i) {
                if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.ammo_standard || this.slots[i].func_77960_j() != GunFactory.EnumAmmo.FLAME_DIESEL.ordinal() || this.tank.getTankType() != Fluids.DIESEL || this.tank.getFill() + 1000 > this.tank.getMaxFill()) continue;
                this.tank.setFill(this.tank.getFill() + 1000);
                this.func_70298_a(i, 1);
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.tank.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.tank.deserialize(buf);
    }

    @Override
    protected void updateConnections() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * -1 + rot.offsetX * 0, this.field_145848_d, this.field_145849_e + dir.offsetZ * -1 + rot.offsetZ * 0, dir.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * -1 + rot.offsetX * -1, this.field_145848_d, this.field_145849_e + dir.offsetZ * -1 + rot.offsetZ * -1, dir.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 0 + rot.offsetX * -2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 0 + rot.offsetZ * -2, rot.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 1 + rot.offsetX * -2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * -2, rot.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 0 + rot.offsetX * 1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 0 + rot.offsetZ * 1, rot);
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 1 + rot.offsetX * 1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * 1, rot);
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 0, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 0, dir);
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX * -1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * -1, dir);
        this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * -1 + rot.offsetX * 0, this.field_145848_d, this.field_145849_e + dir.offsetZ * -1 + rot.offsetZ * 0, dir.getOpposite());
        this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * -1 + rot.offsetX * -1, this.field_145848_d, this.field_145849_e + dir.offsetZ * -1 + rot.offsetZ * -1, dir.getOpposite());
        this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 0 + rot.offsetX * -2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 0 + rot.offsetZ * -2, rot.getOpposite());
        this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 1 + rot.offsetX * -2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * -2, rot.getOpposite());
        this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 0 + rot.offsetX * 1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 0 + rot.offsetZ * 1, rot);
        this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 1 + rot.offsetX * 1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * 1, rot);
        this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 0, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 0, dir);
        this.trySubscribe(this.tank.getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX * -1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * -1, dir);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "diesel");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "diesel");
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.DOWN;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUITurretFritz(player.field_71071_by, this);
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tank;
    }
}

