/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.entity.projectile.EntityBulletBaseMK4;
import com.hbm.inventory.gui.GUITurretRichard;
import com.hbm.items.weapon.sedna.BulletConfig;
import com.hbm.items.weapon.sedna.factory.XFactoryRocket;
import com.hbm.tileentity.turret.TileEntityTurretBaseNT;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityTurretRichard
extends TileEntityTurretBaseNT {
    static List<Integer> configs = new ArrayList<Integer>();
    int timer;
    public int loaded;
    int reload;
    private boolean isTurretPacket = false;

    @Override
    protected List<Integer> getAmmoList() {
        return configs;
    }

    @Override
    public String getName() {
        return "container.turretRichard";
    }

    @Override
    public double getTurretDepression() {
        return 25.0;
    }

    @Override
    public double getTurretElevation() {
        return 25.0;
    }

    @Override
    public double getBarrelLength() {
        return 1.25;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    @Override
    public double getDecetorGrace() {
        return 8.0;
    }

    @Override
    public double getDecetorRange() {
        return 64.0;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.reload > 0) {
                --this.reload;
                if (this.reload == 0) {
                    this.loaded = 17;
                }
            }
            if (this.loaded <= 0 && this.reload <= 0 && this.getFirstConfigLoaded() != null) {
                this.reload = 100;
            }
            if (this.getFirstConfigLoaded() == null) {
                this.loaded = 0;
            }
            this.isTurretPacket = true;
            this.networkPackNT(250);
            this.isTurretPacket = false;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        if (this.isTurretPacket) {
            buf.writeBoolean(true);
            buf.writeInt(this.loaded);
        } else {
            buf.writeBoolean(false);
            super.serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.loaded = buf.readInt();
        } else {
            super.deserialize(buf);
        }
    }

    @Override
    public void updateFiringTick() {
        if (this.reload > 0) {
            return;
        }
        ++this.timer;
        if (this.timer > 0 && this.timer % 10 == 0) {
            BulletConfig conf = this.getFirstConfigLoaded();
            if (conf != null) {
                this.spawnBullet(conf, 30.0f);
                this.conusmeAmmo(conf.ammo);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:turret.richard_fire", 2.0f, 1.0f);
                --this.loaded;
            } else {
                this.loaded = 0;
            }
        }
    }

    @Override
    public void spawnBullet(BulletConfig bullet, float baseDamage) {
        Vec3 pos = this.getTurretPos();
        Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
        vec.func_72446_c((float)(-this.rotationPitch));
        vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
        EntityBulletBaseMK4 proj = new EntityBulletBaseMK4(this.field_145850_b, bullet, baseDamage, bullet.spread, (float)this.rotationYaw, (float)this.rotationPitch);
        proj.func_70080_a(pos.field_72450_a + vec.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c, proj.field_70177_z, proj.field_70125_A);
        proj.lockonTarget = this.target;
        this.field_145850_b.func_72838_d((Entity)proj);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.loaded = nbt.func_74762_e("loaded");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("loaded", this.loaded);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUITurretRichard(player.field_71071_by, this);
    }

    static {
        for (BulletConfig cfg : XFactoryRocket.rocket_ml) {
            configs.add(cfg.id);
        }
    }
}

