/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.interfaces.Untested;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.recipes.AmmoPressRecipes;
import com.hbm.inventory.recipes.ArcFurnaceRecipes;
import com.hbm.inventory.recipes.ArcWelderRecipes;
import com.hbm.inventory.recipes.AssemblerRecipes;
import com.hbm.inventory.recipes.BlastFurnaceRecipes;
import com.hbm.inventory.recipes.BreederRecipes;
import com.hbm.inventory.recipes.CentrifugeRecipes;
import com.hbm.inventory.recipes.ChemplantRecipes;
import com.hbm.inventory.recipes.CokerRecipes;
import com.hbm.inventory.recipes.CombinationRecipes;
import com.hbm.inventory.recipes.CompressorRecipes;
import com.hbm.inventory.recipes.CrackingRecipes;
import com.hbm.inventory.recipes.CrucibleRecipes;
import com.hbm.inventory.recipes.CrystallizerRecipes;
import com.hbm.inventory.recipes.CyclotronRecipes;
import com.hbm.inventory.recipes.ElectrolyserFluidRecipes;
import com.hbm.inventory.recipes.ElectrolyserMetalRecipes;
import com.hbm.inventory.recipes.ExposureChamberRecipes;
import com.hbm.inventory.recipes.FractionRecipes;
import com.hbm.inventory.recipes.FuelPoolRecipes;
import com.hbm.inventory.recipes.HydrotreatingRecipes;
import com.hbm.inventory.recipes.LiquefactionRecipes;
import com.hbm.inventory.recipes.OutgasserRecipes;
import com.hbm.inventory.recipes.ParticleAcceleratorRecipes;
import com.hbm.inventory.recipes.PedestalRecipes;
import com.hbm.inventory.recipes.PressRecipes;
import com.hbm.inventory.recipes.PyroOvenRecipes;
import com.hbm.inventory.recipes.ReformingRecipes;
import com.hbm.inventory.recipes.RotaryFurnaceRecipes;
import com.hbm.inventory.recipes.ShredderRecipes;
import com.hbm.inventory.recipes.SolderingRecipes;
import com.hbm.inventory.recipes.SolidificationRecipes;
import com.hbm.inventory.recipes.anvil.AnvilRecipes;
import com.hbm.items.machine.ItemStamp;
import com.hbm.util.EnumUtil;
import com.hbm.util.Tuple;
import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Untested
public class CompatRecipeRegistry {
    public static void registerPress(ItemStamp.StampType stamp, RecipesCommon.AStack input, ItemStack output) {
        PressRecipes.recipes.put(new Tuple.Pair<RecipesCommon.AStack, ItemStamp.StampType>(input, stamp), output);
    }

    public static void registerBlastFurnace(Object[] inputs, ItemStack output) {
        if (inputs.length != 2) {
            return;
        }
        BlastFurnaceRecipes.addRecipe(inputs[0], inputs[1], output);
    }

    public static void registerShredder(RecipesCommon.AStack input, ItemStack output) {
        for (ItemStack allItems : input.extractForNEI()) {
            RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(allItems);
            ShredderRecipes.shredderRecipes.put(comp, output);
            if (ShredderRecipes.neiShredderRecipes == null) continue;
            ShredderRecipes.neiShredderRecipes.put(comp, output);
        }
    }

    public static void registerSoldering(ItemStack output, int time, long power, FluidStack fluid, RecipesCommon.AStack[] toppings, RecipesCommon.AStack[] pcb, RecipesCommon.AStack[] solder) {
        SolderingRecipes.recipes.add(new SolderingRecipes.SolderingRecipe(output, time, power, fluid, CompatRecipeRegistry.copyFirst(toppings, 3), CompatRecipeRegistry.copyFirst(pcb, 2), CompatRecipeRegistry.copyFirst(solder, 1)));
    }

    public static void registerChemplant(int id, String name, int duration, RecipesCommon.AStack[] inputItems, FluidStack[] inputFluids, ItemStack[] outputItems, FluidStack[] outputFluids) {
        ChemplantRecipes.ChemRecipe recipe = new ChemplantRecipes.ChemRecipe(id, name, duration);
        if (inputItems != null) {
            recipe.inputItems(CompatRecipeRegistry.copyFirst(inputItems, 4));
        }
        if (inputFluids != null) {
            recipe.inputFluids(CompatRecipeRegistry.copyFirst(inputFluids, 2));
        }
        if (outputItems != null) {
            recipe.outputItems(CompatRecipeRegistry.copyFirst(outputItems, 4));
        }
        if (outputFluids != null) {
            recipe.outputFluids(CompatRecipeRegistry.copyFirst(outputFluids, 2));
        }
        ChemplantRecipes.recipes.add(recipe);
    }

    public static void registerCombination(RecipesCommon.AStack input, ItemStack output, FluidStack fluid) {
        if (output == null && fluid == null) {
            return;
        }
        RecipesCommon.AStack o = input instanceof RecipesCommon.OreDictStack ? ((RecipesCommon.OreDictStack)input).name : input;
        CombinationRecipes.recipes.put(o, new Tuple.Pair<ItemStack, FluidStack>(output, fluid));
    }

    public static void registerCrucible(int index, String name, int frequency, ItemStack icon, Mats.MaterialStack[] input, Mats.MaterialStack[] output) {
        CrucibleRecipes.CrucibleRecipe recipe = new CrucibleRecipes.CrucibleRecipe(index, name, frequency, icon).inputs(input).outputs(output);
        CrucibleRecipes.recipes.add(recipe);
    }

    public static void registerCentrifuge(RecipesCommon.AStack input, ItemStack[] outputs) {
        CentrifugeRecipes.recipes.put(input, CompatRecipeRegistry.copyFirst(outputs, 4));
    }

    public static void registerCrystallizer(RecipesCommon.AStack input, ItemStack output, int time, float productivity, FluidStack fluid) {
        CrystallizerRecipes.CrystallizerRecipe recipe = new CrystallizerRecipes.CrystallizerRecipe(output, time).prod(productivity);
        CrystallizerRecipes.registerRecipe(input instanceof RecipesCommon.OreDictStack ? ((RecipesCommon.OreDictStack)input).name : input, recipe, fluid);
    }

    public static void registerFraction(FluidType input, FluidStack[] output) {
        if (output.length != 2) {
            return;
        }
        FractionRecipes.fractions.put(input, new Tuple.Pair<FluidStack, FluidStack>(output[0], output[1]));
    }

    public static void registerCracking(FluidType input, FluidStack[] output) {
        if (output.length != 2) {
            return;
        }
        CrackingRecipes.cracking.put(input, new Tuple.Pair<FluidStack, FluidStack>(output[0], output[1]));
    }

    public static void registerReforming(FluidType input, FluidStack[] output) {
        if ((output = CompatRecipeRegistry.copyFirst(output, 3)).length < 3) {
            return;
        }
        ReformingRecipes.recipes.put(input, new Tuple.Triplet<FluidStack, FluidStack, FluidStack>(output[0], output[1], output[2]));
    }

    public static void registerHydrotreating(FluidType input, FluidStack hydrogen, FluidStack[] output) {
        if ((output = CompatRecipeRegistry.copyFirst(output, 2)).length < 2) {
            return;
        }
        HydrotreatingRecipes.recipes.put(input, new Tuple.Triplet<FluidStack, FluidStack, FluidStack>(hydrogen, output[0], output[1]));
    }

    public static void registerLiquefaction(RecipesCommon.AStack input, FluidStack output) {
        LiquefactionRecipes.recipes.put(input instanceof RecipesCommon.OreDictStack ? ((RecipesCommon.OreDictStack)input).name : input, output);
    }

    public static void registerSolidifying(FluidStack input, ItemStack output) {
        SolidificationRecipes.recipes.put(input.type, new Tuple.Pair<Integer, ItemStack>(input.fill, output));
    }

    public static void registerCoker(FluidStack input, ItemStack output, FluidStack fluid) {
        CokerRecipes.recipes.put(input.type, new Tuple.Triplet<Integer, ItemStack, FluidStack>(input.fill, output, fluid));
    }

    public static void registerCokerAuto(FluidType input, FluidType output) {
        CokerRecipes.registerAuto(input, output);
    }

    public static void registerPyro(FluidStack inputFluid, RecipesCommon.AStack inputItem, FluidStack outputFluid, ItemStack outputItem, int duration) {
        PyroOvenRecipes.recipes.add(new PyroOvenRecipes.PyroOvenRecipe(duration).in(inputFluid).in(inputItem).out(outputFluid).out(outputItem));
    }

    public static void registerPyroAuto(FluidType input) {
        PyroOvenRecipes.registerSFAuto(input);
    }

    public static void registerBreeder(RecipesCommon.ComparableStack input, ItemStack output, int flux) {
        BreederRecipes.recipes.put(input, new BreederRecipes.BreederRecipe(output, flux));
    }

    public static void registerCyclotron(RecipesCommon.ComparableStack box, RecipesCommon.AStack target, ItemStack output, int antimatter) {
        CyclotronRecipes.recipes.put(new Tuple.Pair<RecipesCommon.ComparableStack, RecipesCommon.AStack>(box, target), new Tuple.Pair<ItemStack, Integer>(output, antimatter));
    }

    public static void registerFuelPool(RecipesCommon.ComparableStack input, ItemStack output) {
        FuelPoolRecipes.recipes.put(input, output);
    }

    public static void registerOutgasser(RecipesCommon.AStack input, ItemStack output, FluidStack fluid) {
        OutgasserRecipes.recipes.put(input, new Tuple.Pair<ItemStack, FluidStack>(output, fluid));
    }

    public static void registerCompressor(FluidStack input, FluidStack output, int time) {
        CompressorRecipes.recipes.put(new Tuple.Pair<FluidType, Integer>(input.type, input.pressure), new CompressorRecipes.CompressorRecipe(input.fill, output, time));
    }

    public static void registerElectrolyzerFluid(FluidStack input, FluidStack[] output, ItemStack[] byproduct, int time) {
        if ((output = CompatRecipeRegistry.copyFirst(output, 2)).length < 2) {
            return;
        }
        if (byproduct != null) {
            byproduct = CompatRecipeRegistry.copyFirst(byproduct, 3);
        }
        ElectrolyserFluidRecipes.recipes.put(input.type, new ElectrolyserFluidRecipes.ElectrolysisRecipe(input.fill, output[0], output[1], time, byproduct));
    }

    public static void registerElectrolyzerMetal(RecipesCommon.AStack input, Mats.MaterialStack[] output, ItemStack[] byproduct, int time) {
        output = CompatRecipeRegistry.copyFirst(output, 2);
        if (byproduct != null) {
            byproduct = CompatRecipeRegistry.copyFirst(byproduct, 6);
        }
        ElectrolyserMetalRecipes.recipes.put(input, new ElectrolyserMetalRecipes.ElectrolysisMetalRecipe(output[0], output[1], time, byproduct));
    }

    public static void registerArcWelder(ItemStack output, int time, long power, FluidStack fluid, RecipesCommon.AStack[] inputs) {
        ArcWelderRecipes.recipes.add(new ArcWelderRecipes.ArcWelderRecipe(output, time, power, fluid, CompatRecipeRegistry.copyFirst(inputs, 3)));
    }

    public static void registerRotaryFurnace(Mats.MaterialStack output, int time, int steam, FluidStack fluid, RecipesCommon.AStack[] inputs) {
        RotaryFurnaceRecipes.recipes.add(new RotaryFurnaceRecipes.RotaryFurnaceRecipe(output, time, steam, fluid, CompatRecipeRegistry.copyFirst(inputs, 3)));
    }

    public static void registerExposureChamber(RecipesCommon.AStack particle, RecipesCommon.AStack input, ItemStack output) {
        ExposureChamberRecipes.recipes.add(new ExposureChamberRecipes.ExposureChamberRecipe(particle, input, output));
    }

    public static void registerParticleAccelerator(RecipesCommon.AStack[] input, int momentum, ItemStack[] output) {
        if ((input = CompatRecipeRegistry.copyFirst(input, 2)).length < 2) {
            return;
        }
        if ((output = CompatRecipeRegistry.copyFirst(output, 2)).length < 1) {
            return;
        }
        ParticleAcceleratorRecipes.recipes.add(new ParticleAcceleratorRecipes.ParticleAcceleratorRecipe(input[0], input[1], momentum, output[0], output.length > 1 ? output[1] : null));
    }

    public static void registerAmmoPress(ItemStack output, RecipesCommon.AStack[] input) {
        if (input.length != 9) {
            return;
        }
        AmmoPressRecipes.recipes.add(new AmmoPressRecipes.AmmoPressRecipe(output, input));
    }

    public static void registerAssembler(ItemStack output, RecipesCommon.AStack[] input, int time) {
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(output), CompatRecipeRegistry.copyFirst(input, 12), time);
    }

    public static void registerAssembler(ItemStack output, RecipesCommon.AStack[] input, int time, Item ... folder) {
        AssemblerRecipes.makeRecipe(new RecipesCommon.ComparableStack(output), CompatRecipeRegistry.copyFirst(input, 12), time, folder);
    }

    public static void registerAnvilConstruction(RecipesCommon.AStack[] input, AnvilRecipes.AnvilOutput[] output, int tier, int overlayIndex) {
        AnvilRecipes.constructionRecipes.add(new AnvilRecipes.AnvilConstructionRecipe(input, output).setTier(tier).setOverlay((AnvilRecipes.OverlayType)((Object)EnumUtil.grabEnumSafely(AnvilRecipes.OverlayType.class, overlayIndex))));
    }

    public static void registerAnvilConstruction(RecipesCommon.AStack[] input, AnvilRecipes.AnvilOutput[] output, int tierLower, int tierUpper, int overlayIndex) {
        AnvilRecipes.constructionRecipes.add(new AnvilRecipes.AnvilConstructionRecipe(input, output).setTierRange(tierLower, tierUpper).setOverlay((AnvilRecipes.OverlayType)((Object)EnumUtil.grabEnumSafely(AnvilRecipes.OverlayType.class, overlayIndex))));
    }

    public static void registerPedestal(ItemStack output, RecipesCommon.AStack[] input) {
        CompatRecipeRegistry.registerPedestal(output, input, 0);
    }

    public static void registerPedestal(ItemStack output, RecipesCommon.AStack[] input, int condition) {
        if ((input = CompatRecipeRegistry.copyFirst(input, 9)).length < 9) {
            return;
        }
        PedestalRecipes.recipes.add(new PedestalRecipes.PedestalRecipe(output, input).extra((PedestalRecipes.PedestalExtraCondition)((Object)EnumUtil.grabEnumSafely(PedestalRecipes.PedestalExtraCondition.class, condition))));
    }

    public static void registerArcFurnace(RecipesCommon.AStack input, ItemStack output, Mats.MaterialStack fluid) {
        if (output == null && fluid == null) {
            return;
        }
        ArcFurnaceRecipes.recipeList.add(new Tuple.Pair<RecipesCommon.AStack, ArcFurnaceRecipes.ArcFurnaceRecipe>(input, new ArcFurnaceRecipes.ArcFurnaceRecipe().solid(output).fluid(fluid)));
    }

    private static <T> T[] copyFirst(T[] array, int amount) {
        if (array.length <= amount) {
            return array;
        }
        return Arrays.copyOf(array, amount);
    }
}

