/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.config.ServerConfig;
import com.hbm.util.DamageResistanceHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityDamageUtil {
    @Deprecated
    public static boolean attackEntityFromIgnoreIFrame(Entity victim, DamageSource src, float damage) {
        if (!victim.func_70097_a(src, damage)) {
            if (victim instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)victim;
                if ((float)living.field_70172_ad > (float)living.field_70771_an / 2.0f) {
                    damage += living.field_110153_bc;
                }
            }
            return victim.func_70097_a(src, damage);
        }
        return true;
    }

    public static boolean attackEntityFromNT(EntityLivingBase living, DamageSource source, float amount, boolean ignoreIFrame, boolean allowSpecialCancel, double knockbackMultiplier, float pierceDT, float pierce) {
        EntityPlayer attacker;
        EntityPlayerMP playerMP;
        if (living instanceof EntityPlayerMP && source.func_76346_g() instanceof EntityPlayer && !(playerMP = (EntityPlayerMP)living).func_96122_a(attacker = (EntityPlayer)source.func_76346_g())) {
            return false;
        }
        DamageResistanceHandler.setup(pierceDT, pierce);
        boolean ret = EntityDamageUtil.attackEntityFromNTInternal(living, source, amount, ignoreIFrame, allowSpecialCancel, knockbackMultiplier);
        DamageResistanceHandler.reset();
        return ret;
    }

    private static boolean attackEntityFromNTInternal(EntityLivingBase living, DamageSource source, float amount, boolean ignoreIFrame, boolean allowSpecialCancel, double knockbackMultiplier) {
        boolean superCompatibility = ServerConfig.DAMAGE_COMPATIBILITY_MODE.get();
        return superCompatibility ? EntityDamageUtil.attackEntitySuperCompatibility(living, source, amount, ignoreIFrame, allowSpecialCancel, knockbackMultiplier) : EntityDamageUtil.attackEntitySEDNAPatch(living, source, amount, ignoreIFrame, allowSpecialCancel, knockbackMultiplier);
    }

    private static boolean attackEntitySuperCompatibility(EntityLivingBase living, DamageSource source, float amount, boolean ignoreIFrame, boolean allowSpecialCancel, double knockbackMultiplier) {
        if (ignoreIFrame) {
            living.field_110153_bc = 0.0f;
            living.field_70172_ad = 0;
        }
        double motionX = living.field_70159_w;
        double motionY = living.field_70159_w;
        double motionZ = living.field_70159_w;
        boolean ret = living.func_70097_a(source, amount);
        living.field_70159_w = motionX;
        living.field_70181_x = motionY;
        living.field_70179_y = motionZ;
        Entity entity = source.func_76346_g();
        if (entity != null) {
            double deltaX = entity.field_70165_t - living.field_70165_t;
            double deltaZ = entity.field_70161_v - living.field_70161_v;
            while (deltaX * deltaX + deltaZ * deltaZ < 1.0E-4) {
                deltaX = (Math.random() - Math.random()) * 0.01;
                deltaZ = (Math.random() - Math.random()) * 0.01;
            }
            living.field_70739_aP = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI) - living.field_70177_z;
            if (knockbackMultiplier > 0.0) {
                EntityDamageUtil.knockBack(living, entity, amount, deltaX, deltaZ, knockbackMultiplier);
            }
        }
        return ret;
    }

    private static boolean attackEntitySEDNAPatch(EntityLivingBase living, DamageSource source, float amount, boolean ignoreIFrame, boolean allowSpecialCancel, double knockbackMultiplier) {
        String sound;
        living.func_70097_a(source, 0.0f);
        if (ignoreIFrame) {
            living.field_110153_bc = 0.0f;
        }
        if (ForgeHooks.onLivingAttack((EntityLivingBase)living, (DamageSource)source, (float)amount) && allowSpecialCancel) {
            return false;
        }
        if (living.func_85032_ar()) {
            return false;
        }
        if (living.field_70170_p.field_72995_K) {
            return false;
        }
        if (living instanceof EntityPlayer && ((EntityPlayer)living).field_71075_bZ.field_75102_a && !source.func_76357_e()) {
            return false;
        }
        living.field_70708_bq = 0;
        if (living.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (source.func_76347_k() && living.func_70644_a(Potion.field_76426_n)) {
            return false;
        }
        living.field_70721_aZ = 1.5f;
        boolean didAttackRegister = true;
        if ((float)living.field_70172_ad > (float)living.field_70771_an / 2.0f && !ignoreIFrame) {
            if (amount <= living.field_110153_bc) {
                return false;
            }
            EntityDamageUtil.damageEntityNT(living, source, amount - living.field_110153_bc);
            living.field_110153_bc = amount;
            didAttackRegister = false;
        } else {
            living.field_110153_bc = amount;
            living.field_70735_aL = living.func_110143_aJ();
            living.field_70172_ad = living.field_70771_an;
            EntityDamageUtil.damageEntityNT(living, source, amount);
            living.field_70738_aO = 10;
            living.field_70737_aN = 10;
        }
        living.field_70739_aP = 0.0f;
        Entity entity = source.func_76346_g();
        if (entity != null) {
            EntityTameable entitywolf;
            if (entity instanceof EntityLivingBase) {
                living.func_70604_c((EntityLivingBase)entity);
            }
            if (entity instanceof EntityPlayer) {
                living.field_70718_bc = 100;
                living.field_70717_bb = (EntityPlayer)entity;
            } else if (entity instanceof EntityTameable && (entitywolf = (EntityTameable)entity).func_70909_n()) {
                living.field_70718_bc = 100;
                living.field_70717_bb = null;
            }
        }
        if (didAttackRegister) {
            living.field_70170_p.func_72960_a((Entity)living, (byte)2);
            if (source != DamageSource.field_76369_e) {
                EntityDamageUtil.setBeenAttacked(living);
            }
            if (entity != null) {
                double deltaX = entity.field_70165_t - living.field_70165_t;
                double deltaZ = entity.field_70161_v - living.field_70161_v;
                while (deltaX * deltaX + deltaZ * deltaZ < 1.0E-4) {
                    deltaX = (Math.random() - Math.random()) * 0.01;
                    deltaZ = (Math.random() - Math.random()) * 0.01;
                }
                living.field_70739_aP = (float)(Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI) - living.field_70177_z;
                if (knockbackMultiplier > 0.0) {
                    EntityDamageUtil.knockBack(living, entity, amount, deltaX, deltaZ, knockbackMultiplier);
                }
            } else {
                living.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (living.func_110143_aJ() <= 0.0f) {
            sound = EntityDamageUtil.getDeathSound(living);
            if (didAttackRegister && sound != null) {
                living.func_85030_a(sound, EntityDamageUtil.getSoundVolume(living), EntityDamageUtil.getSoundPitch(living));
            }
            living.func_70645_a(source);
        } else {
            sound = EntityDamageUtil.getHurtSound(living);
            if (didAttackRegister && sound != null) {
                living.func_85030_a(sound, EntityDamageUtil.getSoundVolume(living), EntityDamageUtil.getSoundPitch(living));
            }
        }
        return true;
    }

    public static void knockBack(EntityLivingBase living, Entity attacker, float damage, double motionX, double motionZ, double multiplier) {
        if (living.func_70681_au().nextDouble() >= living.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            living.field_70160_al = true;
            double horizontal = Math.sqrt(motionX * motionX + motionZ * motionZ);
            double magnitude = 0.4 * multiplier;
            living.field_70159_w /= 2.0;
            living.field_70181_x /= 2.0;
            living.field_70179_y /= 2.0;
            living.field_70159_w -= motionX / horizontal * magnitude;
            living.field_70181_x += magnitude;
            living.field_70179_y -= motionZ / horizontal * magnitude;
            if (living.field_70181_x > 0.2) {
                living.field_70181_x = 0.2 * multiplier;
            }
        }
    }

    public static void damageEntityNT(EntityLivingBase living, DamageSource source, float amount) {
        if (!living.func_85032_ar()) {
            if ((amount = ForgeHooks.onLivingHurt((EntityLivingBase)living, (DamageSource)source, (float)amount)) <= 0.0f) {
                return;
            }
            amount = EntityDamageUtil.applyArmorCalculationsNT(living, source, amount);
            float originalAmount = amount = EntityDamageUtil.applyPotionDamageCalculations(living, source, amount);
            amount = Math.max(amount - living.func_110139_bj(), 0.0f);
            living.func_110149_m(living.func_110139_bj() - (originalAmount - amount));
            if (amount != 0.0f) {
                float health = living.func_110143_aJ();
                living.func_70606_j(health - amount);
                living.func_110142_aN().func_94547_a(source, health, amount);
                living.func_110149_m(living.func_110139_bj() - amount);
            }
        }
    }

    public static float applyArmorCalculationsNT(EntityLivingBase living, DamageSource source, float amount) {
        if (!source.func_76363_c()) {
            float i = 25.0f - (float)living.func_70658_aO() * (1.0f - DamageResistanceHandler.currentPDR);
            float armor = amount * i;
            EntityDamageUtil.damageArmorNT(living, amount);
            amount = armor / 25.0f;
        }
        return amount;
    }

    public static void damageArmorNT(EntityLivingBase living, float amount) {
    }

    @Deprecated
    public static boolean attackEntityFromNT(EntityLivingBase living, DamageSource source, float amount) {
        String s;
        if (ForgeHooks.onLivingAttack((EntityLivingBase)living, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (living.func_85032_ar()) {
            return false;
        }
        if (living.field_70170_p.field_72995_K) {
            return false;
        }
        living.field_70708_bq = 0;
        if (living.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (source.func_76347_k() && living.func_70644_a(Potion.field_76426_n)) {
            return false;
        }
        if ((source == DamageSource.field_82728_o || source == DamageSource.field_82729_p) && living.func_71124_b(4) != null) {
            living.func_71124_b(4).func_77972_a((int)(amount * 4.0f + living.func_70681_au().nextFloat() * amount * 2.0f), living);
            amount *= 0.75f;
        }
        living.field_70721_aZ = 1.5f;
        boolean flag = true;
        if ((float)living.field_70172_ad > (float)living.field_70771_an / 2.0f) {
            if (amount <= living.field_110153_bc) {
                return false;
            }
            EntityDamageUtil.damageEntity(living, source, amount - living.field_110153_bc);
            living.field_110153_bc = amount;
            flag = false;
        } else {
            living.field_110153_bc = amount;
            living.field_70735_aL = living.func_110143_aJ();
            living.field_70172_ad = living.field_70771_an;
            EntityDamageUtil.damageEntity(living, source, amount);
            living.field_70738_aO = 10;
            living.field_70737_aN = 10;
        }
        living.field_70739_aP = 0.0f;
        Entity entity = source.func_76346_g();
        if (entity != null) {
            EntityTameable entitywolf;
            if (entity instanceof EntityLivingBase) {
                living.func_70604_c((EntityLivingBase)entity);
            }
            if (entity instanceof EntityPlayer) {
                living.field_70718_bc = 100;
                living.field_70717_bb = (EntityPlayer)entity;
            } else if (entity instanceof EntityTameable && (entitywolf = (EntityTameable)entity).func_70909_n()) {
                living.field_70718_bc = 100;
                living.field_70717_bb = null;
            }
        }
        if (flag) {
            living.field_70170_p.func_72960_a((Entity)living, (byte)2);
            if (source != DamageSource.field_76369_e) {
                EntityDamageUtil.setBeenAttacked(living);
            }
            if (entity != null) {
                double d1 = entity.field_70165_t - living.field_70165_t;
                double d0 = entity.field_70161_v - living.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                living.field_70739_aP = (float)(Math.atan2(d0, d1) * 180.0 / Math.PI) - living.field_70177_z;
                living.func_70653_a(entity, amount, d1, d0);
            } else {
                living.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (living.func_110143_aJ() <= 0.0f) {
            s = EntityDamageUtil.getDeathSound(living);
            if (flag && s != null) {
                living.func_85030_a(s, EntityDamageUtil.getSoundVolume(living), EntityDamageUtil.getSoundPitch(living));
            }
            living.func_70645_a(source);
        } else {
            s = EntityDamageUtil.getHurtSound(living);
            if (flag && s != null) {
                living.func_85030_a(s, EntityDamageUtil.getSoundVolume(living), EntityDamageUtil.getSoundPitch(living));
            }
        }
        return true;
    }

    public static String getDeathSound(EntityLivingBase living) {
        Method m = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)living, (String[])new String[]{"func_70673_aS", "getDeathSound"}, (Class[])new Class[0]);
        try {
            return (String)m.invoke((Object)living, new Object[0]);
        }
        catch (Exception exception) {
            return "game.neutral.die";
        }
    }

    public static String getHurtSound(EntityLivingBase living) {
        Method m = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)living, (String[])new String[]{"func_70621_aR", "getHurtSound"}, (Class[])new Class[0]);
        try {
            return (String)m.invoke((Object)living, new Object[0]);
        }
        catch (Exception exception) {
            return "game.neutral.hurt";
        }
    }

    public static float getSoundVolume(EntityLivingBase living) {
        Method m = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)living, (String[])new String[]{"func_70599_aP", "getSoundVolume"}, (Class[])new Class[0]);
        try {
            return ((Float)m.invoke((Object)living, new Object[0])).floatValue();
        }
        catch (Exception exception) {
            return 1.0f;
        }
    }

    public static float getSoundPitch(EntityLivingBase living) {
        Method m = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)living, (String[])new String[]{"func_70647_i", "getSoundPitch"}, (Class[])new Class[0]);
        try {
            return ((Float)m.invoke((Object)living, new Object[0])).floatValue();
        }
        catch (Exception exception) {
            return 1.0f;
        }
    }

    @Deprecated
    public static void damageEntity(EntityLivingBase living, DamageSource source, float amount) {
        if (!living.func_85032_ar()) {
            if ((amount = ForgeHooks.onLivingHurt((EntityLivingBase)living, (DamageSource)source, (float)amount)) <= 0.0f) {
                return;
            }
            amount = EntityDamageUtil.applyArmorCalculations(living, source, amount);
            float f1 = amount = EntityDamageUtil.applyPotionDamageCalculations(living, source, amount);
            amount = Math.max(amount - living.func_110139_bj(), 0.0f);
            living.func_110149_m(living.func_110139_bj() - (f1 - amount));
            if (amount != 0.0f) {
                float f2 = living.func_110143_aJ();
                living.func_70606_j(f2 - amount);
                living.func_110142_aN().func_94547_a(source, f2, amount);
                living.func_110149_m(living.func_110139_bj() - amount);
            }
        }
    }

    @Deprecated
    public static float applyArmorCalculations(EntityLivingBase living, DamageSource source, float amount) {
        if (!source.func_76363_c()) {
            int i = 25 - living.func_70658_aO();
            float armor = amount * (float)i;
            amount = armor / 25.0f;
        }
        return amount;
    }

    public static float applyPotionDamageCalculations(EntityLivingBase living, DamageSource source, float amount) {
        float f1;
        int j;
        int resistance;
        if (source.func_151517_h()) {
            return amount;
        }
        if (living.func_70644_a(Potion.field_76429_m) && source != DamageSource.field_76380_i) {
            resistance = (living.func_70660_b(Potion.field_76429_m).func_76458_c() + 1) * 5;
            j = 25 - resistance;
            f1 = amount * (float)j;
            amount = f1 / 25.0f;
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        resistance = EnchantmentHelper.func_77508_a((ItemStack[])living.func_70035_c(), (DamageSource)source);
        if (resistance > 20) {
            resistance = 20;
        }
        if (resistance > 0 && resistance <= 20) {
            j = 25 - resistance;
            f1 = amount * (float)j;
            amount = f1 / 25.0f;
        }
        return amount;
    }

    public static void setBeenAttacked(EntityLivingBase living) {
        living.field_70133_I = living.func_70681_au().nextDouble() >= living.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
    }

    public static MovingObjectPosition getMouseOver(EntityPlayer attacker, double reach) {
        World world = attacker.field_70170_p;
        MovingObjectPosition objectMouseOver = null;
        Entity pointedEntity = null;
        objectMouseOver = EntityDamageUtil.rayTrace(attacker, reach, 1.0f);
        Vec3 pos = EntityDamageUtil.getPosition(attacker);
        Vec3 look = attacker.func_70676_i(1.0f);
        Vec3 end = pos.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        Vec3 hitvec = null;
        float grace = 1.0f;
        List list = world.func_72839_b((Entity)attacker, attacker.field_70121_D.func_72321_a(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach).func_72314_b((double)grace, (double)grace, (double)grace));
        double closest = reach;
        for (int i = 0; i < list.size(); ++i) {
            double dist;
            Entity entity = (Entity)list.get(i);
            if (!entity.func_70067_L()) continue;
            float borderSize = entity.func_70111_Y();
            AxisAlignedBB axisalignedbb = entity.field_70121_D.func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(pos, end);
            if (axisalignedbb.func_72318_a(pos)) {
                if (!(0.0 <= closest)) continue;
                pointedEntity = entity;
                hitvec = movingobjectposition == null ? pos : movingobjectposition.field_72307_f;
                closest = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((dist = pos.func_72438_d(movingobjectposition.field_72307_f)) < closest) && closest != 0.0) continue;
            if (entity == attacker.field_70154_o && !entity.canRiderInteract()) {
                if (closest != 0.0) continue;
                pointedEntity = entity;
                hitvec = movingobjectposition.field_72307_f;
                continue;
            }
            pointedEntity = entity;
            hitvec = movingobjectposition.field_72307_f;
            closest = dist;
        }
        if (pointedEntity != null && (closest < reach || objectMouseOver == null)) {
            objectMouseOver = new MovingObjectPosition(pointedEntity, hitvec);
        }
        return objectMouseOver;
    }

    public static MovingObjectPosition rayTrace(EntityPlayer player, double dist, float interp) {
        Vec3 pos = EntityDamageUtil.getPosition(player);
        Vec3 look = player.func_70676_i(interp);
        Vec3 end = pos.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        return player.field_70170_p.func_147447_a(pos, end, false, false, true);
    }

    public static Vec3 getPosition(EntityPlayer player) {
        return Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
    }
}

