/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.anvil.AnvilRecipes;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityFurnaceBrick;
import com.hbm.util.ItemStackUtil;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryUtil {
    public static int[] masquerade(ISidedInventory sided, int side) {
        if (sided instanceof TileEntityFurnace) {
            return new int[]{1, 0};
        }
        if (sided instanceof TileEntityFurnaceBrick) {
            return new int[]{1, 0, 3};
        }
        return sided.func_94128_d(side);
    }

    public static ItemStack tryAddItemToInventory(ItemStack[] inv, int start, int end, ItemStack stack) {
        ItemStack rem = InventoryUtil.tryAddItemToExistingStack(inv, start, end, stack);
        if (rem == null) {
            return null;
        }
        boolean didAdd = InventoryUtil.tryAddItemToNewSlot(inv, start, end, rem);
        if (didAdd) {
            return null;
        }
        return rem;
    }

    public static ItemStack tryAddItemToInventory(ItemStack[] inv, ItemStack stack) {
        return InventoryUtil.tryAddItemToInventory(inv, 0, inv.length - 1, stack);
    }

    public static ItemStack tryAddItemToExistingStack(ItemStack[] inv, int start, int end, ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        for (int i = start; i <= end; ++i) {
            int transfer;
            if (!InventoryUtil.doesStackDataMatch(inv[i], stack) || (transfer = Math.min(stack.field_77994_a, inv[i].func_77976_d() - inv[i].field_77994_a)) <= 0) continue;
            inv[i].field_77994_a += transfer;
            stack.field_77994_a -= transfer;
            if (stack.field_77994_a != 0) continue;
            return null;
        }
        return stack;
    }

    public static boolean tryAddItemToNewSlot(ItemStack[] inv, int start, int end, ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return true;
        }
        for (int i = start; i <= end; ++i) {
            if (inv[i] != null) continue;
            inv[i] = stack;
            return true;
        }
        return false;
    }

    public static ItemStack tryAddItemToInventory(IInventory inv, int start, int end, ItemStack stack) {
        ItemStack rem = InventoryUtil.tryAddItemToExistingStack(inv, start, end, stack);
        if (rem == null) {
            return null;
        }
        boolean didAdd = InventoryUtil.tryAddItemToNewSlot(inv, start, end, rem);
        if (didAdd) {
            return null;
        }
        return rem;
    }

    public static ItemStack tryAddItemToExistingStack(IInventory inv, int start, int end, ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        for (int i = start; i <= end; ++i) {
            int transfer;
            if (!InventoryUtil.doesStackDataMatch(inv.func_70301_a(i), stack) || (transfer = Math.min(stack.field_77994_a, inv.func_70301_a(i).func_77976_d() - inv.func_70301_a((int)i).field_77994_a)) <= 0) continue;
            inv.func_70301_a((int)i).field_77994_a += transfer;
            stack.field_77994_a -= transfer;
            if (stack.field_77994_a != 0) continue;
            return null;
        }
        return stack;
    }

    public static boolean tryAddItemToNewSlot(IInventory inv, int start, int end, ItemStack stack) {
        if (stack == null || stack.field_77994_a == 0) {
            return true;
        }
        for (int i = start; i <= end; ++i) {
            if (inv.func_70301_a(i) != null) continue;
            inv.func_70299_a(i, stack);
            return true;
        }
        return false;
    }

    public static boolean tryConsumeAStack(ItemStack[] inv, int start, int end, RecipesCommon.AStack stack) {
        if (stack == null) {
            return true;
        }
        RecipesCommon.AStack copy = stack.copy();
        for (int i = start; i <= end; ++i) {
            ItemStack in = inv[i];
            if (!stack.matchesRecipe(in, true)) continue;
            int size = Math.min(copy.stacksize, in.field_77994_a);
            in.field_77994_a -= size;
            copy.stacksize -= size;
            if (in.field_77994_a == 0) {
                inv[i] = null;
            }
            if (copy.stacksize != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean doesStackDataMatch(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null && stack2 == null) {
            return true;
        }
        if (stack1 == null && stack2 != null) {
            return false;
        }
        if (stack1 != null && stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77960_j() != stack2.func_77960_j()) {
            return false;
        }
        if (!stack1.func_77942_o() && !stack2.func_77942_o()) {
            return true;
        }
        if (stack1.func_77942_o() && !stack2.func_77942_o()) {
            return false;
        }
        if (!stack1.func_77942_o() && stack2.func_77942_o()) {
            return false;
        }
        return stack1.func_77978_p().equals((Object)stack2.func_77978_p());
    }

    public static boolean doesPlayerHaveAStacks(EntityPlayer player, List<RecipesCommon.AStack> stacks, boolean shouldRemove) {
        int i;
        ItemStack[] original = player.field_71071_by.field_70462_a;
        ItemStack[] inventory = new ItemStack[original.length];
        boolean[] modified = new boolean[original.length];
        RecipesCommon.AStack[] input = new RecipesCommon.AStack[stacks.size()];
        for (i = 0; i < input.length; ++i) {
            input[i] = stacks.get(i).copy();
        }
        for (i = 0; i < original.length; ++i) {
            if (original[i] == null) continue;
            inventory[i] = original[i].func_77946_l();
        }
        block2: for (i = 0; i < input.length; ++i) {
            RecipesCommon.AStack stack = input[i];
            for (int j = 0; j < inventory.length; ++j) {
                ItemStack inv = inventory[j];
                if (!stack.matchesRecipe(inv, true)) continue;
                int size = Math.min(stack.stacksize, inv.field_77994_a);
                stack.stacksize -= size;
                inv.field_77994_a -= size;
                modified[j] = true;
                if (stack.stacksize <= 0) {
                    input[i] = null;
                    continue block2;
                }
                if (inv.field_77994_a > 0) continue;
                inventory[j] = null;
            }
        }
        for (RecipesCommon.AStack stack : input) {
            if (stack == null) continue;
            return false;
        }
        if (shouldRemove) {
            for (int i2 = 0; i2 < original.length; ++i2) {
                if (inventory[i2] != null && inventory[i2].field_77994_a <= 0) {
                    original[i2] = null;
                    continue;
                }
                if (!modified[i2]) continue;
                original[i2] = inventory[i2];
            }
        }
        return true;
    }

    public static void giveChanceStacksToPlayer(EntityPlayer player, List<AnvilRecipes.AnvilOutput> stacks) {
        for (AnvilRecipes.AnvilOutput out : stacks) {
            if (out.chance != 1.0f && !(player.func_70681_au().nextFloat() < out.chance) || player.field_71071_by.func_70441_a(out.stack.func_77946_l())) continue;
            player.func_71019_a(out.stack.func_77946_l(), false);
        }
    }

    public static boolean hasOreDictMatches(EntityPlayer player, String dict, int count) {
        return InventoryUtil.countOreDictMatches(player, dict) >= count;
    }

    public static int countOreDictMatches(EntityPlayer player, String dict) {
        int count = 0;
        block0: for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            int[] ids;
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null) continue;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)id).equals(dict)) continue;
                count += stack.field_77994_a;
                continue block0;
            }
        }
        return count;
    }

    public static void consumeOreDictMatches(EntityPlayer player, String dict, int count) {
        block0: for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            int[] ids;
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null) continue;
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
                if (!OreDictionary.getOreName((int)id).equals(dict)) continue;
                int toConsume = Math.min(count, stack.field_77994_a);
                player.field_71071_by.func_70298_a(i, toConsume);
                count -= toConsume;
                continue block0;
            }
        }
    }

    public static ItemStack[][] extractObject(Object o) {
        if (o instanceof ItemStack) {
            ItemStack[][] stacks = new ItemStack[1][1];
            stacks[0][0] = ((ItemStack)o).func_77946_l();
            return stacks;
        }
        if (o instanceof ItemStack[]) {
            ItemStack[] ingredients = (ItemStack[])o;
            ItemStack[][] stacks = new ItemStack[ingredients.length][1];
            for (int i = 0; i < ingredients.length; ++i) {
                stacks[i][0] = ingredients[i];
            }
            return stacks;
        }
        if (o instanceof ItemStack[][]) {
            return (ItemStack[][])o;
        }
        if (o instanceof RecipesCommon.AStack) {
            RecipesCommon.AStack astack = (RecipesCommon.AStack)o;
            ItemStack[] ext = astack.extractForNEI().toArray(new ItemStack[0]);
            ItemStack[][] stacks = new ItemStack[1][0];
            stacks[0] = ext;
            return stacks;
        }
        if (o instanceof RecipesCommon.AStack[]) {
            RecipesCommon.AStack[] ingredients = (RecipesCommon.AStack[])o;
            ItemStack[][] stacks = new ItemStack[ingredients.length][0];
            for (int i = 0; i < ingredients.length; ++i) {
                stacks[i] = ingredients[i].extractForNEI().toArray(new ItemStack[0]);
            }
            return stacks;
        }
        if (o instanceof Object[]) {
            Object[] ingredients = (Object[])o;
            ItemStack[][] stacks = new ItemStack[ingredients.length][0];
            for (int i = 0; i < ingredients.length; ++i) {
                Object ingredient = ingredients[i];
                if (ingredient instanceof RecipesCommon.AStack) {
                    stacks[i] = ((RecipesCommon.AStack)ingredient).extractForNEI().toArray(new ItemStack[0]);
                }
                if (!(ingredient instanceof ItemStack)) continue;
                stacks[i] = new ItemStack[1];
                stacks[i][0] = ((ItemStack)ingredient).func_77946_l();
            }
            return stacks;
        }
        MainRegistry.logger.warn("InventoryUtil: extractObject failed for type " + o);
        return new ItemStack[0][0];
    }

    public static boolean doesArrayHaveIngredients(ItemStack[] array, int start, int end, RecipesCommon.AStack ... ingredients) {
        ItemStack[] copy = ItemStackUtil.carefulCopyArrayTruncate(array, start, end);
        RecipesCommon.AStack[] req = new RecipesCommon.AStack[ingredients.length];
        for (int i = 0; i < req.length; ++i) {
            req[i] = ingredients[i] == null ? null : ingredients[i].copy();
        }
        for (RecipesCommon.AStack ingredient : req) {
            if (ingredient == null) continue;
            for (ItemStack input : copy) {
                if (input == null || !ingredient.matchesRecipe(input, true)) continue;
                int size = Math.min(input.field_77994_a, ingredient.stacksize);
                ingredient.stacksize -= size;
                input.field_77994_a -= size;
                if (ingredient.stacksize == 0) break;
            }
            if (ingredient.stacksize <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean doesArrayHaveSpace(ItemStack[] array, int start, int end, ItemStack[] items) {
        ItemStack[] copy = ItemStackUtil.carefulCopyArrayTruncate(array, start, end);
        for (ItemStack item : items) {
            ItemStack remainder;
            if (item == null || (remainder = InventoryUtil.tryAddItemToInventory(copy, item.func_77946_l())) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int start, int end, boolean reverse) {
        int max;
        int toRemove;
        ItemStack current;
        Slot slot;
        boolean success = false;
        int index = start;
        if (reverse) {
            index = end - 1;
        }
        if (stack.func_77985_e()) {
            while (stack.field_77994_a > 0 && (!reverse && index < end || reverse && index >= start)) {
                slot = slots.get(index);
                current = slot.func_75211_c();
                if (current != null && slot.func_75214_a(ItemStackUtil.carefulCopyWithSize(stack, toRemove = Math.min(stack.field_77994_a, max = Math.min(stack.func_77976_d(), slot.func_75219_a())))) && current.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77960_j() == current.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)current)) {
                    int currentSize = current.field_77994_a + stack.field_77994_a;
                    if (currentSize <= max) {
                        stack.field_77994_a = 0;
                        current.field_77994_a = currentSize;
                        slot.func_75215_d(current);
                        success = true;
                    } else if (current.field_77994_a < max) {
                        stack.field_77994_a -= max - current.field_77994_a;
                        current.field_77994_a = max;
                        slot.func_75215_d(current);
                        success = true;
                    }
                }
                if (reverse) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        if (stack.field_77994_a > 0) {
            index = reverse ? end - 1 : start;
            while ((!reverse && index < end || reverse && index >= start) && stack.field_77994_a > 0) {
                slot = slots.get(index);
                current = slot.func_75211_c();
                if (current == null && slot.func_75214_a(ItemStackUtil.carefulCopyWithSize(stack, toRemove = Math.min(stack.field_77994_a, max = Math.min(stack.func_77976_d(), slot.func_75219_a()))))) {
                    current = stack.func_77979_a(toRemove);
                    slot.func_75215_d(current);
                    success = true;
                }
                if (reverse) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        return success;
    }

    public static int countAStackMatches(ItemStack[] inventory, RecipesCommon.AStack stack, boolean ignoreSize) {
        int count = 0;
        for (ItemStack itemStack : inventory) {
            if (itemStack == null || !stack.matchesRecipe(itemStack, true)) continue;
            count += itemStack.field_77994_a;
        }
        return ignoreSize ? count : count / stack.stacksize;
    }

    public static int countAStackMatches(EntityPlayer player, RecipesCommon.AStack stack, boolean ignoreSize) {
        return InventoryUtil.countAStackMatches(player.field_71071_by.field_70462_a, stack, ignoreSize);
    }

    public static boolean doesPlayerHaveAStack(EntityPlayer player, RecipesCommon.AStack stack, boolean shouldRemove, boolean ignoreSize) {
        return InventoryUtil.doesInventoryHaveAStack(player.field_71071_by.field_70462_a, stack, shouldRemove, ignoreSize);
    }

    public static boolean doesInventoryHaveAStack(ItemStack[] inventory, RecipesCommon.AStack stack, boolean shouldRemove, boolean ignoreSize) {
        int totalMatches;
        int totalStacks = 0;
        for (ItemStack itemStack : inventory) {
            if (itemStack != null && stack.matchesRecipe(itemStack, ignoreSize)) {
                totalStacks += itemStack.field_77994_a;
            }
            if (shouldRemove || !ignoreSize || totalStacks <= 0) continue;
            return true;
        }
        int n = totalMatches = ignoreSize ? totalStacks : totalStacks / stack.stacksize;
        if (shouldRemove) {
            int consumedStacks = 0;
            int requiredStacks = ignoreSize ? 1 : stack.stacksize;
            for (ItemStack itemStack : inventory) {
                if (consumedStacks > requiredStacks) break;
                if (itemStack == null || !stack.matchesRecipe(itemStack, true)) continue;
                int toConsume = Math.min(itemStack.field_77994_a, requiredStacks - consumedStacks);
                itemStack.field_77994_a -= toConsume;
                consumedStacks += toConsume;
            }
        }
        return totalMatches > 0;
    }
}

