/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackUtil {
    public static ItemStack carefulCopy(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return stack.func_77946_l();
    }

    public static ItemStack carefulCopyWithSize(ItemStack stack, int size) {
        if (stack == null) {
            return null;
        }
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = size;
        return copy;
    }

    public static ItemStack[] carefulCopyArray(ItemStack[] array) {
        return ItemStackUtil.carefulCopyArray(array, 0, array.length - 1);
    }

    public static ItemStack[] carefulCopyArray(ItemStack[] array, int start, int end) {
        if (array == null) {
            return null;
        }
        ItemStack[] copy = new ItemStack[array.length];
        for (int i = start; i <= end; ++i) {
            copy[i] = ItemStackUtil.carefulCopy(array[i]);
        }
        return copy;
    }

    public static ItemStack[] carefulCopyArrayTruncate(ItemStack[] array, int start, int end) {
        if (array == null) {
            return null;
        }
        int length = end - start + 1;
        ItemStack[] copy = new ItemStack[length];
        for (int i = 0; i < length; ++i) {
            copy[i] = ItemStackUtil.carefulCopy(array[start + i]);
        }
        return copy;
    }

    public static ItemStack addTooltipToStack(ItemStack stack, String ... lines) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound display = new NBTTagCompound();
        NBTTagList lore = new NBTTagList();
        for (String line : lines) {
            lore.func_74742_a((NBTBase)new NBTTagString(EnumChatFormatting.RESET + "" + EnumChatFormatting.GRAY + line));
        }
        display.func_74782_a("Lore", (NBTBase)lore);
        stack.field_77990_d.func_74782_a("display", (NBTBase)display);
        return stack;
    }

    public static void addStacksToNBT(ItemStack stack, ItemStack ... stacks) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound slotNBT = new NBTTagCompound();
            slotNBT.func_74774_a("slot", (byte)i);
            stacks[i].func_77955_b(slotNBT);
            tags.func_74742_a((NBTBase)slotNBT);
        }
        stack.field_77990_d.func_74782_a("items", (NBTBase)tags);
    }

    public static ItemStack[] readStacksFromNBT(ItemStack stack, int count) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagList list = stack.field_77990_d.func_150295_c("items", 10);
        if (count == 0) {
            count = list.func_74745_c();
        }
        ItemStack[] stacks = new ItemStack[count];
        for (int i = 0; i < count; ++i) {
            NBTTagCompound slotNBT = list.func_150305_b(i);
            byte slot = slotNBT.func_74771_c("slot");
            ItemStack loadedStack = ItemStack.func_77949_a((NBTTagCompound)slotNBT);
            if (slot < 0 || slot >= stacks.length || loadedStack == null) continue;
            stacks[slot] = loadedStack;
        }
        return stacks;
    }

    public static ItemStack[] readStacksFromNBT(ItemStack stack) {
        return ItemStackUtil.readStacksFromNBT(stack, 0);
    }

    public static List<String> getOreDictNames(ItemStack stack) {
        int[] ids;
        ArrayList<String> list = new ArrayList<String>();
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)i));
        }
        return list;
    }

    public static void spillItems(World world, int x, int y, int z, Block block, Random rand) {
        IInventory tileentityfurnace = (IInventory)world.func_147438_o(x, y, z);
        if (tileentityfurnace != null) {
            for (int slot = 0; slot < tileentityfurnace.func_70302_i_(); ++slot) {
                ItemStack itemstack = tileentityfurnace.func_70301_a(slot);
                if (itemstack == null) continue;
                float oX = rand.nextFloat() * 0.8f + 0.1f;
                float oY = rand.nextFloat() * 0.8f + 0.1f;
                float oZ = rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = rand.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + oX), (double)((float)y + oY), (double)((float)z + oZ), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float motion = 0.05f;
                    entityitem.field_70159_w = (float)rand.nextGaussian() * motion;
                    entityitem.field_70181_x = (float)rand.nextGaussian() * motion + 0.2f;
                    entityitem.field_70179_y = (float)rand.nextGaussian() * motion;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
    }

    public static boolean areStacksCompatible(ItemStack sta1, ItemStack sta2) {
        return sta1.func_77973_b() == sta2.func_77973_b() && sta1.func_77960_j() == sta2.func_77960_j() && ItemStack.func_77970_a((ItemStack)sta1, (ItemStack)sta2);
    }
}

