/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.wiaj;

import com.hbm.util.I18nUtil;
import com.hbm.wiaj.JarScript;
import com.hbm.wiaj.actors.ActorFancyPanel;
import com.hbm.wiaj.actors.ISpecialActor;
import com.hbm.wiaj.cannery.CanneryBase;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiWorldInAJar
extends GuiScreen {
    private static final ResourceLocation guiUtil = new ResourceLocation("hbm:textures/gui/gui_utility.png");
    RenderBlocks renderer;
    JarScript jarScript;
    ItemStack icon;
    ActorFancyPanel titlePanel;
    CanneryBase[] seeAlso;
    ActorFancyPanel[] seeAlsoTitles;

    public GuiWorldInAJar(JarScript script, String title, ItemStack icon, CanneryBase ... seeAlso) {
        this.field_146289_q = Minecraft.func_71410_x().field_71466_p;
        this.jarScript = script;
        this.icon = icon;
        this.seeAlso = seeAlso;
        this.renderer = new RenderBlocks((IBlockAccess)this.jarScript.world);
        this.renderer.field_147863_w = true;
        this.titlePanel = new ActorFancyPanel(this.field_146289_q, 40, 27, new Object[][]{{I18nUtil.resolveKey(title, new Object[0])}}, 0).setColors(CanneryBase.colorGold).setOrientation(ActorFancyPanel.Orientation.LEFT);
        this.seeAlsoTitles = new ActorFancyPanel[seeAlso.length];
        for (int i = 0; i < seeAlso.length; ++i) {
            this.seeAlsoTitles[i] = new ActorFancyPanel(this.field_146289_q, 40, 27 + 36 * (i + 1), new Object[][]{{I18nUtil.resolveKey(seeAlso[i].getName(), new Object[0])}}, 0).setColors(CanneryBase.colorGrey).setOrientation(ActorFancyPanel.Orientation.LEFT);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        try {
            if (this.jarScript != null) {
                this.jarScript.run();
            }
            this.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
            GL11.glDisable((int)2896);
            this.drawGuiContainerForegroundLayer(mouseX, mouseY);
            GL11.glEnable((int)2896);
        }
        catch (Exception ex) {
            for (StackTraceElement line : ex.getStackTrace()) {
                this.field_146297_k.field_71439_g.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + line.toString()));
            }
            this.field_146297_k.func_147108_a((GuiScreen)null);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        if (this.field_146294_l / 2 - 12 <= mouseX && this.field_146294_l / 2 - 12 + 24 > mouseX && this.field_146295_m - 36 < mouseY && this.field_146295_m - 36 + 24 >= mouseY) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            if (this.jarScript.isPaused()) {
                this.jarScript.unpause();
            } else {
                this.jarScript.pause();
            }
        }
        if (this.field_146294_l / 2 - 12 - 36 <= mouseX && this.field_146294_l / 2 - 12 - 36 + 24 > mouseX && this.field_146295_m - 36 < mouseY && this.field_146295_m - 36 + 24 >= mouseY && this.jarScript.sceneNumber > 0) {
            this.jarScript.rewindOne();
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
        if (this.field_146294_l / 2 - 12 + 36 <= mouseX && this.field_146294_l / 2 - 12 + 36 + 24 > mouseX && this.field_146295_m - 36 < mouseY && this.field_146295_m - 36 + 24 >= mouseY && this.jarScript.sceneNumber < this.jarScript.scenes.size()) {
            this.jarScript.forwardOne();
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
        for (int i = 0; i < this.seeAlso.length; ++i) {
            if (15 > mouseX || 39 <= mouseX || 15 + 36 * (i + 1) >= mouseY || 39 + 36 * (i + 1) < mouseY) continue;
            CanneryBase cannery = this.seeAlso[i];
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiWorldInAJar(cannery.createScript(), cannery.getName(), cannery.getIcon(), cannery.seeAlso()));
            return;
        }
    }

    private void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int playButton;
        for (Map.Entry<Integer, ISpecialActor> actor : this.jarScript.actors.entrySet()) {
            GL11.glPushMatrix();
            actor.getValue().drawForegroundComponent(this.field_146294_l, this.field_146295_m, this.jarScript.ticksElapsed, this.jarScript.interp);
            GL11.glPopMatrix();
        }
        if (Keyboard.isKeyDown((int)56)) {
            ArrayList<Object[]> list = new ArrayList<Object[]>();
            list.add(new Object[]{mouseX - this.field_146294_l / 2 + " / " + (mouseY - this.field_146295_m / 2)});
            this.drawStackText(list, mouseX - this.field_146294_l / 2, mouseY - this.field_146295_m / 2, this.field_146289_q);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(guiUtil);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2929);
        int n = playButton = this.jarScript.isPaused() ? 64 : 40;
        if (this.field_146294_l / 2 - 12 <= mouseX && this.field_146294_l / 2 - 12 + 24 > mouseX && this.field_146295_m - 36 < mouseY && this.field_146295_m - 36 + 24 >= mouseY) {
            this.func_73729_b(this.field_146294_l / 2 - 12, this.field_146295_m - 36, playButton, 24, 24, 24);
        } else {
            this.func_73729_b(this.field_146294_l / 2 - 12, this.field_146295_m - 36, playButton, 48, 24, 24);
        }
        if (this.jarScript.sceneNumber == 0) {
            this.func_73729_b(this.field_146294_l / 2 - 12 - 36, this.field_146295_m - 36, 88, 72, 24, 24);
        } else if (this.field_146294_l / 2 - 12 - 36 <= mouseX && this.field_146294_l / 2 - 12 - 36 + 24 > mouseX && this.field_146295_m - 36 < mouseY && this.field_146295_m - 36 + 24 >= mouseY) {
            this.func_73729_b(this.field_146294_l / 2 - 12 - 36, this.field_146295_m - 36, 88, 24, 24, 24);
        } else {
            this.func_73729_b(this.field_146294_l / 2 - 12 - 36, this.field_146295_m - 36, 88, 48, 24, 24);
        }
        if (this.jarScript.sceneNumber >= this.jarScript.scenes.size()) {
            this.func_73729_b(this.field_146294_l / 2 - 12 + 36, this.field_146295_m - 36, 112, 72, 24, 24);
        } else if (this.field_146294_l / 2 - 12 + 36 <= mouseX && this.field_146294_l / 2 - 12 + 36 + 24 > mouseX && this.field_146295_m - 36 < mouseY && this.field_146295_m - 36 + 24 >= mouseY) {
            this.func_73729_b(this.field_146294_l / 2 - 12 + 36, this.field_146295_m - 36, 112, 24, 24, 24);
        } else {
            this.func_73729_b(this.field_146294_l / 2 - 12 + 36, this.field_146295_m - 36, 112, 48, 24, 24);
        }
        GL11.glEnable((int)2929);
        this.func_73729_b(15, 15, 136, 48, 24, 24);
        RenderHelper.func_74520_c();
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, this.icon, 19, 19);
        field_146296_j.func_94148_a(this.field_146289_q, this.field_146297_k.field_71446_o, this.icon, 19, 19, null);
        RenderHelper.func_74518_a();
        if (15 <= mouseX && 39 > mouseX && 15 < mouseY && 39 >= mouseY) {
            this.titlePanel.drawForegroundComponent(0, 0, this.jarScript.ticksElapsed, this.jarScript.interp);
        }
        for (int i = 0; i < this.seeAlso.length; ++i) {
            CanneryBase also = this.seeAlso[i];
            Minecraft.func_71410_x().func_110434_K().func_110577_a(guiUtil);
            GL11.glDisable((int)2896);
            this.func_73729_b(15, 15 + 36 * (i + 1), 136, 72, 24, 24);
            RenderHelper.func_74520_c();
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, also.getIcon(), 19, 19 + 36 * (i + 1));
            field_146296_j.func_94148_a(this.field_146289_q, this.field_146297_k.field_71446_o, also.getIcon(), 19, 19 + 36 * (i + 1), null);
            RenderHelper.func_74518_a();
            if (15 > mouseX || 39 <= mouseX || 15 + 36 * (i + 1) >= mouseY || 39 + 36 * (i + 1) < mouseY) continue;
            this.seeAlsoTitles[i].drawForegroundComponent(0, 0, this.jarScript.ticksElapsed, this.jarScript.interp);
        }
    }

    private void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        this.setupRotation();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glShadeModel((int)7425);
        Tessellator.field_78398_a.func_78382_b();
        for (int x = 0; x < this.jarScript.world.sizeX; ++x) {
            for (int y = 0; y < this.jarScript.world.sizeY; ++y) {
                for (int z = 0; z < this.jarScript.world.sizeZ; ++z) {
                    this.renderer.func_147805_b(this.jarScript.world.func_147439_a(x, y, z), x, y, z);
                }
            }
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        this.setupRotation();
        RenderHelper.func_74519_b();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        for (Map.Entry<Integer, ISpecialActor> actor : this.jarScript.actors.entrySet()) {
            GL11.glPushMatrix();
            actor.getValue().drawBackgroundComponent(this.jarScript.world, this.jarScript.ticksElapsed, this.jarScript.interp);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void setupRotation() {
        double scale = -10.0;
        GL11.glTranslated((double)(this.field_146294_l / 2), (double)(this.field_146295_m / 2), (double)400.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glScaled((double)1.0, (double)1.0, (double)0.5);
        double zoom = this.jarScript.zoom();
        GL11.glScaled((double)zoom, (double)zoom, (double)zoom);
        GL11.glRotated((double)this.jarScript.pitch(), (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)this.jarScript.yaw(), (double)0.0, (double)1.0, (double)0.0);
        GL11.glTranslated((double)((double)this.jarScript.world.sizeX / -2.0), (double)((double)(-this.jarScript.world.sizeY) / 2.0), (double)((double)this.jarScript.world.sizeZ / -2.0));
        GL11.glTranslated((double)this.jarScript.offsetX(), (double)this.jarScript.offsetY(), (double)this.jarScript.offsetZ());
    }

    public boolean func_73868_f() {
        return false;
    }

    public void drawStackText(List<Object[]> lines, int x, int y, FontRenderer font) {
        x += this.field_146294_l / 2;
        y += this.field_146295_m / 2;
        if (!lines.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int height = 0;
            int longestline = 0;
            for (Object[] line : lines) {
                int lineWidth = 0;
                boolean hasStack = false;
                for (Object o : line) {
                    if (o instanceof String) {
                        lineWidth += font.func_78256_a((String)o);
                        continue;
                    }
                    lineWidth += 18;
                    hasStack = true;
                }
                height = hasStack ? (height += 18) : (height += 10);
                if (lineWidth <= longestline) continue;
                longestline = lineWidth;
            }
            int minX = x + 12;
            int minY = y - 12;
            if (minX + longestline > this.field_146294_l) {
                minX -= 28 + longestline;
            }
            if (minY + height + 6 > this.field_146295_m) {
                minY = this.field_146295_m - height - 6;
            }
            this.field_73735_i = 300.0f;
            GuiWorldInAJar.field_146296_j.field_77023_b = 300.0f;
            int colorBg = -267386864;
            this.func_73733_a(minX - 3, minY - 4, minX + longestline + 3, minY - 3, colorBg, colorBg);
            this.func_73733_a(minX - 3, minY + height + 3, minX + longestline + 3, minY + height + 4, colorBg, colorBg);
            this.func_73733_a(minX - 3, minY - 3, minX + longestline + 3, minY + height + 3, colorBg, colorBg);
            this.func_73733_a(minX - 4, minY - 3, minX - 3, minY + height + 3, colorBg, colorBg);
            this.func_73733_a(minX + longestline + 3, minY - 3, minX + longestline + 4, minY + height + 3, colorBg, colorBg);
            int color0 = 0x505000FF;
            int color1 = (color0 & 0xFEFEFE) >> 1 | color0 & 0xFF000000;
            this.func_73733_a(minX - 3, minY - 3 + 1, minX - 3 + 1, minY + height + 3 - 1, color0, color1);
            this.func_73733_a(minX + longestline + 2, minY - 3 + 1, minX + longestline + 3, minY + height + 3 - 1, color0, color1);
            this.func_73733_a(minX - 3, minY - 3, minX + longestline + 3, minY - 3 + 1, color0, color0);
            this.func_73733_a(minX - 3, minY + height + 2, minX + longestline + 3, minY + height + 3, color1, color1);
            for (int index = 0; index < lines.size(); ++index) {
                Object[] line = lines.get(index);
                int indent = 0;
                boolean hasStack = false;
                for (Object o : line) {
                    if (o instanceof String) continue;
                    hasStack = true;
                }
                for (Object o : line) {
                    if (o instanceof String) {
                        font.func_78261_a((String)o, minX + indent, minY + (hasStack ? 4 : 0), -1);
                        indent += font.func_78256_a((String)o) + 2;
                        continue;
                    }
                    ItemStack stack = (ItemStack)o;
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                    if (stack.field_77994_a == 0) {
                        this.func_73733_a(minX + indent - 1, minY - 1, minX + indent + 17, minY + 17, -65536, -65536);
                        this.func_73733_a(minX + indent, minY, minX + indent + 16, minY + 16, -5197648, -5197648);
                    }
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, minX + indent, minY);
                    field_146296_j.func_94148_a(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, minX + indent, minY, null);
                    RenderHelper.func_74518_a();
                    GL11.glDisable((int)2929);
                    indent += 18;
                }
                if (index == 0) {
                    minY += 2;
                }
                minY += hasStack ? 18 : 10;
            }
            this.field_73735_i = 0.0f;
            GuiWorldInAJar.field_146296_j.field_77023_b = 0.0f;
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.func_74519_b();
            GL11.glEnable((int)32826);
        }
    }
}

