/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.wiaj.cannery;

import com.hbm.blocks.ModBlocks;
import com.hbm.main.ResourceManager;
import com.hbm.render.tileentity.RenderStirling;
import com.hbm.util.I18nUtil;
import com.hbm.wiaj.JarScene;
import com.hbm.wiaj.JarScript;
import com.hbm.wiaj.WorldInAJar;
import com.hbm.wiaj.actions.ActionCreateActor;
import com.hbm.wiaj.actions.ActionRemoveActor;
import com.hbm.wiaj.actions.ActionSetBlock;
import com.hbm.wiaj.actions.ActionSetTile;
import com.hbm.wiaj.actions.ActionSetZoom;
import com.hbm.wiaj.actions.ActionUpdateActor;
import com.hbm.wiaj.actions.ActionWait;
import com.hbm.wiaj.actors.ActorFancyPanel;
import com.hbm.wiaj.actors.ActorTileEntity;
import com.hbm.wiaj.actors.ITileActorRenderer;
import com.hbm.wiaj.cannery.CanneryBase;
import com.hbm.wiaj.cannery.CanneryFirebox;
import com.hbm.wiaj.cannery.Dummies;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;

public class CanneryStirling
extends CanneryBase {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(ModBlocks.machine_stirling);
    }

    @Override
    public String getName() {
        return "cannery.stirling";
    }

    @Override
    public CanneryBase[] seeAlso() {
        return new CanneryBase[]{new CanneryFirebox()};
    }

    @Override
    public JarScript createScript() {
        int i;
        WorldInAJar world = new WorldInAJar(5, 5, 5);
        JarScript script = new JarScript(world);
        JarScene scene0 = new JarScene(script);
        scene0.add(new ActionSetZoom(3.0, 0));
        for (int x = world.sizeX - 1; x >= 0; --x) {
            for (int z = 0; z < world.sizeZ; ++z) {
                scene0.add(new ActionSetBlock(x, 0, z, Blocks.field_150336_V));
            }
            scene0.add(new ActionWait(2));
        }
        scene0.add(new ActionWait(8));
        NBTTagCompound firebox = new NBTTagCompound();
        firebox.func_74780_a("x", 2.0);
        firebox.func_74780_a("y", 1.0);
        firebox.func_74780_a("z", 2.0);
        firebox.func_74768_a("rotation", 5);
        scene0.add(new ActionCreateActor(0, new ActorTileEntity(new CanneryFirebox.ActorFirebox(), firebox)));
        scene0.add(new ActionWait(10));
        NBTTagCompound stirling = new NBTTagCompound();
        stirling.func_74780_a("x", 2.0);
        stirling.func_74780_a("z", 2.0);
        stirling.func_74768_a("rotation", 2);
        scene0.add(new ActionCreateActor(1, new ActorTileEntity(new RenderStirling(), stirling)));
        scene0.add(new ActionUpdateActor(1, "speed", Float.valueOf(0.0f)));
        scene0.add(new ActionUpdateActor(1, "y", 2.0));
        scene0.add(new ActionUpdateActor(1, "type", 0));
        scene0.add(new ActionUpdateActor(1, "hasCog", true));
        scene0.add(new ActionUpdateActor(1, "spin", Float.valueOf(0.0f)));
        scene0.add(new ActionUpdateActor(1, "lastSpin", Float.valueOf(0.0f)));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionCreateActor(2, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, -45, new Object[][]{{I18nUtil.resolveKey("cannery.stirling.0", new Object[0])}}, 250).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene0.add(new ActionWait(60));
        scene0.add(new ActionCreateActor(2, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, 40, new Object[][]{{I18nUtil.resolveKey("cannery.stirling.1", new Object[0])}}, 250).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene0.add(new ActionWait(60));
        scene0.add(new ActionRemoveActor(2));
        scene0.add(new ActionWait(5));
        scene0.add(new ActionUpdateActor(0, "open", true));
        scene0.add(new ActionWait(30));
        scene0.add(new ActionUpdateActor(0, "isOn", true));
        scene0.add(new ActionCreateActor(2, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, -50, 40, new Object[][]{{new ItemStack(Items.field_151044_h)}}, 0).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.RIGHT)));
        scene0.add(new ActionWait(20));
        scene0.add(new ActionRemoveActor(2));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionUpdateActor(0, "open", false));
        scene0.add(new ActionWait(30));
        for (int i2 = 0; i2 < 60; ++i2) {
            scene0.add(new ActionUpdateActor(1, "speed", Float.valueOf((float)i2 / 5.0f)));
            scene0.add(new ActionWait(1));
        }
        scene0.add(new ActionWait(20));
        scene0.add(new ActionSetTile(1, 2, 2, new Dummies.JarDummyConnector()));
        scene0.add(new ActionSetTile(0, 2, 2, new Dummies.JarDummyConnector()));
        scene0.add(new ActionSetTile(0, 1, 2, new Dummies.JarDummyConnector()));
        scene0.add(new ActionSetTile(0, 1, 3, new Dummies.JarDummyConnector()));
        scene0.add(new ActionSetBlock(0, 2, 2, ModBlocks.red_cable));
        scene0.add(new ActionSetBlock(0, 1, 2, ModBlocks.red_cable));
        scene0.add(new ActionSetBlock(0, 1, 3, ModBlocks.machine_detector, 0));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionSetBlock(0, 1, 3, ModBlocks.machine_detector, 1));
        scene0.add(new ActionWait(40));
        JarScene scene1 = new JarScene(script);
        scene1.add(new ActionCreateActor(2, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, -45, new Object[][]{{I18nUtil.resolveKey("cannery.stirling.2", new Object[0])}}, 250).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene1.add(new ActionWait(60));
        scene1.add(new ActionRemoveActor(2));
        NBTTagCompound burner = new NBTTagCompound();
        burner.func_74780_a("x", 2.0);
        burner.func_74780_a("y", 1.0);
        burner.func_74780_a("z", 2.0);
        burner.func_74768_a("rotation", 5);
        scene1.add(new ActionCreateActor(0, new ActorTileEntity(new ActorBurner(), burner)));
        scene1.add(new ActionUpdateActor(1, "y", 3.0));
        scene1.add(new ActionSetTile(1, 2, 2, null));
        scene1.add(new ActionSetTile(1, 3, 2, new Dummies.JarDummyConnector()));
        scene1.add(new ActionSetTile(0, 3, 2, new Dummies.JarDummyConnector()));
        scene1.add(new ActionSetBlock(0, 3, 2, ModBlocks.red_cable));
        for (i = 0; i < 100; ++i) {
            scene1.add(new ActionUpdateActor(1, "speed", Float.valueOf((float)(i + 60) / 5.0f)));
            scene1.add(new ActionWait(1));
        }
        scene1.add(new ActionWait(20));
        scene1.add(new ActionUpdateActor(1, "hasCog", false));
        scene1.add(new ActionSetBlock(0, 1, 3, ModBlocks.machine_detector, 0));
        for (i = 0; i < 160; i += 10) {
            scene1.add(new ActionUpdateActor(1, "speed", Float.valueOf((float)(160 - i) / 5.0f)));
            scene1.add(new ActionWait(1));
        }
        scene1.add(new ActionUpdateActor(1, "speed", Float.valueOf(0.0f)));
        scene1.add(new ActionWait(20));
        scene1.add(new ActionCreateActor(2, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, -45, new Object[][]{{I18nUtil.resolveKey("cannery.stirling.3", new Object[0])}}, 250).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene1.add(new ActionWait(60));
        scene1.add(new ActionRemoveActor(2));
        scene1.add(new ActionWait(20));
        scene1.add(new ActionUpdateActor(1, "hasCog", true));
        scene1.add(new ActionUpdateActor(1, "type", 1));
        scene1.add(new ActionWait(20));
        for (i = 0; i < 60; ++i) {
            scene1.add(new ActionUpdateActor(1, "speed", Float.valueOf((float)i / 5.0f)));
            scene1.add(new ActionWait(1));
        }
        scene1.add(new ActionSetBlock(0, 1, 3, ModBlocks.machine_detector, 1));
        scene1.add(new ActionWait(100));
        script.addScene(scene0).addScene(scene1);
        return script;
    }

    public static class ActorBurner
    implements ITileActorRenderer {
        @Override
        public void renderActor(WorldInAJar world, int ticks, float interp, NBTTagCompound data) {
            double x = data.func_74769_h("x");
            double y = data.func_74769_h("y");
            double z = data.func_74769_h("z");
            GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
            GL11.glEnable((int)2896);
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)2884);
            ITileActorRenderer.bindTexture(ResourceManager.heater_oilburner_tex);
            ResourceManager.heater_oilburner.renderAll();
        }

        @Override
        public void updateActor(int ticks, NBTTagCompound data) {
        }
    }
}

