/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.StructureConfig;
import com.hbm.main.StructureManager;
import com.hbm.world.gen.MapGenNTMFeatures;
import com.hbm.world.gen.NBTStructure;
import com.hbm.world.gen.component.BunkerComponents;
import com.hbm.world.gen.component.Component;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.event.world.WorldEvent;

public class NTMWorldGenerator
implements IWorldGenerator {
    boolean regTest = false;
    private NBTStructure.GenStructure nbtGen = new NBTStructure.GenStructure();
    private final Random rand = new Random();
    private boolean hasPopulationEvent = false;

    public NTMWorldGenerator() {
        final List<BiomeGenBase> invalidBiomes = Arrays.asList(BiomeGenBase.field_76771_b, BiomeGenBase.field_76781_i, BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m, BiomeGenBase.field_150575_M);
        final List<BiomeGenBase> oceanBiomes = Arrays.asList(BiomeGenBase.field_76771_b, BiomeGenBase.field_150575_M);
        final List<BiomeGenBase> beachBiomes = Arrays.asList(BiomeGenBase.field_76787_r, BiomeGenBase.field_150576_N, BiomeGenBase.field_150577_O);
        final List<BiomeGenBase> lighthouseBiomes = Arrays.asList(BiomeGenBase.field_76771_b, BiomeGenBase.field_150575_M, BiomeGenBase.field_76787_r, BiomeGenBase.field_150576_N, BiomeGenBase.field_150577_O);
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.canSpawn = biome -> !invalidBiomes.contains(biome);
                this.start = d -> new MapGenNTMFeatures.Start((World)d.getW(), (Random)d.getX(), (Integer)d.getY(), (Integer)d.getZ());
                this.spawnWeight = 56;
            }
        });
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.canSpawn = biome -> !invalidBiomes.contains(biome);
                this.start = d -> new BunkerComponents.BunkerStart((World)d.getW(), (Random)d.getX(), (Integer)d.getY(), (Integer)d.getZ());
                this.spawnWeight = 4;
            }
        });
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.canSpawn = biome -> !biome.func_76738_d() && biome.field_76750_F >= 2.0f;
                this.structure = new NBTStructure.JigsawPiece("vertibird", StructureManager.vertibird, -3);
                this.spawnWeight = 12;
            }
        });
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.canSpawn = biome -> !biome.func_76738_d() && biome.field_76750_F >= 2.0f;
                this.structure = new NBTStructure.JigsawPiece("crashed_vertibird", StructureManager.crashed_vertibird, -10);
                this.spawnWeight = 12;
            }
        });
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.canSpawn = oceanBiomes::contains;
                this.structure = new NBTStructure.JigsawPiece("aircraft_carrier", StructureManager.aircraft_carrier, -6);
                this.maxHeight = 42;
                this.spawnWeight = 1;
            }
        });
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.canSpawn = biome -> biome == BiomeGenBase.field_150575_M;
                this.structure = new NBTStructure.JigsawPiece("oil_rig", StructureManager.oil_rig, -20);
                this.maxHeight = 12;
                this.minHeight = 11;
                this.spawnWeight = 2;
            }
        });
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.canSpawn = lighthouseBiomes::contains;
                this.structure = new NBTStructure.JigsawPiece("lighthouse", StructureManager.lighthouse, -40);
                this.maxHeight = 29;
                this.minHeight = 28;
                this.spawnWeight = 2;
            }
        });
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.canSpawn = beachBiomes::contains;
                this.structure = new NBTStructure.JigsawPiece("beached_patrol", StructureManager.beached_patrol, -5);
                this.minHeight = 58;
                this.maxHeight = 67;
                this.spawnWeight = 8;
            }
        });
        NBTStructure.registerNullWeight(0, 2, oceanBiomes::contains);
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.canSpawn = biome -> biome == BiomeGenBase.field_76772_c;
                this.structure = new NBTStructure.JigsawPiece("dish", StructureManager.dish, -10);
                this.minHeight = 53;
                this.maxHeight = 65;
                this.spawnWeight = 1;
            }
        });
        NBTStructure.registerNullWeight(0, 2, biome -> biome == BiomeGenBase.field_76772_c);
        NBTStructure.registerNullWeight(0, 2, oceanBiomes::contains);
        final HashMap<Block, StructureComponent.BlockSelector> bricks = new HashMap<Block, StructureComponent.BlockSelector>(){
            {
                this.put(ModBlocks.meteor_brick, new Component.MeteorBricks());
            }
        };
        final HashMap<Block, StructureComponent.BlockSelector> crates = new HashMap<Block, StructureComponent.BlockSelector>(){
            {
                this.put(ModBlocks.meteor_brick, new Component.MeteorBricks());
                this.put(ModBlocks.crate, new Component.SupplyCrates());
                this.put(ModBlocks.meteor_spawner, new Component.CrabSpawners());
            }
        };
        final HashMap<Block, StructureComponent.BlockSelector> ooze = new HashMap<Block, StructureComponent.BlockSelector>(){
            {
                this.put(ModBlocks.meteor_brick, new Component.MeteorBricks());
                this.put(ModBlocks.concrete_colored, new Component.GreenOoze());
            }
        };
        NBTStructure.registerStructure(0, new NBTStructure.SpawnCondition(){
            {
                this.minHeight = 32;
                this.maxHeight = 32;
                this.sizeLimit = 128;
                this.canSpawn = biome -> biome.field_76748_D >= 0.0f;
                this.startPool = "start";
                this.pools = new HashMap<String, NBTStructure.JigsawPool>(){
                    {
                        this.put("start", new NBTStructure.JigsawPool(){
                            {
                                this.add(new NBTStructure.JigsawPiece("meteor_core", StructureManager.meteor_core){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                            }
                        });
                        this.put("spike", new NBTStructure.JigsawPool(){
                            {
                                this.add(new NBTStructure.JigsawPiece("meteor_spike", StructureManager.meteor_spike){
                                    {
                                        this.heightOffset = -3;
                                        this.conformToTerrain = true;
                                    }
                                }, 1);
                            }
                        });
                        this.put("default", new NBTStructure.JigsawPool(){
                            {
                                this.add(new NBTStructure.JigsawPiece("meteor_corner", StructureManager.meteor_corner){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 2);
                                this.add(new NBTStructure.JigsawPiece("meteor_t", StructureManager.meteor_t){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 3);
                                this.add(new NBTStructure.JigsawPiece("meteor_stairs", StructureManager.meteor_stairs){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_room_base_thru", StructureManager.meteor_room_base_thru){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 3);
                                this.add(new NBTStructure.JigsawPiece("meteor_room_base_end", StructureManager.meteor_room_base_end){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 4);
                                this.fallback = "fallback";
                            }
                        });
                        this.put("10room", new NBTStructure.JigsawPool(){
                            {
                                this.add(new NBTStructure.JigsawPiece("meteor_room_basic", StructureManager.meteor_room_basic){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_room_balcony", StructureManager.meteor_room_balcony){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_room_dragon", StructureManager.meteor_room_dragon){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_room_ladder", StructureManager.meteor_room_ladder){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_room_ooze", StructureManager.meteor_room_ooze){
                                    {
                                        this.blockTable = ooze;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_room_split", StructureManager.meteor_room_split){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_room_stairs", StructureManager.meteor_room_stairs){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_room_triple", StructureManager.meteor_room_triple){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                                this.fallback = "roomback";
                            }
                        });
                        this.put("3x3loot", new NBTStructure.JigsawPool(){
                            {
                                this.add(new NBTStructure.JigsawPiece("meteor_3_bale", StructureManager.meteor_3_bale), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_blank", StructureManager.meteor_3_blank), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_block", StructureManager.meteor_3_block), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_crab", StructureManager.meteor_3_crab), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_crab_tesla", StructureManager.meteor_3_crab_tesla), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_crate", StructureManager.meteor_3_crate), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_dirt", StructureManager.meteor_3_dirt), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_lead", StructureManager.meteor_3_lead), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_ooze", StructureManager.meteor_3_ooze), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_pillar", StructureManager.meteor_3_pillar), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_star", StructureManager.meteor_3_star), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_tesla", StructureManager.meteor_3_tesla), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_book", StructureManager.meteor_3_book), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_mku", StructureManager.meteor_3_mku), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_statue", StructureManager.meteor_3_statue), 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_3_glow", StructureManager.meteor_3_glow), 1);
                                this.fallback = "3x3loot";
                            }
                        });
                        this.put("headloot", new NBTStructure.JigsawPool(){
                            {
                                this.add(new NBTStructure.JigsawPiece("meteor_dragon_chest", StructureManager.meteor_dragon_chest){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_dragon_tesla", StructureManager.meteor_dragon_tesla){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_dragon_trap", StructureManager.meteor_dragon_trap){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                                this.add(new NBTStructure.JigsawPiece("meteor_dragon_crate_crab", StructureManager.meteor_dragon_crate_crab){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                                this.fallback = "headback";
                            }
                        });
                        this.put("fallback", new NBTStructure.JigsawPool(){
                            {
                                this.add(new NBTStructure.JigsawPiece("meteor_fallback", StructureManager.meteor_fallback){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                            }
                        });
                        this.put("roomback", new NBTStructure.JigsawPool(){
                            {
                                this.add(new NBTStructure.JigsawPiece("meteor_room_fallback", StructureManager.meteor_room_fallback){
                                    {
                                        this.blockTable = bricks;
                                    }
                                }, 1);
                            }
                        });
                        this.put("headback", new NBTStructure.JigsawPool(){
                            {
                                this.add(new NBTStructure.JigsawPiece("meteor_loot_fallback", StructureManager.meteor_dragon_fallback){
                                    {
                                        this.blockTable = crates;
                                    }
                                }, 1);
                            }
                        });
                    }
                };
            }
        });
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        this.nbtGen = (NBTStructure.GenStructure)TerrainGen.getModdedMapGen((MapGenBase)new NBTStructure.GenStructure(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CUSTOM);
        this.hasPopulationEvent = false;
    }

    private void setRandomSeed(World world, int chunkX, int chunkZ) {
        this.rand.setSeed(world.func_72905_C() + (long)world.field_73011_w.field_76574_g);
        long i = this.rand.nextLong() / 2L * 2L + 1L;
        long j = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i + (long)chunkZ * j ^ world.func_72905_C());
    }

    @SubscribeEvent
    public void generateStructures(PopulateChunkEvent.Pre event) {
        this.hasPopulationEvent = true;
        if (StructureConfig.enableStructures == 0) {
            return;
        }
        if (StructureConfig.enableStructures == 2 && !event.world.func_72912_H().func_76089_r()) {
            return;
        }
        this.setRandomSeed(event.world, event.chunkX, event.chunkZ);
        this.nbtGen.generateStructures(event.world, this.rand, event.chunkProvider, event.chunkX, event.chunkZ);
    }

    public void generate(Random unusedRandom, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.hasPopulationEvent) {
            return;
        }
        if (StructureConfig.enableStructures == 0) {
            return;
        }
        if (StructureConfig.enableStructures == 2 && !world.func_72912_H().func_76089_r()) {
            return;
        }
        this.setRandomSeed(world, chunkX, chunkZ);
        this.nbtGen.generateStructures(world, this.rand, chunkProvider, chunkX, chunkZ);
    }
}

