/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.component;

import com.hbm.blocks.ModBlocks;
import com.hbm.itempool.ItemPool;
import com.hbm.lib.HbmChestContents;
import com.hbm.util.LootGenerator;
import com.hbm.world.gen.component.Component;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class OfficeFeatures {
    public static void registerComponents() {
        MapGenStructureIO.func_143031_a(LargeOffice.class, (String)"NTMLargeOffice");
        MapGenStructureIO.func_143031_a(LargeOfficeCorner.class, (String)"NTMLargeOfficeCorner");
    }

    public static class LargeOfficeCorner
    extends Component {
        private static Component.ConcreteBricks ConcreteBricks = new Component.ConcreteBricks();

        public LargeOfficeCorner() {
        }

        public LargeOfficeCorner(Random rand, int minX, int minZ) {
            super(rand, minX, 64, minZ, 11, 15, 14);
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.field_74887_e.func_78886_a(0, -1, 0);
            int pillarMetaWE = this.getPillarMeta(4);
            int pillarMetaNS = this.getPillarMeta(8);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 4, 0, 11, 2, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 1, 3, 11, 13, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 14, 4, 14, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 10, 0, 13, -1, box);
            this.func_74878_a(world, box, 1, 1, 11, 3, 12, 13);
            this.func_74878_a(world, box, 4, 1, 4, 10, 12, 12);
            this.func_74878_a(world, box, 2, 1, 4, 3, 12, 10);
            this.func_74878_a(world, box, 5, 1, 1, 10, 12, 2);
            this.func_74878_a(world, box, 5, 13, 1, 8, 14, 2);
            this.fillWithBlocks(world, box, 1, 0, 3, 5, 0, 3, ModBlocks.concrete_pillar);
            this.func_151550_a(world, ModBlocks.concrete_pillar, pillarMetaWE, 6, 0, 3, box);
            this.fillWithBlocks(world, box, 7, 0, 3, 10, 0, 3, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 4, 0, 0, 4, 0, 2, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 5, 0, 0, 11, 0, 0, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 11, 1, 0, 11, 12, 0, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 1, 1, 3, 1, 12, 3, ModBlocks.concrete_pillar);
            this.fillWithRandomizedBlocks(world, box, 4, 1, 0, 10, 12, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 13, 0, 9, 13, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 14, 0, 8, 14, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 15, 0, 7, 15, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 2, 1, 3, 5, 2, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 7, 1, 3, 10, 2, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 2, 3, 3, 10, 7, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 2, 8, 3, 9, 10, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 2, 11, 3, 10, 12, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 13, 3, 4, 14, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 6, 13, 3, 9, 13, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 6, 14, 3, 8, 14, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 15, 3, 7, 15, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 1, 1, 4, 15, 2, rand, ConcreteBricks);
            this.fillWithBlocks(world, box, 11, 0, 1, 11, 0, 12, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 11, 0, 13, 11, 12, 13, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 11, 1, 3, 11, 7, 3, ModBlocks.concrete_pillar);
            this.fillWithMetadataBlocks(world, box, 11, 4, 1, 11, 4, 2, ModBlocks.concrete_pillar, pillarMetaNS);
            this.fillWithMetadataBlocks(world, box, 11, 8, 1, 11, 8, 12, ModBlocks.concrete_pillar, pillarMetaNS);
            this.fillWithBlocks(world, box, 11, 9, 3, 11, 11, 3, ModBlocks.concrete_pillar);
            this.fillWithMetadataBlocks(world, box, 11, 12, 1, 11, 12, 12, ModBlocks.concrete_pillar, pillarMetaNS);
            this.fillWithRandomizedBlocks(world, box, 11, 9, 1, 11, 11, 2, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 11, 5, 1, 11, 7, 2, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 11, 1, 1, 11, 3, 2, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 11, 1, 4, 11, 7, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 11, 9, 4, 11, 9, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 11, 10, 4, 11, 10, 4, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 11, 10, 8, 11, 10, 8, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 11, 10, 12, 11, 10, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 11, 11, 4, 11, 11, 12, rand, ConcreteBricks);
            this.fillWithBlocks(world, box, 4, 0, 13, 10, 0, 13, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 4, 0, 14, 4, 12, 14, ModBlocks.concrete_pillar);
            this.func_151550_a(world, ModBlocks.concrete_pillar, 0, 3, 0, 14, box);
            this.fillWithMetadataBlocks(world, box, 1, 0, 14, 2, 0, 14, ModBlocks.concrete_pillar, pillarMetaWE);
            this.fillWithBlocks(world, box, 0, 0, 14, 0, 12, 14, ModBlocks.concrete_pillar);
            this.fillWithRandomizedBlocks(world, box, 4, 1, 13, 10, 1, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 10, 2, 13, 10, 3, 13, rand, ConcreteBricks);
            this.fillWithBlocks(world, box, 9, 2, 13, 9, 3, 13, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 6, 2, 13, 6, 3, 13, ModBlocks.concrete_pillar);
            this.fillWithRandomizedBlocks(world, box, 4, 2, 13, 5, 3, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 4, 13, 10, 5, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 10, 6, 13, 10, 7, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 6, 13, 5, 7, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 8, 13, 10, 9, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 10, 10, 13, 10, 11, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 10, 13, 5, 11, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 12, 13, 10, 12, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 3, 1, 14, 3, 2, 14, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 3, 14, 3, 5, 14, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 8, 14, 3, 9, 14, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 12, 14, 3, 12, 14, rand, ConcreteBricks);
            this.fillWithMetadataBlocks(world, box, 0, 0, 12, 0, 0, 13, ModBlocks.concrete_pillar, pillarMetaNS);
            this.func_151550_a(world, ModBlocks.concrete_pillar, 0, 0, 0, 11, box);
            this.fillWithBlocks(world, box, 0, 0, 10, 0, 12, 10, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 1, 0, 4, 1, 0, 10, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 1, 0, 3, 1, 12, 3, ModBlocks.concrete_pillar);
            this.fillWithRandomizedBlocks(world, box, 0, 1, 11, 0, 2, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 3, 11, 0, 5, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 8, 11, 0, 9, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 12, 11, 0, 12, 13, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 1, 4, 1, 1, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 2, 9, 1, 3, 10, rand, ConcreteBricks);
            this.fillWithBlocks(world, box, 1, 2, 8, 1, 3, 8, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 1, 2, 5, 1, 3, 5, ModBlocks.concrete_pillar);
            this.fillWithRandomizedBlocks(world, box, 1, 2, 4, 1, 3, 4, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 4, 4, 1, 5, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 6, 9, 1, 7, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 6, 4, 1, 7, 4, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 8, 4, 1, 9, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 10, 9, 1, 11, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 10, 4, 1, 11, 4, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 12, 4, 1, 12, 10, rand, ConcreteBricks);
            this.fillWithMetadataBlocks(world, box, 5, 0, 1, 10, 0, 2, ModBlocks.concrete_pillar, pillarMetaWE);
            this.func_151550_a(world, ModBlocks.concrete_pillar, pillarMetaWE, 6, 0, 3, box);
            this.fillWithMetadataBlocks(world, box, 2, 0, 4, 10, 0, 10, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 3, 0, 11, 10, 0, 11, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 4, 0, 12, 10, 0, 12, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 1, 0, 11, 2, 0, 13, Blocks.field_150325_L, 7);
            this.fillWithMetadataBlocks(world, box, 3, 0, 12, 3, 0, 13, Blocks.field_150325_L, 7);
            this.fillWithMetadataBlocks(world, box, 5, 4, 1, 5, 4, 3, ModBlocks.concrete_pillar, pillarMetaNS);
            this.fillWithMetadataBlocks(world, box, 2, 4, 4, 10, 4, 12, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 1, 4, 11, 1, 4, 13, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 2, 4, 13, 3, 4, 13, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 10, 8, 1, 10, 8, 3, ModBlocks.concrete_pillar, pillarMetaNS);
            this.fillWithMetadataBlocks(world, box, 2, 8, 4, 10, 8, 12, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 1, 8, 11, 1, 8, 13, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 2, 8, 13, 3, 8, 13, Blocks.field_150344_f, 1);
            this.fillWithMetadataBlocks(world, box, 5, 12, 1, 5, 12, 2, ModBlocks.concrete_pillar, pillarMetaNS);
            this.fillWithBlocks(world, box, 10, 12, 1, 10, 12, 2, ModBlocks.asphalt);
            this.fillWithBlocks(world, box, 9, 13, 1, 9, 13, 2, ModBlocks.asphalt);
            this.fillWithBlocks(world, box, 8, 14, 1, 8, 14, 2, ModBlocks.asphalt);
            this.fillWithBlocks(world, box, 5, 15, 1, 7, 15, 2, ModBlocks.asphalt);
            this.fillWithBlocks(world, box, 2, 12, 4, 10, 12, 12, ModBlocks.brick_light);
            this.fillWithBlocks(world, box, 1, 12, 11, 1, 12, 13, ModBlocks.brick_light);
            this.fillWithBlocks(world, box, 2, 12, 13, 3, 12, 13, ModBlocks.brick_light);
            int EastStairMeta = this.getStairMeta(1);
            int WestStairMeta = this.getStairMeta(0);
            int EastStairMetaUD = EastStairMeta | 4;
            int WestStairMetaUD = WestStairMeta | 4;
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 9, 1, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMetaUD, 8, 1, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 8, 2, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMetaUD, 7, 2, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 7, 3, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMetaUD, 6, 3, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 6, 4, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMetaUD, 6, 4, 2, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMeta, 6, 5, 2, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMetaUD, 7, 5, 2, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMeta, 7, 6, 2, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMetaUD, 8, 6, 2, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMeta, 8, 7, 2, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMetaUD, 9, 7, 2, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMeta, 9, 8, 2, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMetaUD, 9, 8, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 9, 9, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMetaUD, 8, 9, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 8, 10, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMetaUD, 7, 10, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 7, 11, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMetaUD, 6, 11, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 6, 12, 1, box);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 11, 10, 5, 11, 10, 7, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 11, 10, 9, 11, 10, 11, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 7, 2, 13, 8, 3, 13, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 6, 6, 13, 9, 7, 13, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 6, 10, 13, 9, 11, 13, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 1, 6, 14, 3, 7, 14, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 1, 10, 14, 3, 11, 14, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 0, 6, 11, 0, 7, 13, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 0, 10, 11, 0, 11, 13, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 1, 2, 6, 1, 3, 7, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 1, 6, 5, 1, 7, 8, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 1, 10, 5, 1, 11, 8, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 10, 13, 0, 10, 13, 0, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 11, 13, 0, 11, 13, 13, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 4, 13, 13, 10, 13, 13, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 0, 13, 14, 4, 13, 14, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 0, 13, 10, 0, 13, 13, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 1, 13, 3, 1, 13, 10, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 2, 13, 3, 3, 13, 3, (Block)Blocks.field_150333_U);
            this.fillWithRandomizedBlocks(world, box, 4, 5, 12, 4, 6, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 5, 10, 4, 6, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 7, 10, 4, 7, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 2, 5, 10, 3, 7, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 9, 10, 4, 11, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 2, 11, 10, 3, 11, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 2, 9, 10, 2, 10, 10, rand, ConcreteBricks);
            this.placeDoor(world, box, Blocks.field_150466_ao, 3, false, rand.nextBoolean(), 1, 1, 14);
            this.placeDoor(world, box, Blocks.field_150466_ao, 3, true, rand.nextBoolean(), 2, 1, 14);
            this.placeDoor(world, box, Blocks.field_150466_ao, 0, false, rand.nextBoolean(), 0, 1, 12);
            this.placeDoor(world, box, Blocks.field_150466_ao, 0, true, rand.nextBoolean(), 0, 1, 13);
            this.placeDoor(world, box, ModBlocks.door_office, 3, false, rand.nextBoolean(), 6, 1, 3);
            this.placeDoor(world, box, ModBlocks.door_office, 3, false, rand.nextBoolean(), 5, 5, 3);
            this.placeDoor(world, box, ModBlocks.door_office, 2, false, rand.nextBoolean(), 4, 5, 11);
            this.placeDoor(world, box, ModBlocks.door_office, 3, false, rand.nextBoolean(), 10, 9, 3);
            this.placeDoor(world, box, ModBlocks.door_office, 1, false, rand.nextBoolean(), 3, 9, 10);
            this.placeDoor(world, box, ModBlocks.door_metal, 3, false, rand.nextBoolean(), 5, 13, 3);
            int NorthStairMeta = this.getStairMeta(2);
            int SouthStairMeta = this.getStairMeta(3);
            int NorthStairMetaUD = NorthStairMeta | 4;
            int SouthStairMetaUD = SouthStairMeta | 4;
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 2, 1, 5, box);
            this.func_151550_a(world, Blocks.field_150476_ad, SouthStairMeta, 2, 1, 7, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 2, 1, 8, box);
            this.func_151550_a(world, Blocks.field_150476_ad, NorthStairMeta, 2, 1, 9, box);
            this.func_151550_a(world, Blocks.field_150401_cl, SouthStairMetaUD, 8, 1, 4, box);
            this.fillWithMetadataBlocks(world, box, 8, 1, 5, 8, 1, 7, (Block)Blocks.field_150376_bx, 13);
            this.func_151550_a(world, Blocks.field_150401_cl, NorthStairMetaUD, 8, 1, 8, box);
            this.func_151550_a(world, Blocks.field_150401_cl, WestStairMetaUD, 9, 1, 8, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMeta, 9, 1, 5, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 9, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 10, 8, 2, 7, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 6, 1, 12, box);
            this.func_151550_a(world, Blocks.field_150476_ad, NorthStairMeta, 7, 1, 12, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMeta, 8, 1, 12, box);
            this.func_151550_a(world, Blocks.field_150401_cl, SouthStairMetaUD, 10, 1, 11, box);
            this.func_151550_a(world, Blocks.field_150401_cl, NorthStairMetaUD, 10, 1, 12, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 10, 2, 11, box);
            this.func_151550_a(world, Blocks.field_150401_cl, WestStairMetaUD, 4, 5, 4, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 13, 3, 5, 4, box);
            this.func_151550_a(world, Blocks.field_150401_cl, EastStairMetaUD, 2, 5, 4, box);
            this.func_151550_a(world, Blocks.field_150476_ad, NorthStairMeta, 3, 5, 5, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(1), 3, 6, 4, box);
            this.func_151550_a(world, Blocks.field_150401_cl, EastStairMetaUD, 3, 5, 7, box);
            this.func_151550_a(world, Blocks.field_150401_cl, SouthStairMetaUD, 4, 5, 7, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 13, 4, 5, 8, box);
            this.func_151550_a(world, Blocks.field_150401_cl, NorthStairMetaUD, 4, 5, 9, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 2, 5, 9, box);
            this.func_151550_a(world, Blocks.field_150401_cl, SouthStairMetaUD, 10, 5, 4, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 13, 10, 5, 5, box);
            this.func_151550_a(world, Blocks.field_150401_cl, NorthStairMetaUD, 10, 5, 6, box);
            this.func_151550_a(world, Blocks.field_150476_ad, NorthStairMeta, 8, 5, 6, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(2), 10, 6, 6, box);
            this.func_151550_a(world, Blocks.field_150401_cl, NorthStairMetaUD, 8, 5, 11, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 13, 8, 5, 10, box);
            this.func_151550_a(world, Blocks.field_150401_cl, EastStairMetaUD, 8, 5, 9, box);
            this.func_151550_a(world, Blocks.field_150401_cl, SouthStairMetaUD, 9, 5, 9, box);
            this.func_151550_a(world, Blocks.field_150401_cl, WestStairMetaUD, 10, 5, 9, box);
            this.func_151550_a(world, Blocks.field_150476_ad, WestStairMeta, 10, 5, 10, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(1), 9, 6, 9, box);
            this.func_151550_a(world, Blocks.field_150401_cl, NorthStairMetaUD, 1, 5, 13, box);
            this.func_151550_a(world, (Block)Blocks.field_150376_bx, 13, 1, 5, 12, box);
            this.func_151550_a(world, Blocks.field_150401_cl, SouthStairMetaUD, 1, 5, 11, box);
            this.func_151550_a(world, Blocks.field_150476_ad, NorthStairMeta, 3, 5, 13, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 1, 6, 12, box);
            this.func_151550_a(world, ModBlocks.machine_microwave, this.getDecoMeta(5), 1, 6, 11, box);
            this.func_151550_a(world, Blocks.field_150401_cl, WestStairMetaUD, 8, 9, 4, box);
            this.func_151550_a(world, Blocks.field_150401_cl, EastStairMetaUD, 7, 9, 4, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 9, 9, 4, box);
            this.func_151550_a(world, Blocks.field_150401_cl, SouthStairMetaUD, 5, 9, 5, box);
            this.func_151550_a(world, Blocks.field_150401_cl, WestStairMetaUD, 5, 9, 6, box);
            this.fillWithMetadataBlocks(world, box, 3, 9, 6, 4, 9, 6, (Block)Blocks.field_150376_bx, 13);
            this.func_151550_a(world, Blocks.field_150401_cl, EastStairMetaUD, 2, 9, 6, box);
            this.func_151550_a(world, Blocks.field_150476_ad, SouthStairMeta, 3, 9, 5, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(0), 3, 10, 6, box);
            this.func_151550_a(world, Blocks.field_150401_cl, WestStairMetaUD, 9, 9, 10, box);
            this.fillWithMetadataBlocks(world, box, 7, 9, 10, 8, 9, 10, (Block)Blocks.field_150376_bx, 13);
            this.func_151550_a(world, Blocks.field_150401_cl, SouthStairMetaUD, 6, 9, 10, box);
            this.func_151550_a(world, Blocks.field_150401_cl, EastStairMetaUD, 5, 9, 10, box);
            this.func_151550_a(world, Blocks.field_150401_cl, EastStairMetaUD, 5, 9, 11, box);
            this.func_151550_a(world, Blocks.field_150401_cl, NorthStairMetaUD, 5, 9, 12, box);
            this.func_151550_a(world, Blocks.field_150476_ad, NorthStairMeta, 8, 9, 11, box);
            this.func_151550_a(world, Blocks.field_150476_ad, EastStairMeta, 7, 9, 8, box);
            this.func_151550_a(world, Blocks.field_150476_ad, SouthStairMeta, 9, 9, 8, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 6, 10, 10, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(1), 7, 10, 10, box);
            this.func_151550_a(world, ModBlocks.tape_recorder, this.getDecoMeta(5), 6, 9, 11, box);
            this.placeRandomBobble(world, box, rand, 5, 10, 11);
            this.func_151550_a(world, Blocks.field_150401_cl, WestStairMetaUD, 2, 9, 11, box);
            this.func_151550_a(world, Blocks.field_150401_cl, EastStairMetaUD, 1, 9, 11, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 2, 10, 11, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 5, 13, 9, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 7, 13, 11, box);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(3), 9, 1, 7, ItemPool.getPool("POOL_FILING_CABINET"), 4);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(1), 7, 5, 4, ItemPool.getPool("POOL_FILING_CABINET"), 4);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(1), 7, 6, 4, ItemPool.getPool("POOL_FILING_CABINET"), 4);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(2), 10, 5, 7, ItemPool.getPool("POOL_FILING_CABINET"), 4);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(0), 10, 5, 12, ItemPool.getPool("POOL_FILING_CABINET"), 4);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(0), 10, 6, 12, ItemPool.getPool("POOL_FILING_CABINET"), 4);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(0), 2, 9, 5, ItemPool.getPool("POOL_FILING_CABINET"), 4);
            this.generateLockableContents(world, box, rand, ModBlocks.safe, this.getDecoMeta(2), 1, 9, 13, ItemPool.getPool("POOL_OFFICE_TRASH"), 10, 1.0);
            if (rand.nextInt(2) == 0) {
                this.generateLoreBook(world, box, 1, 9, 13, 7, HbmChestContents.generateOfficeBook(rand));
            }
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(0), 2, 9, 13, ItemPool.getPool("POOL_FILING_CABINET"), 4);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(0), 3, 9, 13, ItemPool.getPool("POOL_FILING_CABINET"), 4);
            this.generateLockableContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(0), 3, 10, 13, ItemPool.getPool("POOL_EXPENSIVE"), 8, 0.1);
            this.func_151550_a(world, ModBlocks.deco_loot, 0, 6, 13, 11, box);
            LootGenerator.lootCapStash(world, this.func_74865_a(6, 11), this.func_74862_a(13), this.func_74873_b(6, 11));
            this.func_151550_a(world, ModBlocks.deco_loot, 0, 1, 10, 11, box);
            LootGenerator.lootMedicine(world, this.func_74865_a(1, 11), this.func_74862_a(10), this.func_74873_b(1, 11));
            return true;
        }
    }

    public static class LargeOffice
    extends Component {
        private static Component.ConcreteBricks ConcreteBricks = new Component.ConcreteBricks();
        private boolean[] hasPlacedLoot = new boolean[2];

        public LargeOffice() {
        }

        public LargeOffice(Random rand, int minX, int minZ) {
            super(rand, minX, 64, minZ, 14, 5, 12);
            this.hasPlacedLoot[0] = false;
            this.hasPlacedLoot[1] = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasLoot1", this.hasPlacedLoot[0]);
            nbt.func_74757_a("hasLoot2", this.hasPlacedLoot[1]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedLoot[0] = nbt.func_74767_n("hasLoot1");
            this.hasPlacedLoot[1] = nbt.func_74767_n("hasLoot2");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.field_74887_e.func_78886_a(0, -1, 0);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 5, 0, 14, 1, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 2, 14, 7, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 8, 8, 12, 0, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 9, 8, 14, 12, -1, box);
            this.func_74878_a(world, box, 1, 1, 3, 4, 3, 6);
            this.func_74878_a(world, box, 6, 1, 1, 13, 3, 6);
            this.func_74878_a(world, box, 10, 1, 7, 13, 3, 11);
            this.fillWithBlocks(world, box, 0, 0, 2, 0, 4, 2, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 5, 0, 0, 5, 4, 0, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 14, 0, 0, 14, 4, 0, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 0, 0, 7, 0, 3, 7, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 0, 0, 12, 0, 3, 12, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 3, 0, 12, 3, 3, 12, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 6, 0, 12, 6, 3, 12, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 9, 0, 12, 9, 3, 12, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 9, 0, 7, 9, 3, 7, ModBlocks.concrete_pillar);
            this.fillWithBlocks(world, box, 14, 0, 12, 14, 4, 12, ModBlocks.concrete_pillar);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 2, 5, 4, 2, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 5, 0, 1, 5, 4, 1, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 6, 0, 0, 13, 1, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 6, 2, 0, 6, 2, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 9, 2, 0, 10, 2, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 13, 2, 0, 13, 2, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 6, 3, 0, 13, 4, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 14, 0, 1, 14, 1, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 14, 2, 1, 14, 2, 2, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 14, 2, 5, 14, 2, 7, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 14, 2, 10, 14, 2, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 14, 3, 1, 14, 4, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 4, 12, 13, 4, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 10, 0, 12, 13, 1, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 10, 2, 12, 10, 2, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 13, 2, 12, 13, 2, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 10, 3, 12, 13, 3, 12, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 9, 0, 8, 9, 3, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 7, 8, 0, 7, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 1, 7, 1, 2, 7, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 1, 7, 8, 3, 7, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 3, 7, 3, 3, 7, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 4, 3, 0, 4, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 0, 3, 0, 1, 6, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 2, 3, 0, 3, 3, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 2, 6, 0, 3, 6, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 5, 1, 3, 5, 3, 5, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 5, 3, 6, 5, 3, 6, rand, ConcreteBricks);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 0, 5, 2, 5, 5, 2, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 5, 5, 1, 5, 5, 1, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 5, 5, 0, 14, 5, 0, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 14, 5, 1, 14, 5, 12, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 0, 5, 12, 13, 5, 12, (Block)Blocks.field_150333_U);
            this.randomlyFillWithBlocks(world, box, rand, 0.85f, 0, 5, 3, 0, 5, 11, (Block)Blocks.field_150333_U);
            this.fillWithMetadataBlocks(world, box, 1, 0, 3, 4, 0, 6, Blocks.field_150325_L, 13);
            this.fillWithBlocks(world, box, 5, 0, 3, 5, 0, 6, ModBlocks.brick_light);
            this.fillWithBlocks(world, box, 6, 0, 1, 13, 0, 6, ModBlocks.brick_light);
            this.fillWithBlocks(world, box, 10, 0, 7, 13, 0, 11, ModBlocks.brick_light);
            this.fillWithBlocks(world, box, 6, 4, 1, 13, 4, 2, ModBlocks.brick_light);
            this.fillWithBlocks(world, box, 1, 4, 3, 13, 4, 11, ModBlocks.brick_light);
            this.fillWithMetadataBlocks(world, box, 9, 1, 3, 11, 1, 6, Blocks.field_150404_cg, 8);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 0, 2, 4, 0, 3, 5, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 7, 2, 0, 8, 2, 0, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 11, 2, 0, 12, 2, 0, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 14, 2, 3, 14, 2, 4, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 14, 2, 8, 14, 2, 9, Blocks.field_150410_aZ);
            this.randomlyFillWithBlocks(world, box, rand, 0.75f, 11, 2, 12, 12, 2, 12, Blocks.field_150410_aZ);
            int stairMetaE = this.getStairMeta(1);
            int stairMetaN = this.getStairMeta(2);
            int stairMetaS = this.getStairMeta(3);
            int stairMetaWU = this.getStairMeta(0) | 4;
            int stairMetaEU = stairMetaE | 4;
            int stairMetaNU = stairMetaN | 4;
            int stairMetaSU = stairMetaS | 4;
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaEU, 1, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaNU, 2, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaWU, 3, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, 2, 1, 3, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(0), 1, 2, 4, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, 7, 1, 3, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaEU, 6, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaWU, 7, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150344_f, 1, 8, 1, 4, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(0), 7, 2, 4, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 8, 2, 4, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaEU, 10, 1, 1, box);
            this.fillWithMetadataBlocks(world, box, 11, 1, 1, 13, 1, 1, Blocks.field_150485_bF, stairMetaSU);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaNU, 13, 1, 2, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaSU, 13, 1, 3, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaWU, 13, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaNU, 13, 1, 5, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaN, 11, 1, 2, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaE, 12, 1, 4, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(1), 11, 2, 1, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(2), 13, 2, 5, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 13, 2, 3, box);
            this.func_151550_a(world, ModBlocks.radiorec, this.getDecoMeta(5), 13, 2, 2, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaEU, 10, 1, 8, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaWU, 11, 1, 8, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaN, 10, 1, 9, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(1), 10, 2, 8, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaSU, 13, 1, 9, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaWU, 13, 1, 10, box);
            this.func_151550_a(world, Blocks.field_150485_bF, stairMetaNU, 13, 1, 11, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaE, 11, 1, 11, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(2), 13, 2, 11, box);
            this.randomlyFillWithBlocks(world, box, rand, 0.25f, 1, 3, 3, 4, 3, 6, Blocks.field_150321_G);
            this.randomlyFillWithBlocks(world, box, rand, 0.25f, 6, 3, 1, 13, 3, 6, Blocks.field_150321_G);
            this.randomlyFillWithBlocks(world, box, rand, 0.25f, 10, 3, 7, 13, 3, 11, Blocks.field_150321_G);
            this.placeDoor(world, box, ModBlocks.door_office, 3, false, rand.nextBoolean(), 2, 1, 7);
            this.placeDoor(world, box, ModBlocks.door_office, 3, true, rand.nextBoolean(), 3, 1, 7);
            this.placeDoor(world, box, ModBlocks.door_office, 0, false, rand.nextBoolean(), 5, 1, 6);
            if (!this.hasPlacedLoot[0]) {
                this.hasPlacedLoot[0] = this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(0), 10, 1, 11, ItemPool.getPool("POOL_OFFICE_TRASH"), 8);
            }
            if (!this.hasPlacedLoot[1]) {
                this.hasPlacedLoot[1] = this.generateLockableContents(world, box, rand, ModBlocks.safe, this.getDecoMeta(3), 6, 1, 1, ItemPool.getPool("POOL_MACHINE_PARTS"), 10, 0.5);
                if (rand.nextInt(2) == 0) {
                    this.generateLoreBook(world, box, 6, 1, 1, 7, HbmChestContents.generateOfficeBook(rand));
                }
            }
            return true;
        }
    }
}

