/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator;

import com.hbm.inventory.RecipesCommon;
import com.hbm.world.generator.CellularDungeonRoom;
import com.hbm.world.generator.DungeonToolbox;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CellularDungeon {
    CellularDungeonRoom[][] cells;
    ForgeDirection[][] doors;
    List<int[]> order = new ArrayList<int[]>();
    int dimX;
    int dimZ;
    public int width;
    public int height;
    public List<RecipesCommon.MetaBlock> floor = new ArrayList<RecipesCommon.MetaBlock>();
    public List<RecipesCommon.MetaBlock> ceiling = new ArrayList<RecipesCommon.MetaBlock>();
    public List<RecipesCommon.MetaBlock> wall = new ArrayList<RecipesCommon.MetaBlock>();
    public List<CellularDungeonRoom> rooms = new ArrayList<CellularDungeonRoom>();
    int tries;
    int branches;
    boolean isGenerating;
    int rec = 0;

    public CellularDungeon(int width, int height, int dimX, int dimZ, int tries, int branches) {
        this.dimX = dimX;
        this.dimZ = dimZ;
        this.width = width;
        this.height = height;
        this.tries = tries;
        this.branches = branches;
    }

    public CellularDungeon(int width, int height, int dimX, int dimZ, int tries, int branches, RecipesCommon.MetaBlock floor, RecipesCommon.MetaBlock ceiling, RecipesCommon.MetaBlock wall) {
        this.dimX = dimX;
        this.dimZ = dimZ;
        this.width = width;
        this.height = height;
        this.tries = tries;
        this.branches = branches;
        this.floor.add(floor);
        this.ceiling.add(ceiling);
        this.wall.add(wall);
    }

    public void generate(World world, int x, int y, int z, Random rand) {
        if (this.isGenerating) {
            return;
        }
        this.isGenerating = true;
        x -= this.dimX * this.width / 2;
        z -= this.dimZ * this.width / 2;
        this.compose(rand);
        for (int[] coord : this.order) {
            int dz;
            int dx;
            if (coord == null || coord.length != 2 || this.cells[dx = coord[0]][dz = coord[1]] == null) continue;
            if (this.doors[dx][dz] == null) {
                this.doors[dx][dz] = ForgeDirection.UNKNOWN;
            }
            this.cells[dx][dz].generate(world, x + dx * (this.width - 1), y, z + dz * (this.width - 1), this.doors[dx][dz]);
        }
        this.isGenerating = false;
    }

    public void compose(Random rand) {
        this.cells = new CellularDungeonRoom[this.dimX][this.dimZ];
        this.doors = new ForgeDirection[this.dimX][this.dimZ];
        this.order.clear();
        int startX = this.dimX / 2;
        int startZ = this.dimZ / 2;
        this.cells[startX][startZ] = DungeonToolbox.getRandom(this.rooms, rand);
        this.doors[startX][startZ] = ForgeDirection.UNKNOWN;
        this.order.add(new int[]{startX, startZ});
        this.rec = 0;
        this.addRoom(startX, startZ, rand, ForgeDirection.UNKNOWN, DungeonToolbox.getRandom(this.rooms, rand));
    }

    private boolean addRoom(int x, int z, Random rand, ForgeDirection door, CellularDungeonRoom room) {
        ++this.rec;
        if (this.rec > this.tries) {
            return false;
        }
        if (x < 0 || z < 0 || x >= this.dimX || z >= this.dimZ) {
            return false;
        }
        if (this.cells[x][z] != null) {
            ForgeDirection dir = CellularDungeon.getRandomDir(rand);
            this.addRoom(x + dir.offsetX, z + dir.offsetZ, rand, dir.getOpposite(), DungeonToolbox.getRandom(this.rooms, rand));
            return false;
        }
        if (room.daisyChain == null || this.addRoom(x + room.daisyDirection.offsetX, z + room.daisyDirection.offsetZ, rand, ForgeDirection.UNKNOWN, room.daisyChain)) {
            this.cells[x][z] = room;
            this.doors[x][z] = door;
            this.order.add(new int[]{x, z});
        }
        for (int i = 0; i < this.branches; ++i) {
            ForgeDirection dir = CellularDungeon.getRandomDir(rand);
            this.addRoom(x + dir.offsetX, z + dir.offsetZ, rand, dir.getOpposite(), DungeonToolbox.getRandom(this.rooms, rand));
        }
        return true;
    }

    public static ForgeDirection getRandomDir(Random rand) {
        return ForgeDirection.getOrientation((int)(rand.nextInt(4) + 2));
    }
}

