/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator;

import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.NotableComments;
import com.hbm.inventory.RecipesCommon;
import com.hbm.world.generator.CellularDungeon;
import com.hbm.world.generator.TimedGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;

@NotableComments
public class JungleDungeon
extends CellularDungeon {
    public boolean hasHole = false;

    public JungleDungeon(int width, int height, int dimX, int dimZ, int tries, int branches) {
        super(width, height, dimX, dimZ, tries, branches);
        int i;
        this.floor.add(new RecipesCommon.MetaBlock(ModBlocks.brick_jungle));
        this.floor.add(new RecipesCommon.MetaBlock(ModBlocks.brick_jungle_cracked));
        for (i = 0; i < 50; ++i) {
            this.wall.add(new RecipesCommon.MetaBlock(ModBlocks.brick_jungle));
            this.wall.add(new RecipesCommon.MetaBlock(ModBlocks.brick_jungle_cracked));
        }
        for (i = 0; i < 16; ++i) {
            this.wall.add(new RecipesCommon.MetaBlock(ModBlocks.brick_jungle_glyph, i));
        }
        this.ceiling.add(new RecipesCommon.MetaBlock(ModBlocks.brick_jungle));
        this.ceiling.add(new RecipesCommon.MetaBlock(ModBlocks.brick_jungle_cracked));
    }

    @Override
    public void generate(final World world, final int x, final int y, final int z, Random rand) {
        super.generate(world, x, y, z, rand);
        TimedGenerator.addOp(world, new TimedGenerator.ITimedJob(){

            @Override
            public void work() {
                JungleDungeon that = JungleDungeon.this;
                if (!that.hasHole) {
                    ArrayList<int[]> rooms = new ArrayList<int[]>();
                    for (int i = 0; i < that.cells.length; ++i) {
                        for (int j = 0; j < that.cells[0].length; ++j) {
                            if (that.cells[i][j] == null) continue;
                            rooms.add(new int[]{i, j});
                        }
                    }
                    if (!rooms.isEmpty()) {
                        int ix = x - JungleDungeon.this.dimX * JungleDungeon.this.width / 2;
                        int iz = z - JungleDungeon.this.dimZ * JungleDungeon.this.width / 2;
                        int[] room = (int[])rooms.get(world.field_73012_v.nextInt(rooms.size()));
                        world.func_147449_b(ix + room[0] * (JungleDungeon.this.width - 1) + JungleDungeon.this.width / 2, y, iz + room[1] * (JungleDungeon.this.width - 1) + JungleDungeon.this.width / 2, ModBlocks.brick_jungle_circle);
                    }
                }
                that.hasHole = false;
            }
        });
    }
}

