/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import api.ntm1of90.compat.fluid.render.NTMFluidColorApplier;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AE2FluidCellRenderer {
    private static boolean initialized = false;
    private static Map<String, Integer> fluidColors = new HashMap<String, Integer>();

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 fluid cell renderer");
            return;
        }
        try {
            MinecraftForge.EVENT_BUS.register((Object)new AE2FluidCellRenderer());
            AE2FluidCellRenderer.initializeAE2();
            System.out.println("[NTM] AE2 fluid cell renderer initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 fluid cell renderer: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void initializeAE2() {
        try {
            Class<?> fluidRenderClass = Class.forName("appeng.client.gui.widgets.GuiFluidSlot");
            AE2FluidCellRenderer.registerCustomRenderer();
            System.out.println("[NTM] Successfully hooked into AE2's fluid rendering system");
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not hook into AE2's fluid rendering system: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerCustomRenderer() {
        try {
            Class<?> fluidCellRendererClass = Class.forName("appeng.client.render.FluidCellRenderer");
            Object instance = fluidCellRendererClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            Method registerColorProviderMethod = fluidCellRendererClass.getMethod("registerColorProvider", String.class, Object.class);
            registerColorProviderMethod.invoke(instance, "hbm", new Object(){

                public int getColor(Fluid fluid) {
                    if (fluid == null) {
                        return -1;
                    }
                    int color = NTMFluidColorApplier.getFluidColorForAE2(fluid);
                    fluidColors.put(fluid.getName(), color);
                    return color;
                }
            });
            System.out.println("[NTM] Registered custom color provider with AE2's fluid cell renderer");
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not register custom color provider: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        TextureMap map = event.map;
        if (map.func_130086_a() != 1) {
            return;
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (!(fluid instanceof ColoredForgeFluid)) continue;
            int color = ((ColoredForgeFluid)fluid).getColorARGB();
            fluidColors.put(fluid.getName(), color);
        }
    }

    public static void applyFluidColorForAE2(Fluid fluid) {
        if (fluid == null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        Integer color = fluidColors.get(fluid.getName());
        if (color != null) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static int getFluidColorForAE2(Fluid fluid) {
        if (fluid == null) {
            return -1;
        }
        Integer color = fluidColors.get(fluid.getName());
        return color != null ? color : -1;
    }
}

