/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@SideOnly(value=Side.CLIENT)
public class AE2RV2FluidColorHandler {
    private static boolean initialized = false;
    private static boolean isRV2 = false;
    private static Object fluidRenderMap = null;
    private static Method registerFluidMethod = null;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 RV2 fluid color handler");
            return;
        }
        try {
            try {
                Class<?> versionClass = Class.forName("appeng.core.AEConfig");
                Field versionField = versionClass.getDeclaredField("VERSION");
                versionField.setAccessible(true);
                String version = (String)versionField.get(null);
                isRV2 = version != null && version.contains("rv2");
                System.out.println("[NTM] Detected AE2 version: " + version + " (RV2: " + isRV2 + ")");
            }
            catch (Exception e) {
                isRV2 = true;
                System.out.println("[NTM] Could not determine AE2 version, assuming RV2");
            }
            if (!isRV2) {
                System.out.println("[NTM] Not using AE2 RV2 fluid color handler as this is not AE2 RV2");
                return;
            }
            FMLCommonHandler.instance().bus().register((Object)new AE2RV2FluidColorHandler());
            AE2RV2FluidColorHandler.initializeAE2RV2();
            System.out.println("[NTM] AE2 RV2 fluid color handler initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 RV2 fluid color handler: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void initializeAE2RV2() {
        try {
            Class<?> fluidRenderMapClass = Class.forName("appeng.client.texture.FluidRenderMap");
            Method instanceMethod = fluidRenderMapClass.getMethod("instance", new Class[0]);
            fluidRenderMap = instanceMethod.invoke(null, new Object[0]);
            registerFluidMethod = fluidRenderMapClass.getMethod("registerFluid", Fluid.class, Integer.TYPE);
            AE2RV2FluidColorHandler.registerAllFluids();
            System.out.println("[NTM] Successfully initialized AE2 RV2 fluid color handler");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 RV2 fluid color handler: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerAllFluids() {
        if (fluidRenderMap == null || registerFluidMethod == null) {
            return;
        }
        try {
            int count = 0;
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (!(fluid instanceof ColoredForgeFluid)) continue;
                int color = ((ColoredForgeFluid)fluid).getColorARGB();
                registerFluidMethod.invoke(fluidRenderMap, fluid, color);
                ++count;
            }
            System.out.println("[NTM] Registered " + count + " fluids with AE2 RV2 FluidRenderMap");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error registering fluids with AE2 RV2: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!isRV2) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 100L == 0L) {
            AE2RV2FluidColorHandler.registerAllFluids();
        }
    }
}

