/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid;

import api.hbm.fluidmk2.IFluidUserMK2;
import api.ntm1of90.compat.fluid.ForgeFluidCompatManager;
import api.ntm1of90.compat.fluid.adapter.NTMFluidTileAdapter;
import api.ntm1of90.compat.fluid.bridge.NTMFluidNetworkBridge;
import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import api.ntm1of90.compat.fluid.registry.ForgeFluidAdapterRegistry;
import api.ntm1of90.compat.fluid.util.NTMForgeFluidConverter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class HBMForgeFluidCompat {
    public static boolean isForgeFluidHandler(TileEntity tile) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IFluidHandler) {
            return true;
        }
        return tile instanceof IFluidUserMK2;
    }

    public static IFluidHandler getForgeFluidHandler(TileEntity tile) {
        return ForgeFluidAdapterRegistry.getFluidHandler(tile);
    }

    public static int transferToForge(FluidTank hbmTank, IFluidHandler forgeHandler, ForgeDirection direction, int maxAmount) {
        return NTMFluidNetworkBridge.transferToForge(hbmTank, forgeHandler, direction, maxAmount);
    }

    public static int transferFromForge(IFluidHandler forgeHandler, FluidTank hbmTank, ForgeDirection direction, int maxAmount) {
        return NTMFluidNetworkBridge.transferFromForge(forgeHandler, hbmTank, direction, maxAmount);
    }

    public static boolean canForgeHandlerAcceptFluid(IFluidHandler forgeHandler, FluidType hbmFluid, ForgeDirection direction) {
        return NTMFluidNetworkBridge.canForgeHandlerAcceptFluid(forgeHandler, hbmFluid, direction);
    }

    public static boolean canForgeHandlerProvideFluid(IFluidHandler forgeHandler, FluidType hbmFluid, ForgeDirection direction) {
        return NTMFluidNetworkBridge.canForgeHandlerProvideFluid(forgeHandler, hbmFluid, direction);
    }

    public static IFluidHandler createForgeFluidHandler(TileEntity tile, FluidTank tank) {
        return NTMFluidTileAdapter.createFluidHandler(tile, tank);
    }

    public static IFluidHandler createForgeFluidHandler(TileEntity tile, FluidTank[] tanks) {
        return new MultiTankForgeAdapter(tile, tanks);
    }

    static {
        ForgeFluidCompatManager.initialize();
        ForgeFluidAdapterRegistry.initialize();
    }

    public static class MultiTankForgeAdapter
    implements IFluidHandler {
        private final TileEntity tile;
        private final FluidTank[] tanks;

        public MultiTankForgeAdapter(TileEntity tile, FluidTank[] tanks) {
            this.tile = tile;
            this.tanks = tanks;
        }

        public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
            if (resource == null || resource.amount <= 0) {
                return 0;
            }
            FluidType hbmFluid = FluidMappingRegistry.getHbmFluidType(resource.getFluid());
            if (hbmFluid == Fluids.NONE) {
                return 0;
            }
            for (FluidTank tank : this.tanks) {
                int ntmAmount;
                int fillAmount;
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                int maxFill = tank.getMaxFill();
                if (currentFill >= maxFill || currentFill > 0 && currentType != hbmFluid || (fillAmount = Math.min(ntmAmount = NTMForgeFluidConverter.toNTMAmount(resource.amount), maxFill - currentFill)) <= 0) continue;
                if (doFill) {
                    if (currentFill == 0) {
                        tank.setTankType(hbmFluid);
                    }
                    tank.setFill(currentFill + fillAmount);
                    if (this.tile != null) {
                        this.tile.func_70296_d();
                    }
                }
                return NTMForgeFluidConverter.toForgeAmount(fillAmount);
            }
            return 0;
        }

        public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
            if (resource == null || resource.amount <= 0) {
                return null;
            }
            FluidType hbmFluid = FluidMappingRegistry.getHbmFluidType(resource.getFluid());
            if (hbmFluid == Fluids.NONE) {
                return null;
            }
            for (FluidTank tank : this.tanks) {
                Fluid forgeFluid;
                int ntmAmount;
                int drainAmount;
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                if (currentFill <= 0 || currentType != hbmFluid || (drainAmount = Math.min(ntmAmount = NTMForgeFluidConverter.toNTMAmount(resource.amount), currentFill)) <= 0) continue;
                if (doDrain) {
                    int newFill = currentFill - drainAmount;
                    tank.setFill(newFill);
                    if (newFill <= 0) {
                        tank.setTankType(Fluids.NONE);
                    }
                    if (this.tile != null) {
                        this.tile.func_70296_d();
                    }
                }
                if ((forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) == null) continue;
                return new FluidStack(forgeFluid, NTMForgeFluidConverter.toForgeAmount(drainAmount));
            }
            return null;
        }

        public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
            if (maxDrain <= 0) {
                return null;
            }
            for (FluidTank tank : this.tanks) {
                int ntmDrainAmount;
                int drainAmount;
                Fluid forgeFluid;
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                if (currentFill <= 0 || currentType == Fluids.NONE || (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) == null || (drainAmount = Math.min(ntmDrainAmount = NTMForgeFluidConverter.toNTMAmount(maxDrain), currentFill)) <= 0) continue;
                if (doDrain) {
                    int newFill = currentFill - drainAmount;
                    tank.setFill(newFill);
                    if (newFill <= 0) {
                        tank.setTankType(Fluids.NONE);
                    }
                    if (this.tile != null) {
                        this.tile.func_70296_d();
                    }
                }
                return new FluidStack(forgeFluid, NTMForgeFluidConverter.toForgeAmount(drainAmount));
            }
            return null;
        }

        public boolean canFill(ForgeDirection from, Fluid fluid) {
            if (fluid == null) {
                return false;
            }
            FluidType hbmFluid = FluidMappingRegistry.getHbmFluidType(fluid);
            if (hbmFluid == Fluids.NONE) {
                return false;
            }
            for (FluidTank tank : this.tanks) {
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                int maxFill = tank.getMaxFill();
                if (currentFill >= maxFill || currentFill > 0 && currentType != hbmFluid) continue;
                return true;
            }
            return false;
        }

        public boolean canDrain(ForgeDirection from, Fluid fluid) {
            if (fluid == null) {
                return false;
            }
            FluidType hbmFluid = FluidMappingRegistry.getHbmFluidType(fluid);
            if (hbmFluid == Fluids.NONE) {
                return false;
            }
            for (FluidTank tank : this.tanks) {
                int currentFill = tank.getFill();
                FluidType currentType = tank.getTankType();
                if (currentFill <= 0 || currentType != hbmFluid) continue;
                return true;
            }
            return false;
        }

        public FluidTankInfo[] getTankInfo(ForgeDirection from) {
            FluidTankInfo[] tankInfo = new FluidTankInfo[this.tanks.length];
            for (int i = 0; i < this.tanks.length; ++i) {
                Fluid forgeFluid;
                FluidTank tank = this.tanks[i];
                int currentFill = tank.getFill();
                int maxFill = tank.getMaxFill();
                FluidType currentType = tank.getTankType();
                FluidStack stack = null;
                if (currentFill > 0 && currentType != Fluids.NONE && (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) != null) {
                    stack = new FluidStack(forgeFluid, NTMForgeFluidConverter.toForgeAmount(currentFill));
                }
                tankInfo[i] = new FluidTankInfo(stack, NTMForgeFluidConverter.toForgeAmount(maxFill));
            }
            return tankInfo;
        }
    }
}

