/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.adapter;

import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import api.ntm1of90.compat.fluid.util.NTMForgeFluidConverter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class ForgeFluidHandlerAdapter
implements IFluidHandler {
    protected abstract FluidTank[] getHbmTanks();

    protected abstract TileEntity getTileEntity();

    protected abstract boolean isValidDirection(ForgeDirection var1);

    protected int toForgeAmount(int ntmAmount) {
        return NTMForgeFluidConverter.toForgeAmount(ntmAmount);
    }

    protected int toNTMAmount(int forgeAmount) {
        return NTMForgeFluidConverter.toNTMAmount(forgeAmount);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        FluidTank[] tanks;
        if (resource == null || resource.amount <= 0 || !this.isValidDirection(from)) {
            return 0;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(resource.getFluid());
        if (ntmFluid == Fluids.NONE) {
            return 0;
        }
        for (FluidTank tank : tanks = this.getHbmTanks()) {
            int maxFill;
            int ntmAmount;
            int fillAmount;
            int currentFill = tank.getFill();
            FluidType currentType = tank.getTankType();
            if (currentFill > 0 && currentType != ntmFluid || (fillAmount = Math.min(ntmAmount = this.toNTMAmount(resource.amount), (maxFill = tank.getMaxFill()) - currentFill)) <= 0) continue;
            if (doFill) {
                if (currentFill == 0) {
                    tank.setTankType(ntmFluid);
                }
                tank.setFill(currentFill + fillAmount);
                TileEntity tile = this.getTileEntity();
                if (tile != null) {
                    tile.func_70296_d();
                }
            }
            return this.toForgeAmount(fillAmount);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        FluidTank[] tanks;
        if (resource == null || resource.amount <= 0 || !this.isValidDirection(from)) {
            return null;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(resource.getFluid());
        if (ntmFluid == Fluids.NONE) {
            return null;
        }
        for (FluidTank tank : tanks = this.getHbmTanks()) {
            Fluid forgeFluid;
            int ntmAmount;
            int drainAmount;
            int currentFill = tank.getFill();
            FluidType currentType = tank.getTankType();
            if (currentFill <= 0 || currentType != ntmFluid || (drainAmount = Math.min(ntmAmount = this.toNTMAmount(resource.amount), currentFill)) <= 0) continue;
            if (doDrain) {
                int newFill = currentFill - drainAmount;
                tank.setFill(newFill);
                TileEntity tile = this.getTileEntity();
                if (tile != null) {
                    tile.func_70296_d();
                }
            }
            if ((forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) == null) continue;
            return new FluidStack(forgeFluid, this.toForgeAmount(drainAmount));
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidTank[] tanks;
        if (maxDrain <= 0 || !this.isValidDirection(from)) {
            return null;
        }
        for (FluidTank tank : tanks = this.getHbmTanks()) {
            int ntmDrainAmount;
            int drainAmount;
            Fluid forgeFluid;
            int currentFill = tank.getFill();
            FluidType currentType = tank.getTankType();
            if (currentFill <= 0 || currentType == Fluids.NONE || (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) == null || (drainAmount = Math.min(ntmDrainAmount = this.toNTMAmount(maxDrain), currentFill)) <= 0) continue;
            if (doDrain) {
                int newFill = currentFill - drainAmount;
                tank.setFill(newFill);
                TileEntity tile = this.getTileEntity();
                if (tile != null) {
                    tile.func_70296_d();
                }
            }
            return new FluidStack(forgeFluid, this.toForgeAmount(drainAmount));
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        FluidTank[] tanks;
        if (fluid == null || !this.isValidDirection(from)) {
            return false;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(fluid);
        if (ntmFluid == Fluids.NONE) {
            return false;
        }
        for (FluidTank tank : tanks = this.getHbmTanks()) {
            int currentFill = tank.getFill();
            FluidType currentType = tank.getTankType();
            int maxFill = tank.getMaxFill();
            if (currentFill >= maxFill || currentFill > 0 && currentType != ntmFluid) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        FluidTank[] tanks;
        if (fluid == null || !this.isValidDirection(from)) {
            return false;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(fluid);
        if (ntmFluid == Fluids.NONE) {
            return false;
        }
        for (FluidTank tank : tanks = this.getHbmTanks()) {
            int currentFill = tank.getFill();
            FluidType currentType = tank.getTankType();
            if (currentFill <= 0 || currentType != ntmFluid) continue;
            return true;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.isValidDirection(from)) {
            return new FluidTankInfo[0];
        }
        FluidTank[] hbmTanks = this.getHbmTanks();
        FluidTankInfo[] tankInfo = new FluidTankInfo[hbmTanks.length];
        for (int i = 0; i < hbmTanks.length; ++i) {
            Fluid forgeFluid;
            FluidTank tank = hbmTanks[i];
            int currentFill = tank.getFill();
            int maxFill = tank.getMaxFill();
            FluidType currentType = tank.getTankType();
            FluidStack stack = null;
            if (currentFill > 0 && currentType != Fluids.NONE && (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) != null) {
                stack = new FluidStack(forgeFluid, this.toForgeAmount(currentFill));
            }
            tankInfo[i] = new FluidTankInfo(stack, this.toForgeAmount(maxFill));
        }
        return tankInfo;
    }

    static {
        FluidMappingRegistry.initialize();
    }
}

