/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.bridge;

import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardSenderMK2;
import api.ntm1of90.compat.fluid.ForgeFluidCompatManager;
import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import api.ntm1of90.compat.fluid.util.NTMForgeFluidConverter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class NTMFluidInteractionHandler {
    public static int transferFluid(IFluidStandardSenderMK2 sender, IFluidHandler receiver, ForgeDirection direction) {
        if (sender == null || receiver == null) {
            return 0;
        }
        FluidTank[] tanks = sender.getSendingTanks();
        if (tanks.length == 0) {
            return 0;
        }
        int totalTransferred = 0;
        for (FluidTank tank : tanks) {
            Fluid forgeFluid;
            int currentFill = tank.getFill();
            FluidType currentType = tank.getTankType();
            if (currentFill <= 0 || currentType == Fluids.NONE || (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) == null) continue;
            int maxDrain = Math.min(currentFill, ForgeFluidCompatManager.getDefaultForgeFlowRate());
            FluidStack stack = new FluidStack(forgeFluid, NTMForgeFluidConverter.toForgeAmount(maxDrain));
            int filled = receiver.fill(direction.getOpposite(), stack, true);
            if (filled <= 0) continue;
            int ntmTransferred = NTMForgeFluidConverter.toNTMAmount(filled);
            int newFill = currentFill - ntmTransferred;
            tank.setFill(newFill);
            totalTransferred += ntmTransferred;
            break;
        }
        return totalTransferred;
    }

    public static int transferFluid(IFluidHandler sender, IFluidStandardReceiverMK2 receiver, ForgeDirection direction) {
        if (sender == null || receiver == null) {
            return 0;
        }
        FluidTank[] tanks = receiver.getReceivingTanks();
        if (tanks.length == 0) {
            return 0;
        }
        int totalTransferred = 0;
        FluidStack drained = sender.drain(direction.getOpposite(), ForgeFluidCompatManager.getDefaultForgeFlowRate(), false);
        if (drained == null || drained.amount <= 0) {
            return 0;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(drained.getFluid());
        if (ntmFluid == Fluids.NONE) {
            return 0;
        }
        for (FluidTank tank : tanks) {
            FluidStack actuallyDrained;
            int ntmAmount;
            int fillAmount;
            int currentFill = tank.getFill();
            FluidType currentType = tank.getTankType();
            int maxFill = tank.getMaxFill();
            if (currentFill >= maxFill || currentFill > 0 && currentType != ntmFluid || (fillAmount = Math.min(ntmAmount = NTMForgeFluidConverter.toNTMAmount(drained.amount), maxFill - currentFill)) <= 0 || (actuallyDrained = sender.drain(direction.getOpposite(), NTMForgeFluidConverter.toForgeAmount(fillAmount), true)) == null || actuallyDrained.amount <= 0) continue;
            int ntmTransferred = NTMForgeFluidConverter.toNTMAmount(actuallyDrained.amount);
            if (currentFill == 0) {
                tank.setTankType(ntmFluid);
            }
            tank.setFill(currentFill + ntmTransferred);
            totalTransferred += ntmTransferred;
            break;
        }
        return totalTransferred;
    }

    public static boolean canAcceptFluid(IFluidHandler handler, FluidType fluid, ForgeDirection direction) {
        if (handler == null || fluid == Fluids.NONE) {
            return false;
        }
        Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(fluid);
        if (forgeFluid == null) {
            return false;
        }
        return handler.canFill(direction.getOpposite(), forgeFluid);
    }

    public static boolean canProvideFluid(IFluidHandler handler, FluidType fluid, ForgeDirection direction) {
        if (handler == null || fluid == Fluids.NONE) {
            return false;
        }
        Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(fluid);
        if (forgeFluid == null) {
            return false;
        }
        return handler.canDrain(direction.getOpposite(), forgeFluid);
    }
}

