/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.registry;

import api.hbm.fluidmk2.IFluidUserMK2;
import api.ntm1of90.compat.fluid.adapter.AutoForgeFluidAdapter;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.TileEntityDummy;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.IFluidHandler;

public class ForgeFluidAdapterRegistry {
    private static final Map<TileEntity, IFluidHandler> adapterMap = new WeakHashMap<TileEntity, IFluidHandler>();
    private static final Map<Class<?>, Boolean> compatibilityCache = new HashMap();
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        MainRegistry.logger.info("ForgeFluidAdapterRegistry initialized");
    }

    public static IFluidHandler getFluidHandler(TileEntity tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        if (tileEntity instanceof IFluidHandler) {
            return (IFluidHandler)tileEntity;
        }
        if (adapterMap.containsKey(tileEntity)) {
            return adapterMap.get(tileEntity);
        }
        if (ForgeFluidAdapterRegistry.isBlacklistedTileEntity(tileEntity)) {
            return null;
        }
        if (tileEntity instanceof IFluidUserMK2) {
            IFluidUserMK2 fluidUser = (IFluidUserMK2)tileEntity;
            FluidTank[] tanks = fluidUser.getAllTanks();
            if (tanks == null || tanks.length == 0) {
                return null;
            }
            AutoForgeFluidAdapter adapter = new AutoForgeFluidAdapter(fluidUser, tileEntity);
            adapterMap.put(tileEntity, adapter);
            return adapter;
        }
        if (tileEntity instanceof TileEntityDummy) {
            TileEntityDummy dummy = (TileEntityDummy)tileEntity;
            TileEntity target = tileEntity.func_145831_w().func_147438_o(dummy.targetX, dummy.targetY, dummy.targetZ);
            return ForgeFluidAdapterRegistry.getFluidHandler(target);
        }
        return null;
    }

    public static void registerFluidHandler(TileEntity tileEntity, IFluidHandler fluidHandler) {
        if (tileEntity != null && fluidHandler != null) {
            adapterMap.put(tileEntity, fluidHandler);
        }
    }

    public static void unregisterFluidHandler(TileEntity tileEntity) {
        if (tileEntity != null) {
            adapterMap.remove(tileEntity);
        }
    }

    private static boolean isBlacklistedTileEntity(TileEntity tileEntity) {
        if (tileEntity == null) {
            return true;
        }
        Class<?> tileClass = tileEntity.getClass();
        if (compatibilityCache.containsKey(tileClass)) {
            return compatibilityCache.get(tileClass);
        }
        String className = tileClass.getName();
        boolean isBlacklisted = className.contains("TileEntityCustomMachine") || className.contains("TileEntityMachineBase") || className.contains("TileEntityMachineAssembler") || className.contains("TileEntityMachineChemplant") || className.contains("TileEntityMachineFluidTank") || className.contains("TileEntityMachineTurbine") || className.contains("TileEntityMachineReactorLarge") || className.contains("TileEntityMachineReactorSmall") || className.contains("TileEntityMachineMiningDrill") || className.contains("TileEntityMachineMiningLaser") || className.contains("TileEntityMachinePress") || className.contains("TileEntityMachineCrystallizer") || className.contains("TileEntityMachineBoiler") || className.contains("TileEntityMachineElectricFurnace") || className.contains("TileEntityMachineGenerator") || className.contains("TileEntityMachineDiesel") || className.contains("TileEntityMachineCombustionEngine") || className.contains("TileEntityMachineOilWell") || className.contains("TileEntityMachineRefinery") || className.contains("TileEntityMachinePumpjack") || className.contains("TileEntityMachineGasFlare") || className.contains("TileEntityMachineCoal") || className.contains("TileEntityMachineRTG") || className.contains("TileEntityMachineBattery") || className.contains("TileEntityMachineTransformer") || className.contains("TileEntityMachineCapacitor") || className.contains("TileEntityMachineEMP") || className.contains("TileEntityMachineRadar") || className.contains("TileEntityMachineRadio") || className.contains("TileEntityMachineRadGen") || className.contains("TileEntityMachineUF6Tank") || className.contains("TileEntityMachinePuF6Tank") || className.contains("TileEntityMachineIGenerator") || className.contains("TileEntityMachineCyclotron") || className.contains("TileEntityMachineOilDerrick") || className.contains("TileEntityMachineGasCent") || className.contains("TileEntityMachineConveyorPress") || className.contains("TileEntityMachineConveyor") || className.contains("TileEntityMachineEPress") || className.contains("TileEntityMachineExcavator") || className.contains("TileEntityMachineMixer") || className.contains("TileEntityMachineFluidTank") || className.contains("TileEntityDummy") || className.contains("TileEntityProxyBase") || className.contains("TileEntityProxyInventory") || className.contains("TileEntityProxyCombo") || className.contains("TileEntityCable") || className.contains("TileEntityConnector") || className.contains("TileEntityPipe") || className.contains("TileEntityPipeBaseNT") || className.contains("TileEntityFluidDuct");
        compatibilityCache.put(tileClass, isBlacklisted);
        return isBlacklisted;
    }

    public static void clearAdapters() {
        adapterMap.clear();
    }
}

