/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.item;

import com.google.common.collect.ImmutableSet;
import com.hbm.entity.item.EntityDroneBase;
import com.hbm.entity.logic.IChunkLoader;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.util.ChunkShapeHelper;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityDeliveryDrone
extends EntityDroneBase
implements IInventory,
IChunkLoader {
    protected ItemStack[] slots = new ItemStack[this.func_70302_i_()];
    public FluidStack fluid;
    protected boolean chunkLoading = false;
    private ForgeChunkManager.Ticket loaderTicket;

    public EntityDeliveryDrone(World world) {
        super(world);
    }

    @Override
    public boolean func_85031_j(Entity attacker) {
        if (this.field_70128_L) {
            return false;
        }
        if (attacker instanceof EntityPlayer && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            for (ItemStack stack : this.slots) {
                if (stack == null) continue;
                this.func_70099_a(stack, 1.0f);
            }
            int meta = 0;
            if (this.field_70180_af.func_75683_a(11) == 1) {
                meta = 2;
            }
            if (this.chunkLoading) {
                ++meta;
            }
            this.func_70099_a(new ItemStack(ModItems.drone, 1, meta), 1.0f);
        }
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(11, (Object)new Byte(0));
    }

    public void setChunkLoading() {
        this.init(ForgeChunkManager.requestTicket((Object)MainRegistry.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY));
        this.chunkLoading = true;
    }

    @Override
    public double getSpeed() {
        return this.field_70180_af.func_75683_a(11) == 1 ? 1.125 : 0.375;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.fluid != null) {
            nbt.func_74768_a("fluidType", this.fluid.type.getID());
            nbt.func_74768_a("fluidAmount", this.fluid.fill);
        }
        nbt.func_74774_a("load", this.field_70180_af.func_75683_a(11));
        nbt.func_74757_a("chunkLoading", this.chunkLoading);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.slots.length) continue;
            this.slots[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        if (nbt.func_74764_b("fluidType")) {
            FluidType type = Fluids.fromNameCompat(nbt.func_74779_i("fluidType"));
            if (type != Fluids.NONE) {
                nbt.func_82580_o(nbt.func_74779_i("fluidType"));
            } else {
                type = Fluids.fromID(nbt.func_74762_e("fluidType"));
            }
            this.fluid = new FluidStack(type, nbt.func_74762_e("fluidAmount"));
        }
        this.field_70180_af.func_75692_b(11, (Object)nbt.func_74771_c("load"));
        if (nbt.func_74767_n("chunkLoading")) {
            this.setChunkLoading();
        }
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.slots[slot] != null) {
            if (this.slots[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.slots[slot];
                this.slots[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.slots[slot].func_77979_a(amount);
            if (this.slots[slot].field_77994_a == 0) {
                this.slots[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.slots[slot] != null) {
            ItemStack itemstack = this.slots[slot];
            this.slots[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70302_i_() {
        return 18;
    }

    public String func_145825_b() {
        return "container.drone";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    protected void loadNeighboringChunks() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            for (ChunkCoordIntPair chunk : ImmutableSet.copyOf((Collection)this.loaderTicket.getChunkList())) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
            for (ChunkCoordIntPair chunk : ChunkShapeHelper.getChunksAlongLineSegment((int)this.field_70165_t, (int)this.field_70161_v, (int)(this.field_70165_t + this.field_70159_w), (int)(this.field_70161_v + this.field_70179_y), 4.0)) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.loaderTicket, (ChunkCoordIntPair)chunk);
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.clearChunkLoader();
    }

    public void clearChunkLoader() {
        if (!this.field_70170_p.field_72995_K && this.loaderTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.loaderTicket);
            this.loaderTicket = null;
        }
    }

    @Override
    public void init(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70170_p.field_72995_K && ticket != null) {
            if (this.loaderTicket == null) {
                this.loaderTicket = ticket;
                this.loaderTicket.bindEntity((Entity)this);
                this.loaderTicket.getModData();
            }
            this.loadNeighboringChunks();
        }
    }
}

