/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.glyphid;

import com.hbm.entity.mob.glyphid.EntityGlyphid;
import com.hbm.lib.ModDamageSource;
import com.hbm.potion.HbmPotion;
import net.minecraft.util.DamageSource;

public abstract class GlyphidStats {
    public static GlyphidStats GLYPHID_STATS_70K = new GlyphidStats70K();
    public static GlyphidStats GLYPHID_STATS_NT = new GlyphidStatsNT();
    protected StatBundle statsGrunt;
    protected StatBundle statsBombardier;
    protected StatBundle statsBrawler;
    protected StatBundle statsDigger;
    protected StatBundle statsBlaster;
    protected StatBundle statsBehemoth;
    protected StatBundle statsBrenda;
    protected StatBundle statsNuclear;
    protected StatBundle statsScout;

    public static GlyphidStats getStats() {
        return GLYPHID_STATS_NT;
    }

    public abstract boolean handleAttack(EntityGlyphid var1, DamageSource var2, float var3);

    public StatBundle getGrunt() {
        return this.statsGrunt;
    }

    public StatBundle getBombardier() {
        return this.statsBombardier;
    }

    public StatBundle getBrawler() {
        return this.statsBrawler;
    }

    public StatBundle getDigger() {
        return this.statsDigger;
    }

    public StatBundle getBlaster() {
        return this.statsBlaster;
    }

    public StatBundle getBehemoth() {
        return this.statsBehemoth;
    }

    public StatBundle getBrenda() {
        return this.statsBrenda;
    }

    public StatBundle getNuclear() {
        return this.statsNuclear;
    }

    public StatBundle getScout() {
        return this.statsScout;
    }

    public static class GlyphidStatsNT
    extends GlyphidStats {
        public GlyphidStatsNT() {
            this.statsGrunt = new StatBundle(20.0, 1.0, 2.0, 0.25f, 0.0f, 1.0f, 0.1f);
            this.statsBombardier = new StatBundle(15.0, 1.0, 2.0, 0.25f, 0.0f, 1.0f, 0.1f);
            this.statsBrawler = new StatBundle(35.0, 1.0, 10.0, 0.5f, 0.5f, 2.0f, 0.15f);
            this.statsDigger = new StatBundle(50.0, 1.0, 10.0, 0.5f, 0.5f, 3.0f, 0.2f);
            this.statsBlaster = new StatBundle(35.0, 1.0, 10.0, 0.5f, 0.5f, 2.0f, 0.15f);
            this.statsBehemoth = new StatBundle(125.0, 0.8, 25.0, 1.5f, 2.0f, 5.0f, 0.35f);
            this.statsBrenda = new StatBundle(250.0, 1.2, 50.0, 2.5f, 5.0f, 10.0f, 0.5f);
            this.statsNuclear = new StatBundle(100.0, 0.8, 50.0, 2.5f, 5.0f, 10.0f, 0.5f);
            this.statsScout = new StatBundle(20.0, 1.5, 5.0, 0.5f, 0.0f, 0.5f, 0.5f);
        }

        @Override
        public boolean handleAttack(EntityGlyphid glyphid, DamageSource source, float amount) {
            if ((source == ModDamageSource.acid || "acidPlayer".equals(source.func_76355_l())) && source.func_76364_f() instanceof EntityGlyphid) {
                return false;
            }
            return glyphid.attackSuperclass(source, amount);
        }
    }

    public static class GlyphidStats70K
    extends GlyphidStats {
        public GlyphidStats70K() {
            this.statsGrunt = new StatBundle(30.0, 1.0, 5.0, 1.0f, 0.5f);
            this.statsBombardier = new StatBundle(20.0, 1.0, 5.0, 1.0f, 0.5f);
            this.statsBrawler = new StatBundle(50.0, 1.0, 10.0, 3.0f, 1.0f);
            this.statsDigger = new StatBundle(50.0, 1.0, 5.0, 1.0f, 0.5f);
            this.statsBlaster = new StatBundle(50.0, 1.0, 10.0, 2.0f, 1.0f);
            this.statsBehemoth = new StatBundle(130.0, 0.8, 25.0, 4.0f, 2.5f);
            this.statsBrenda = new StatBundle(250.0, 1.2, 50.0, 5.0f, 10.0f);
            this.statsNuclear = new StatBundle(100.0, 0.8, 50.0, 5.0f, 10.0f);
            this.statsScout = new StatBundle(20.0, 1.5, 2.0, 1.0f, 0.5f);
        }

        @Override
        public boolean handleAttack(EntityGlyphid glyphid, DamageSource source, float amount) {
            if (!(source.func_151517_h() || source.func_76363_c() || glyphid.field_70170_p.field_72995_K || source.func_76347_k() || source.func_76355_l().equals("ice"))) {
                byte armor = glyphid.func_70096_w().func_75683_a(17);
                if (armor != 0) {
                    if (amount < glyphid.getStats().damageThreshold) {
                        return false;
                    }
                    if (amount > 1.0f && glyphid.isArmorBroken(amount)) {
                        glyphid.breakOffArmor();
                        amount *= 0.25f;
                    }
                    if ((amount -= glyphid.getStats().damageThreshold) < 0.0f) {
                        return true;
                    }
                }
            }
            if (source.func_76347_k()) {
                amount *= 0.7f;
            } else if (source.func_76355_l().equals("player")) {
                amount = (float)((double)amount * (glyphid.getScale() < 1.25 ? 1.5 : (glyphid.getScale() < 1.3 ? 0.8 : 0.5)));
            } else if (source == ModDamageSource.acid || "acidPlayer".equals(source.func_76355_l())) {
                amount = 0.0f;
            } else if (source == DamageSource.field_76368_d) {
                amount *= 15.0f;
            }
            if (glyphid.func_82165_m(HbmPotion.phosphorus.func_76396_c())) {
                amount *= 1.5f;
            }
            return glyphid.attackSuperclass(source, amount);
        }
    }

    public static class StatBundle {
        public final double health;
        public final double speed;
        public final double damage;
        @Deprecated
        public final float divisor;
        @Deprecated
        public final float damageThreshold;
        public final float thresholdMultForArmor;
        public final float resistanceMult;

        public StatBundle(double health, double speed, double damage, float divisor, float damageThreshold) {
            this(health, speed, damage, divisor, damageThreshold, 0.0f, 0.0f);
        }

        public StatBundle(double health, double speed, double damage, float divisor, float damageThreshold, float thresholdMultPerArmor, float resistanceMult) {
            this.health = health;
            this.speed = speed;
            this.damage = damage;
            this.divisor = divisor;
            this.damageThreshold = damageThreshold;
            this.thresholdMultForArmor = thresholdMultPerArmor;
            this.resistanceMult = resistanceMult;
        }
    }
}

