/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.items.weapon.sedna.BulletConfig;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityBulletBeamBase
extends Entity
implements IEntityAdditionalSpawnData {
    public EntityLivingBase thrower;
    public BulletConfig config;
    public float damage;
    public double headingX;
    public double headingY;
    public double headingZ;
    public double beamLength;

    public EntityBulletBeamBase(World world) {
        super(world);
        this.field_70158_ak = true;
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
        this.field_70178_ae = true;
    }

    public EntityLivingBase getThrower() {
        return this.thrower;
    }

    public EntityBulletBeamBase(EntityLivingBase entity, BulletConfig config, float baseDamage) {
        this(entity.field_70170_p);
        this.thrower = entity;
        this.setBulletConfig(config);
        this.damage = baseDamage * this.config.damageMult;
    }

    public EntityBulletBeamBase(EntityLivingBase entity, BulletConfig config, float baseDamage, float angularInaccuracy, double sideOffset, double heightOffset, double frontOffset) {
        this(entity.field_70170_p);
        this.thrower = entity;
        this.setBulletConfig(config);
        this.damage = baseDamage * this.config.damageMult;
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u + (double)this.thrower.func_70047_e(), this.thrower.field_70161_v, this.thrower.field_70177_z + (float)this.field_70146_Z.nextGaussian() * angularInaccuracy, this.thrower.field_70125_A + (float)this.field_70146_Z.nextGaussian() * angularInaccuracy);
        Vec3 offset = Vec3.func_72443_a((double)sideOffset, (double)heightOffset, (double)frontOffset);
        offset.func_72440_a(-this.field_70125_A / 180.0f * (float)Math.PI);
        offset.func_72442_b(-this.field_70177_z / 180.0f * (float)Math.PI);
        this.field_70165_t += offset.field_72450_a;
        this.field_70163_u += offset.field_72448_b;
        this.field_70161_v += offset.field_72449_c;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.headingX = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.headingZ = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.headingY = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double range = 250.0;
        this.headingX *= range;
        this.headingY *= range;
        this.headingZ *= range;
        this.performHitscan();
    }

    public void setRotationsFromVector(Vec3 delta) {
        this.field_70125_A = (float)(-Math.asin(delta.field_72448_b / delta.func_72433_c()) * 180.0 / Math.PI);
        this.field_70177_z = (float)(-Math.atan2(delta.field_72450_a, delta.field_72449_c) * 180.0 / Math.PI);
        this.headingX = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.headingZ = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.headingY = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
    }

    public void performHitscanExternal(double range) {
        this.headingX *= range;
        this.headingY *= range;
        this.headingZ *= range;
        this.performHitscan();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(3, (Object)0);
    }

    public void setBulletConfig(BulletConfig config) {
        this.config = config;
        this.field_70180_af.func_75692_b(3, (Object)config.id);
    }

    public BulletConfig getBulletConfig() {
        int id = this.field_70180_af.func_75679_c(3);
        if (id < 0 || id > BulletConfig.configs.size()) {
            return null;
        }
        return BulletConfig.configs.get(id);
    }

    public void func_70071_h_() {
        if (this.config == null) {
            this.config = this.getBulletConfig();
        }
        if (this.config == null) {
            this.func_70106_y();
            return;
        }
        if (this.config.onUpdate != null) {
            this.config.onUpdate.accept(this);
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > this.config.expires) {
            this.func_70106_y();
        }
    }

    protected void performHitscan() {
        Vec3 vec;
        Vec3 pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.headingX), (double)(this.field_70163_u + this.headingY), (double)(this.field_70161_v + this.headingZ));
        MovingObjectPosition mop = null;
        if (!this.isSpectral()) {
            mop = this.field_70170_p.func_147447_a(pos, nextPos, false, true, false);
        }
        pos = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        nextPos = Vec3.func_72443_a((double)(this.field_70165_t + this.headingX), (double)(this.field_70163_u + this.headingY), (double)(this.field_70161_v + this.headingZ));
        if (mop != null) {
            nextPos = Vec3.func_72443_a((double)mop.field_72307_f.field_72450_a, (double)mop.field_72307_f.field_72448_b, (double)mop.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K && this.doesImpactEntities()) {
            Entity hitEntity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.headingX, this.headingY, this.headingZ).func_72314_b(1.0, 1.0, 1.0));
            double nearest = 0.0;
            MovingObjectPosition nonPenImpact = null;
            for (int j = 0; j < list.size(); ++j) {
                double hitbox;
                AxisAlignedBB aabb;
                MovingObjectPosition hitMop;
                Entity entity = (Entity)list.get(j);
                if (!entity.func_70067_L() || entity == this.thrower || !entity.func_70089_S() || (hitMop = (aabb = entity.field_70121_D.func_72314_b(hitbox = (double)0.3f, hitbox, hitbox)).func_72327_a(pos, nextPos)) == null) continue;
                if (this.doesPenetrate()) {
                    this.onImpact(new MovingObjectPosition(entity, hitMop.field_72307_f));
                    continue;
                }
                double dist = pos.func_72438_d(hitMop.field_72307_f);
                if (!(dist < nearest) && nearest != 0.0) continue;
                hitEntity = entity;
                nearest = dist;
                nonPenImpact = hitMop;
            }
            if (!this.doesPenetrate() && hitEntity != null) {
                mop = new MovingObjectPosition(hitEntity, nonPenImpact.field_72307_f);
            }
        }
        if (mop != null) {
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) == Blocks.field_150427_aO) {
                this.func_70063_aa();
            } else {
                this.onImpact(mop);
            }
            vec = Vec3.func_72443_a((double)(mop.field_72307_f.field_72450_a - this.field_70165_t), (double)(mop.field_72307_f.field_72448_b - this.field_70163_u), (double)(mop.field_72307_f.field_72449_c - this.field_70161_v));
            this.beamLength = vec.func_72433_c();
        } else {
            vec = Vec3.func_72443_a((double)(nextPos.field_72450_a - this.field_70165_t), (double)(nextPos.field_72448_b - this.field_70163_u), (double)(nextPos.field_72449_c - this.field_70161_v));
            this.beamLength = vec.func_72433_c();
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (!this.field_70170_p.field_72995_K && this.config.onImpactBeam != null) {
            this.config.onImpactBeam.accept(this, mop);
        }
    }

    public boolean doesImpactEntities() {
        return this.config.impactsEntities;
    }

    public boolean doesPenetrate() {
        return this.config.doesPenetrate;
    }

    public boolean isSpectral() {
        return this.config.isSpectral;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    public boolean func_70039_c(NBTTagCompound nbt) {
        return false;
    }

    public void func_70037_a(NBTTagCompound nbt) {
        this.func_70106_y();
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeDouble(this.beamLength);
        buf.writeFloat(this.field_70177_z);
        buf.writeFloat(this.field_70125_A);
    }

    public void readSpawnData(ByteBuf buf) {
        this.beamLength = buf.readDouble();
        this.field_70177_z = buf.readFloat();
        this.field_70125_A = buf.readFloat();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }
}

