/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.train;

import com.hbm.entity.train.EntityRailCarCargo;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public abstract class EntityRailCarRidable
extends EntityRailCarCargo {
    public double engineSpeed;
    public SeatDummyEntity[] passengerSeats = new SeatDummyEntity[this.getPassengerSeats().length];

    public EntityRailCarRidable(World world) {
        super(world);
    }

    public abstract double getPoweredAcceleration();

    public abstract double getPassivBrake();

    public abstract boolean shouldUseEngineBrake(EntityPlayer var1);

    public abstract double getMaxPoweredSpeed();

    public abstract boolean canAccelerate();

    public void consumeFuel() {
    }

    public double getGravitySpeed() {
        return 0.0;
    }

    @Override
    public double getCurrentSpeed() {
        if (this.field_70153_n instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.field_70153_n;
            if (this.canAccelerate()) {
                if (player.field_70701_bs > 0.0f) {
                    this.engineSpeed += this.getPoweredAcceleration();
                    this.consumeFuel();
                } else if (player.field_70701_bs < 0.0f) {
                    this.engineSpeed -= this.getPoweredAcceleration();
                    this.consumeFuel();
                } else if (this.shouldUseEngineBrake(player)) {
                    this.engineSpeed *= this.getPassivBrake();
                } else {
                    this.consumeFuel();
                }
            } else {
                this.engineSpeed *= this.getPassivBrake();
            }
        } else {
            this.engineSpeed *= this.getPassivBrake();
        }
        double maxSpeed = this.getMaxPoweredSpeed();
        this.engineSpeed = MathHelper.func_151237_a((double)this.engineSpeed, (double)(-maxSpeed), (double)maxSpeed);
        return this.engineSpeed + this.getGravitySpeed();
    }

    @Override
    public boolean func_130002_c(EntityPlayer player) {
        if (super.func_130002_c(player)) {
            return true;
        }
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        int nearestSeat = this.getNearestSeat(player);
        if (nearestSeat == -1) {
            player.func_70078_a((Entity)this);
        } else if (nearestSeat >= 0) {
            SeatDummyEntity dummySeat = new SeatDummyEntity(this.field_70170_p, this, nearestSeat);
            Vec3 passengerSeat = this.getPassengerSeats()[nearestSeat];
            passengerSeat.func_72442_b((float)((double)(-this.field_70177_z) * Math.PI / 180.0));
            double x = this.renderX + passengerSeat.field_72450_a;
            double y = this.renderY + passengerSeat.field_72448_b;
            double z = this.renderZ + passengerSeat.field_72449_c;
            dummySeat.func_70107_b(x, y - 1.0, z);
            this.passengerSeats[nearestSeat] = dummySeat;
            this.field_70170_p.func_72838_d((Entity)dummySeat);
            player.func_70078_a((Entity)dummySeat);
        }
        return true;
    }

    public int getNearestSeat(EntityPlayer player) {
        double nearestDist = Double.POSITIVE_INFINITY;
        int nearestSeat = -3;
        Vec3[] seats = this.getPassengerSeats();
        Vec3 look = player.func_70676_i(2.0f);
        look.field_72450_a += player.field_70165_t;
        look.field_72448_b += player.field_70163_u + (double)player.eyeHeight - (double)player.field_70129_M;
        look.field_72449_c += player.field_70161_v;
        for (int i = 0; i < seats.length; ++i) {
            Vec3 seat = seats[i];
            if (seat == null || this.passengerSeats[i] != null) continue;
            seat.func_72442_b((float)((double)(-this.field_70177_z) * Math.PI / 180.0));
            double x = this.renderX + seat.field_72450_a;
            double y = this.renderY + seat.field_72448_b;
            double z = this.renderZ + seat.field_72449_c;
            Vec3 delta = Vec3.func_72443_a((double)(look.field_72450_a - x), (double)(look.field_72448_b - y), (double)(look.field_72449_c - z));
            double dist = delta.func_72433_c();
            if (!(dist < nearestDist)) continue;
            nearestDist = dist;
            nearestSeat = i;
        }
        if (this.field_70153_n == null) {
            Vec3 seat = this.getRiderSeatPosition();
            seat.func_72442_b((float)((double)(-this.field_70177_z) * Math.PI / 180.0));
            double x = this.renderX + seat.field_72450_a;
            double y = this.renderY + seat.field_72448_b;
            double z = this.renderZ + seat.field_72449_c;
            Vec3 delta = Vec3.func_72443_a((double)(look.field_72450_a - x), (double)(look.field_72448_b - y), (double)(look.field_72449_c - z));
            double dist = delta.func_72433_c();
            if (dist < nearestDist) {
                nearestDist = dist;
                nearestSeat = -1;
            }
        }
        if (nearestDist > 180.0) {
            return -2;
        }
        return nearestSeat;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            Vec3[] seats = this.getPassengerSeats();
            for (int i = 0; i < this.passengerSeats.length; ++i) {
                SeatDummyEntity seat = this.passengerSeats[i];
                if (seat == null) continue;
                if (seat.field_70153_n == null) {
                    this.passengerSeats[i] = null;
                    seat.func_70106_y();
                    continue;
                }
                Vec3 rot = seats[i];
                rot.func_72440_a((float)((double)this.field_70125_A * Math.PI / 180.0));
                rot.func_72442_b((float)((double)(-this.field_70177_z) * Math.PI / 180.0));
                double x = this.renderX + rot.field_72450_a;
                double y = this.renderY + rot.field_72448_b;
                double z = this.renderZ + rot.field_72449_c;
                seat.func_70107_b(x, y - 1.0, z);
            }
        }
    }

    public void func_70043_V() {
        Vec3 offset = this.getRiderSeatPosition();
        offset.func_72440_a((float)((double)this.field_70125_A * Math.PI / 180.0));
        offset.func_72442_b((float)((double)(-this.field_70177_z) * Math.PI / 180.0));
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.renderX + offset.field_72450_a, this.renderY + offset.field_72448_b, this.renderZ + offset.field_72449_c);
        }
    }

    public abstract Vec3 getRiderSeatPosition();

    public abstract Vec3[] getPassengerSeats();

    @Override
    @SideOnly(value=Side.CLIENT)
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        ArrayList<String> text = new ArrayList<String>();
        text.add("Nearest seat: " + this.getNearestSeat(MainRegistry.proxy.me()));
    }

    public static class SeatDummyEntity
    extends Entity {
        private int turnProgress;
        private double trainX;
        private double trainY;
        private double trainZ;
        public EntityRailCarRidable train;

        public SeatDummyEntity(World world) {
            super(world);
            this.func_70105_a(0.5f, 0.1f);
        }

        public SeatDummyEntity(World world, EntityRailCarRidable train, int index) {
            this(world);
            this.train = train;
            if (train != null) {
                this.field_70180_af.func_75692_b(3, (Object)train.func_145782_y());
            }
            this.field_70180_af.func_75692_b(4, (Object)index);
        }

        protected void func_70088_a() {
            this.field_70180_af.func_75682_a(3, (Object)new Integer(0));
            this.field_70180_af.func_75682_a(4, (Object)new Integer(0));
        }

        protected void func_70014_b(NBTTagCompound nbt) {
        }

        public boolean func_70039_c(NBTTagCompound nbt) {
            return false;
        }

        public void func_70037_a(NBTTagCompound nbt) {
            this.func_70106_y();
        }

        public void func_70071_h_() {
            if (!this.field_70170_p.field_72995_K) {
                if (this.train == null || this.train.field_70128_L) {
                    this.func_70106_y();
                }
            } else if (this.turnProgress > 0) {
                this.field_70126_B = this.field_70177_z;
                double x = this.field_70165_t + (this.trainX - this.field_70165_t) / (double)this.turnProgress;
                double y = this.field_70163_u + (this.trainY - this.field_70163_u) / (double)this.turnProgress;
                double z = this.field_70161_v + (this.trainZ - this.field_70161_v) / (double)this.turnProgress;
                --this.turnProgress;
                this.func_70107_b(x, y, z);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void func_70056_a(double posX, double posY, double posZ, float yaw, float pitch, int turnProg) {
            this.trainX = posX;
            this.trainY = posY;
            this.trainZ = posZ;
            this.turnProgress = turnProg + 2;
        }

        public void func_70043_V() {
            if (this.field_70153_n != null) {
                int eid;
                Entity entity;
                if (this.train == null && (entity = this.field_70170_p.func_73045_a(eid = this.field_70180_af.func_75679_c(3))) instanceof EntityRailCarRidable) {
                    this.train = (EntityRailCarRidable)entity;
                }
                if (this.train == null) {
                    this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
                    return;
                }
                int index = this.field_70180_af.func_75679_c(4);
                Vec3 rot = this.train.getPassengerSeats()[index];
                rot.func_72440_a((float)((double)this.train.field_70125_A * Math.PI / 180.0));
                rot.func_72442_b((float)((double)(-this.train.field_70177_z) * Math.PI / 180.0));
                double x = this.train.renderX + rot.field_72450_a;
                double y = this.train.renderY + rot.field_72448_b;
                double z = this.train.renderZ + rot.field_72449_c;
                this.field_70153_n.func_70107_b(x, y, z);
            }
        }
    }
}

