/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.imc.ICompatNHNEI;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.gui.GUIMachineChemplant;
import com.hbm.inventory.recipes.ChemplantRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ChemplantRecipeHandler
extends TemplateRecipeHandler
implements ICompatNHNEI {
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsRec = new LinkedList();
    public LinkedList<TemplateRecipeHandler.RecipeTransferRect> transferRectsGui = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiRec = new LinkedList();
    public LinkedList<Class<? extends GuiContainer>> guiGui = new LinkedList();

    @Override
    public ItemStack[] getMachinesForRecipe() {
        return new ItemStack[]{new ItemStack(ModBlocks.machine_chemplant), new ItemStack(ModBlocks.machine_chemfac)};
    }

    @Override
    public String getRecipeID() {
        return "chemistry";
    }

    public String getRecipeName() {
        return "Chemical Plant";
    }

    public String getGuiTexture() {
        return "hbm:textures/gui/nei/gui_nei_chemplant.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("chemistry") && this.getClass() == ChemplantRecipeHandler.class) {
            for (ChemplantRecipes.ChemRecipe recipe : ChemplantRecipes.recipes) {
                this.arecipes.add(new RecipeSet(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        block0: for (ChemplantRecipes.ChemRecipe recipe : ChemplantRecipes.recipes) {
            for (ItemStack itemStack : recipe.outputs) {
                if (itemStack == null || !NEIServerUtils.areStacksSameTypeCrafting((ItemStack)result, (ItemStack)itemStack)) continue;
                this.arecipes.add(new RecipeSet(recipe));
                continue block0;
            }
            for (FluidStack fluidStack : recipe.outputFluids) {
                ItemStack drop;
                if (fluidStack == null || !this.compareFluidStacks(result, drop = ItemFluidIcon.make(fluidStack.type, fluidStack.fill))) continue;
                this.arecipes.add(new RecipeSet(recipe));
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("chemistry") && this.getClass() == ChemplantRecipeHandler.class) {
            this.loadCraftingRecipes("chemistry", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (ChemplantRecipes.ChemRecipe recipe : ChemplantRecipes.recipes) {
            for (RecipesCommon.AStack aStack : recipe.inputs) {
                if (aStack == null) continue;
                List<ItemStack> stacks = aStack.extractForNEI();
                for (ItemStack stack : stacks) {
                    if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)stack)) continue;
                    this.arecipes.add(new RecipeSet(recipe));
                    continue block0;
                }
            }
            for (FluidStack fluidStack : recipe.inputFluids) {
                ItemStack drop;
                if (fluidStack == null || !this.compareFluidStacks(ingredient, drop = ItemFluidIcon.make(fluidStack.type, fluidStack.fill))) continue;
                this.arecipes.add(new RecipeSet(recipe));
                continue block0;
            }
        }
    }

    private boolean compareFluidStacks(ItemStack sta1, ItemStack sta2) {
        return sta1.func_77973_b() == sta2.func_77973_b() && sta1.func_77960_j() == sta2.func_77960_j();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public void loadTransferRects() {
        this.transferRectsGui = new LinkedList();
        this.guiGui = new LinkedList();
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 23, 54, 18), "chemistry", new Object[0]));
        this.transferRectsGui.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(38, 71, 86, 34), "chemistry", new Object[0]));
        this.guiGui.add(GUIMachineChemplant.class);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis((List)this.getRecipeTransferRectGuis(), (List)this.transferRects);
        TemplateRecipeHandler.RecipeTransferRectHandler.registerRectsToGuis(this.guiGui, this.transferRectsGui);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(3, 6, 0, 86, 16, 52, 480, 7);
        this.drawProgressBar(65, 23, 16, 86, 54, 18, 48, 0);
    }

    public TemplateRecipeHandler newInstance() {
        return super.newInstance();
    }

    public class RecipeSet
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack[] itemIn;
        PositionedStack[] fluidIn;
        PositionedStack[] itemOut;
        PositionedStack[] fluidOut;
        PositionedStack template;

        public RecipeSet(ChemplantRecipes.ChemRecipe recipe) {
            Object out;
            ItemStack drop;
            Object in;
            int i;
            super((TemplateRecipeHandler)ChemplantRecipeHandler.this);
            this.itemIn = new PositionedStack[4];
            this.fluidIn = new PositionedStack[2];
            this.itemOut = new PositionedStack[4];
            this.fluidOut = new PositionedStack[2];
            for (i = 0; i < recipe.inputs.length; ++i) {
                in = recipe.inputs[i];
                if (in == null) continue;
                this.itemIn[i] = new PositionedStack(((RecipesCommon.AStack)in).extractForNEI(), 30 + i % 2 * 18, 24 + i / 2 * 18);
            }
            for (i = 0; i < recipe.inputFluids.length; ++i) {
                in = recipe.inputFluids[i];
                if (in == null) continue;
                drop = ItemFluidIcon.make((FluidStack)in);
                this.fluidIn[i] = new PositionedStack((Object)drop, 30 + i % 2 * 18, 6);
            }
            for (i = 0; i < recipe.outputs.length; ++i) {
                out = recipe.outputs[i];
                if (out == null) continue;
                this.itemOut[i] = new PositionedStack(out, 120 + i % 2 * 18, 24 + i / 2 * 18);
            }
            for (i = 0; i < recipe.outputFluids.length; ++i) {
                out = recipe.outputFluids[i];
                if (out == null) continue;
                drop = ItemFluidIcon.make((FluidStack)out);
                this.fluidOut[i] = new PositionedStack((Object)drop, 120 + i % 2 * 18, 6);
            }
            this.template = new PositionedStack((Object)new ItemStack(ModItems.chemistry_template, 1, recipe.getId()), 84, 6);
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            for (PositionedStack stack : this.itemIn) {
                if (stack == null) continue;
                stacks.add(stack);
            }
            for (PositionedStack stack : this.fluidIn) {
                if (stack == null) continue;
                stacks.add(stack);
            }
            stacks.add(this.template);
            return this.getCycledIngredients(ChemplantRecipeHandler.this.cycleticks / 20, stacks);
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            for (PositionedStack stack : this.itemOut) {
                if (stack == null) continue;
                stacks.add(stack);
            }
            for (PositionedStack stack : this.fluidOut) {
                if (stack == null) continue;
                stacks.add(stack);
            }
            stacks.add(this.template);
            return stacks;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

