/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.GeneralConfig;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import com.hbm.items.ItemEnums;
import com.hbm.items.ItemGenericPart;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ChemicalPlantRecipes
extends GenericRecipes<GenericRecipe> {
    public static final ChemicalPlantRecipes INSTANCE = new ChemicalPlantRecipes();

    @Override
    public int inputItemLimit() {
        return 3;
    }

    @Override
    public int inputFluidLimit() {
        return 3;
    }

    @Override
    public int outputItemLimit() {
        return 3;
    }

    @Override
    public int outputFluidLimit() {
        return 3;
    }

    @Override
    public String getFileName() {
        return "hbmChemicalPlant.json";
    }

    @Override
    public GenericRecipe instantiateRecipe(String name) {
        return new GenericRecipe(name);
    }

    @Override
    public void registerDefaults() {
        FluidStack[] fluidStackArray;
        this.register(new GenericRecipe("chem.hydrogen").setupNamed(20, 400L).setIcon(ModItems.gas_full, Fluids.HYDROGEN.getID()).inputItems(new RecipesCommon.OreDictStack(OreDictManager.COAL.gem(), 1)).inputFluids(new FluidStack(Fluids.WATER, 8000)).outputFluids(new FluidStack(Fluids.HYDROGEN, 500)));
        this.register(new GenericRecipe("chem.hydrogencoke").setupNamed(20, 400L).setIcon(ModItems.gas_full, Fluids.HYDROGEN.getID()).inputItems(new RecipesCommon.OreDictStack(OreDictManager.ANY_COKE.gem(), 1)).inputFluids(new FluidStack(Fluids.WATER, 8000)).outputFluids(new FluidStack(Fluids.HYDROGEN, 500)));
        this.register(new GenericRecipe("chem.oxygen").setupNamed(20, 400L).setIcon(ModItems.gas_full, Fluids.OXYGEN.getID()).inputFluids(new FluidStack(Fluids.AIR, 8000)).outputFluids(new FluidStack(Fluids.OXYGEN, 500)));
        this.register(new GenericRecipe("chem.xenon").setupNamed(300, 1000L).setIcon(ModItems.gas_full, Fluids.XENON.getID()).inputFluids(new FluidStack(Fluids.AIR, 16000)).outputFluids(new FluidStack(Fluids.XENON, 50)));
        this.register(new GenericRecipe("chem.xenonoxy").setupNamed(20, 1000L).setIcon(ModItems.gas_full, Fluids.XENON.getID()).inputFluids(new FluidStack(Fluids.AIR, 8000), new FluidStack(Fluids.OXYGEN, 250)).outputFluids(new FluidStack(Fluids.XENON, 50)));
        this.register(new GenericRecipe("chem.helium3").setupNamed(200, 2000L).setIcon(ModItems.gas_full, Fluids.HELIUM3.getID()).inputItems(new RecipesCommon.ComparableStack(ModBlocks.moon_turf, 8)).outputFluids(new FluidStack(Fluids.HELIUM3, 1000)));
        this.register(new GenericRecipe("chem.co2").setup(60, 100L).inputFluids(new FluidStack(Fluids.GAS, 1000)).outputFluids(new FluidStack(Fluids.CARBONDIOXIDE, 1000)));
        this.register(new GenericRecipe("chem.perfluoromethyl").setup(20, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.F.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 1000), new FluidStack(Fluids.UNSATURATEDS, 500)).outputFluids(new FluidStack(Fluids.PERFLUOROMETHYL, 1000)));
        this.register(new GenericRecipe("chem.cccentrifuge").setup(200, 100L).inputFluids(new FluidStack(Fluids.CHLOROCALCITE_CLEANED, 500), new FluidStack(Fluids.SULFURIC_ACID, 8000)).outputFluids(new FluidStack(Fluids.POTASSIUM_CHLORIDE, 250), new FluidStack(Fluids.CALCIUM_CHLORIDE, 250)));
        this.register(new GenericRecipe("chem.ethanol").setupNamed(50, 100L).setIcon(ModItems.canister_full, Fluids.ETHANOL.getID()).inputItems(new RecipesCommon.ComparableStack(Items.field_151102_aT, 10)).outputFluids(new FluidStack(Fluids.ETHANOL, 1000)));
        this.register(new GenericRecipe("chem.biogas").setupNamed(60, 100L).setIcon(ModItems.gas_full, Fluids.BIOGAS.getID()).inputItems(new RecipesCommon.ComparableStack(ModItems.biomass, 16)).inputFluids(new FluidStack(Fluids.AIR, 4000)).outputFluids(new FluidStack(Fluids.BIOGAS, 2000)));
        this.register(new GenericRecipe("chem.biofuel").setupNamed(60, 100L).setIcon(ModItems.canister_full, Fluids.BIOFUEL.getID()).inputFluids(new FluidStack(Fluids.BIOGAS, 1500), new FluidStack(Fluids.ETHANOL, 250)).outputFluids(new FluidStack(Fluids.BIOFUEL, 1000)));
        this.register(new GenericRecipe("chem.reoil").setupNamed(40, 100L).setIcon(ModItems.canister_full, Fluids.RECLAIMED.getID()).inputFluids(new FluidStack(Fluids.SMEAR, 1000)).outputFluids(new FluidStack(Fluids.RECLAIMED, 800)));
        this.register(new GenericRecipe("chem.gasoline").setupNamed(40, 100L).setIcon(ModItems.canister_full, Fluids.GASOLINE.getID()).inputFluids(new FluidStack(Fluids.NAPHTHA, 1000)).outputFluids(new FluidStack(Fluids.GASOLINE, 800)));
        this.register(new GenericRecipe("chem.tarsand").setupNamed(200, 100L).setIcon(ModBlocks.ore_oil_sand).inputItems(new RecipesCommon.ComparableStack(ModBlocks.ore_oil_sand, 16), new RecipesCommon.OreDictStack(OreDictManager.ANY_TAR.any(), 1)).outputItems(new ItemStack((Block)Blocks.field_150354_m, 16)).outputFluids(new FluidStack(Fluids.BITUMEN, 1000)));
        this.register(new GenericRecipe("chem.tel").setup(40, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.ANY_TAR.any()), new RecipesCommon.OreDictStack(OreDictManager.PB.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 100), new FluidStack(Fluids.STEAM, 1000)).outputItems(OreDictManager.DictFrame.fromOne(ModItems.fuel_additive, (Enum)ItemEnums.EnumFuelAdditive.ANTIKNOCK)));
        this.register(new GenericRecipe("chem.deicer").setup(40, 100L).inputFluids(new FluidStack(Fluids.GAS, 100), new FluidStack(Fluids.HYDROGEN, 50)).outputItems(OreDictManager.DictFrame.fromOne(ModItems.fuel_additive, (Enum)ItemEnums.EnumFuelAdditive.DEICER)));
        this.register(new GenericRecipe("chem.concrete").setup(100, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 1), new RecipesCommon.ComparableStack(Blocks.field_150351_n, 8), new RecipesCommon.OreDictStack("sand", 8)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputItems(new ItemStack(ModBlocks.concrete_smooth, 16)));
        this.register(new GenericRecipe("chem.concreteasbestos").setup(100, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 4), new RecipesCommon.OreDictStack(OreDictManager.ASBESTOS.ingot(), GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry ? 1 : 4), new RecipesCommon.OreDictStack("sand", 8)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputItems(new ItemStack(ModBlocks.concrete_asbestos, 16)));
        this.register(new GenericRecipe("chem.ducrete").setup(150, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_cement, 4), new RecipesCommon.OreDictStack(OreDictManager.FERRO.ingot()), new RecipesCommon.OreDictStack("sand", 8)).inputFluids(new FluidStack(Fluids.WATER, 2000)).outputItems(new ItemStack(ModBlocks.ducrete_smooth, 8)));
        this.register(new GenericRecipe("chem.asphalt").setup(100, 100L).inputItems(new RecipesCommon.ComparableStack(Blocks.field_150351_n, 2), new RecipesCommon.OreDictStack("sand", 6)).inputFluids(new FluidStack(Fluids.BITUMEN, 1000)).outputItems(new ItemStack(ModBlocks.asphalt, 16)));
        GenericRecipe genericRecipe = new GenericRecipe("chem.desh").setup(100, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_desh_mix));
        if (GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry) {
            FluidStack[] fluidStackArray2 = new FluidStack[1];
            fluidStackArray = fluidStackArray2;
            fluidStackArray2[0] = new FluidStack(Fluids.LIGHTOIL, 200);
        } else {
            FluidStack[] fluidStackArray3 = new FluidStack[2];
            fluidStackArray3[0] = new FluidStack(Fluids.LIGHTOIL, 200);
            fluidStackArray = fluidStackArray3;
            fluidStackArray3[1] = new FluidStack(Fluids.MERCURY, 200);
        }
        this.register(genericRecipe.inputFluids(fluidStackArray).outputItems(new ItemStack(ModItems.ingot_desh)));
        this.register(new GenericRecipe("chem.polymer").setup(100, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.COAL.dust(), 2), new RecipesCommon.OreDictStack(OreDictManager.F.dust())).inputFluids(new FluidStack(Fluids.PETROLEUM, 500, GeneralConfig.enable528 ? 1 : 0)).outputItems(new ItemStack(ModItems.ingot_polymer)));
        this.register(new GenericRecipe("chem.bakelite").setup(100, 100L).inputFluids(new FluidStack(Fluids.AROMATICS, 500, GeneralConfig.enable528 ? 1 : 0), new FluidStack(Fluids.PETROLEUM, 500, GeneralConfig.enable528 ? 1 : 0)).outputItems(new ItemStack(ModItems.ingot_bakelite)));
        this.register(new GenericRecipe("chem.rubber").setup(100, 200L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.S.dust())).inputFluids(new FluidStack(Fluids.UNSATURATEDS, 500, GeneralConfig.enable528 ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_rubber)));
        this.register(new GenericRecipe("chem.hardplastic").setup(100, 1000L).inputFluids(new FluidStack(Fluids.XYLENE, 500, GeneralConfig.enable528 ? 2 : 0), new FluidStack(Fluids.PHOSGENE, 500, GeneralConfig.enable528 ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_pc)));
        this.register(new GenericRecipe("chem.pvc").setup(100, 1000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.CD.dust())).inputFluids(new FluidStack(Fluids.UNSATURATEDS, 250, GeneralConfig.enable528 ? 2 : 0), new FluidStack(Fluids.CHLORINE, 250, GeneralConfig.enable528 ? 2 : 0)).outputItems(new ItemStack(ModItems.ingot_pvc, 2)));
        this.register(new GenericRecipe("chem.kevlar").setup(60, 300L).inputFluids(new FluidStack(Fluids.AROMATICS, 200), new FluidStack(Fluids.NITRIC_ACID, 100), new FluidStack(GeneralConfig.enable528 ? Fluids.PHOSGENE : Fluids.CHLORINE, 100)).outputItems(new ItemStack(ModItems.plate_kevlar, 4)));
        this.register(new GenericRecipe("chem.meth").setup(60, 300L).inputItems(new RecipesCommon.ComparableStack(Items.field_151015_O), new RecipesCommon.ComparableStack(Items.field_151100_aR, 2, 3)).inputFluids(new FluidStack(Fluids.LUBRICANT, 400), new FluidStack(Fluids.PEROXIDE, 500)).outputItems(new ItemStack(ModItems.chocolate, 4)));
        this.register(new GenericRecipe("chem.epearl").setup(100, 300L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust(), 1)).inputFluids(new FluidStack(Fluids.XPJUICE, 500)).outputFluids(new FluidStack(Fluids.ENDERJUICE, 100)));
        this.register(new GenericRecipe("chem.meatprocessing").setupNamed(200, 200L).setIcon(ModItems.glyphid_meat).inputItems(new RecipesCommon.OreDictStack("glyphidMeat", 3)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputItems(new ItemStack(ModItems.sulfur, 4), new ItemStack(ModItems.niter, 3)).outputFluids(new FluidStack(Fluids.SALIENT, 250)));
        this.register(new GenericRecipe("chem.rustysteel").setup(40, 100L).inputItems(new RecipesCommon.ComparableStack(ModBlocks.deco_steel, 8)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputItems(new ItemStack(ModBlocks.deco_rusty_steel, 8)));
        this.register(new GenericRecipe("chem.peroxide").setup(50, 100L).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.PEROXIDE, 1000)));
        this.register(new GenericRecipe("chem.sulfuricacid").setup(50, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.S.dust())).inputFluids(new FluidStack(Fluids.PEROXIDE, 1000), new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.SULFURIC_ACID, 2000)));
        this.register(new GenericRecipe("chem.nitricacid").setup(50, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.SULFURIC_ACID, 500)).outputFluids(new FluidStack(Fluids.NITRIC_ACID, 1000)));
        this.register(new GenericRecipe("chem.birkeland").setupNamed(200, 5000L).inputFluids(new FluidStack(Fluids.AIR, 8000), new FluidStack(Fluids.WATER, 2000)).outputFluids(new FluidStack(Fluids.NITRIC_ACID, 1000)));
        this.register(new GenericRecipe("chem.schrabidic").setup(100, 5000L).inputItems(new RecipesCommon.ComparableStack(ModItems.pellet_charged)).inputFluids(new FluidStack(Fluids.SAS3, 8000), new FluidStack(Fluids.PEROXIDE, 6000)).outputFluids(new FluidStack(Fluids.SCHRABIDIC, 16000)));
        this.register(new GenericRecipe("chem.schrabidate").setup(150, 5000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.IRON.dust())).inputFluids(new FluidStack(Fluids.SCHRABIDIC, 250)).outputItems(new ItemStack(ModItems.powder_schrabidate)));
        this.register(new GenericRecipe("chem.coltancleaning").setup(60, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.COLTAN.dust(), 2), new RecipesCommon.OreDictStack(OreDictManager.COAL.dust())).inputFluids(new FluidStack(Fluids.PEROXIDE, 250), new FluidStack(Fluids.HYDROGEN, 500)).outputItems(new ItemStack(ModItems.powder_coltan), new ItemStack(ModItems.powder_niobium), new ItemStack(ModItems.dust)).outputFluids(new FluidStack(Fluids.WATER, 500)));
        this.register(new GenericRecipe("chem.coltanpain").setup(120, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_coltan), new RecipesCommon.OreDictStack(OreDictManager.F.dust())).inputFluids(new FluidStack(Fluids.GAS, 1000), new FluidStack(Fluids.OXYGEN, 500)).outputFluids(new FluidStack(Fluids.PAIN, 1000)));
        this.register(new GenericRecipe("chem.coltancrystal").setup(80, 100L).inputFluids(new FluidStack(Fluids.PAIN, 1000), new FluidStack(Fluids.PEROXIDE, 500)).outputItems(new ItemStack(ModItems.gem_tantalium), new ItemStack(ModItems.dust, 3)).outputFluids(new FluidStack(Fluids.WATER, 250)));
        this.register(new GenericRecipe("chem.cordite").setup(40, 100L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust(), 2), new RecipesCommon.ComparableStack(ModItems.powder_sawdust, 2)).inputFluids(GeneralConfig.enableLBSM && GeneralConfig.enableLBSMSimpleChemsitry ? new FluidStack(Fluids.HEATINGOIL, 200) : new FluidStack(Fluids.GAS, 200)).outputItems(new ItemStack(ModItems.cordite, 4)));
        this.register(new GenericRecipe("chem.rocketfuel").setup(200, 100L).inputItems(new RecipesCommon.ComparableStack(ModItems.solid_fuel, 2)).inputFluids(new FluidStack(Fluids.PETROLEUM, 200, GeneralConfig.enable528 ? 1 : 0), new FluidStack(Fluids.NITRIC_ACID, 100)).outputItems(new ItemStack(ModItems.rocket_fuel, 4)));
        this.register(new GenericRecipe("chem.dynamite").setup(50, 100L).inputItems(new RecipesCommon.ComparableStack(Items.field_151102_aT), new RecipesCommon.OreDictStack(OreDictManager.KNO.dust()), new RecipesCommon.OreDictStack("sand")).outputItems(new ItemStack(ModItems.ball_dynamite, 2)));
        this.register(new GenericRecipe("chem.tnt").setup(100, 1000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.AROMATICS, 500, GeneralConfig.enable528 ? 1 : 0)).outputItems(new ItemStack(ModItems.ball_tnt, 4)));
        this.register(new GenericRecipe("chem.tatb").setup(50, 5000L).inputItems(new RecipesCommon.ComparableStack(ModItems.ball_tnt)).inputFluids(new FluidStack(Fluids.SOURGAS, 200, 1), new FluidStack(Fluids.NITRIC_ACID, 10)).outputItems(new ItemStack(ModItems.ball_tatb)));
        this.register(new GenericRecipe("chem.c4").setup(100, 1000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())).inputFluids(new FluidStack(Fluids.UNSATURATEDS, 500, GeneralConfig.enable528 ? 1 : 0)).outputItems(new ItemStack(ModItems.ingot_c4, 4)));
        this.register(new GenericRecipe("chem.shellchlorine").setup(100, 1000L).inputItems(new RecipesCommon.ComparableStack(ModItems.ammo_arty, 1, 0), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 1)).inputFluids(new FluidStack(Fluids.CHLORINE, 4000)).outputItems(new ItemStack(ModItems.ammo_arty, 1, 9)));
        this.register(new GenericRecipe("chem.shellphosgene").setup(100, 1000L).inputItems(new RecipesCommon.ComparableStack(ModItems.ammo_arty, 1, 0), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 1)).inputFluids(new FluidStack(Fluids.PHOSGENE, 4000)).outputItems(new ItemStack(ModItems.ammo_arty, 1, 10)));
        this.register(new GenericRecipe("chem.shellmustard").setup(100, 1000L).inputItems(new RecipesCommon.ComparableStack(ModItems.ammo_arty, 1, 0), new RecipesCommon.OreDictStack(OreDictManager.ANY_PLASTIC.ingot(), 1)).inputFluids(new FluidStack(Fluids.MUSTARDGAS, 4000)).outputItems(new ItemStack(ModItems.ammo_arty, 1, 11)));
        this.register(new GenericRecipe("chem.laminate").setup(20, 100L).inputFluids(new FluidStack(Fluids.XYLENE, 50), new FluidStack(Fluids.PHOSGENE, 50)).inputItems(new RecipesCommon.OreDictStack("blockGlass"), new RecipesCommon.OreDictStack(OreDictManager.STEEL.bolt(), 4)).outputItems(new ItemStack(ModBlocks.reinforced_laminate)));
        this.register(new GenericRecipe("chem.polarized").setup(100, 500L).inputFluids(new FluidStack(Fluids.PETROLEUM, 1000)).inputItems(new RecipesCommon.OreDictStack("paneGlass")).outputItems(OreDictManager.DictFrame.fromOne(ModItems.part_generic, (Enum)ItemGenericPart.EnumPartType.GLASS_POLARIZED, 16)));
        this.register(new GenericRecipe("chem.yellowcake").setup(250, 500L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.U.billet(), 2), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)).inputFluids(new FluidStack(Fluids.PEROXIDE, 500)).outputItems(new ItemStack(ModItems.powder_yellowcake)));
        this.register(new GenericRecipe("chem.uf6").setup(100, 500L).setIcon(ModItems.fluid_icon, Fluids.UF6.getID()).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_yellowcake), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 4)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputItems(new ItemStack(ModItems.sulfur, 2)).outputFluids(new FluidStack(Fluids.UF6, 1200)));
        this.register(new GenericRecipe("chem.puf6").setup(200, 500L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.PU.dust()), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 3)).inputFluids(new FluidStack(Fluids.WATER, 1000)).outputFluids(new FluidStack(Fluids.PUF6, 900)));
        this.register(new GenericRecipe("chem.sas3").setup(200, 5000L).inputItems(new RecipesCommon.OreDictStack(OreDictManager.SA326.dust()), new RecipesCommon.OreDictStack(OreDictManager.S.dust(), 2)).inputFluids(new FluidStack(Fluids.PEROXIDE, 2000)).outputFluids(new FluidStack(Fluids.SAS3, 1000)));
        this.register(new GenericRecipe("chem.balefire").setup(100, 10000L).setIcon(ModItems.fluid_icon, Fluids.BALEFIRE.getID()).inputItems(new RecipesCommon.ComparableStack(ModItems.egg_balefire_shard)).inputFluids(new FluidStack(Fluids.KEROSENE, 6000)).outputItems(new ItemStack(ModItems.powder_balefire)).outputFluids(new FluidStack(Fluids.BALEFIRE, 8000)));
        this.register(new GenericRecipe("chem.thoriumsalt").setup(100, 10000L).setIcon(ModItems.fluid_icon, Fluids.THORIUM_SALT.getID()).inputFluids(new FluidStack(Fluids.THORIUM_SALT_DEPLETED, 16000)).inputItems(new RecipesCommon.OreDictStack(OreDictManager.TH232.nugget(), 2)).outputFluids(new FluidStack(Fluids.THORIUM_SALT, 16000)).outputItems(new GenericRecipes.ChanceOutput(new ItemStack(ModItems.nugget_u233, 1), 0.5f), new GenericRecipes.ChanceOutput(new ItemStack(ModItems.nuclear_waste_tiny, 1), 0.25f)));
        this.register(new GenericRecipe("chem.vitliquid").setup(100, 1000L).inputItems(new RecipesCommon.ComparableStack(ModBlocks.sand_lead)).inputFluids(new FluidStack(Fluids.WASTEFLUID, 1000)).outputItems(new ItemStack(ModItems.nuclear_waste_vitrified)));
        this.register(new GenericRecipe("chem.vitgaseous").setup(100, 1000L).inputItems(new RecipesCommon.ComparableStack(ModBlocks.sand_lead)).inputFluids(new FluidStack(Fluids.WASTEGAS, 1000)).outputItems(new ItemStack(ModItems.nuclear_waste_vitrified)));
        this.register(new GenericRecipe("chem.vitsolid").setup(300, 1000L).inputItems(new RecipesCommon.ComparableStack(ModBlocks.sand_lead), new RecipesCommon.ComparableStack(ModItems.nuclear_waste, 4)).outputItems(new ItemStack(ModItems.nuclear_waste_vitrified, 4)));
        this.register(new GenericRecipe("chem.osmiridiumdeath").setup(240, 1000L).inputItems(new RecipesCommon.ComparableStack(ModItems.powder_paleogenite), new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 8), new RecipesCommon.ComparableStack(ModItems.nugget_bismuth, 4)).inputFluids(new FluidStack(Fluids.PEROXIDE, 1000, 5)).outputFluids(new FluidStack(Fluids.DEATH, 1000, 0)));
    }

    /*
     * Could not resolve type clashes
     */
    public static HashMap getRecipes() {
        HashMap<Object[], Object[]> recipes = new HashMap<Object[], Object[]>();
        for (GenericRecipe recipe : ChemicalPlantRecipes.INSTANCE.recipeOrderedList) {
            ArrayList<Object> input = new ArrayList<Object>();
            if (recipe.inputItem != null) {
                for (Object stack : recipe.inputItem) {
                    input.add(stack);
                }
            }
            if (recipe.inputFluid != null) {
                for (Object stack : recipe.inputFluid) {
                    input.add(ItemFluidIcon.make((FluidStack)stack));
                }
            }
            ArrayList<Object> output = new ArrayList<Object>();
            if (recipe.outputItem != null) {
                for (Object stack : recipe.outputItem) {
                    output.add(stack.getAllPossibilities());
                }
            }
            if (recipe.outputFluid != null) {
                for (Object stack : recipe.outputFluid) {
                    output.add(ItemFluidIcon.make((FluidStack)stack));
                }
            }
            recipes.put(input.toArray(), output.toArray());
        }
        return recipes;
    }
}

