/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.imc.IMCCrystallizer;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemChemicalDye;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.items.machine.ItemScraps;
import com.hbm.items.special.ItemBedrockOre;
import com.hbm.items.special.ItemBedrockOreNew;
import com.hbm.items.special.ItemPlasticScrap;
import com.hbm.main.MainRegistry;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CrystallizerRecipes
extends SerializableRecipe {
    private static HashMap<Tuple.Pair<Object, FluidType>, CrystallizerRecipe> recipes = new HashMap();
    private static HashMap<Object, Integer> amounts = new HashMap();

    @Override
    public void registerDefaults() {
        ArrayList dustCinnabar;
        ArrayList dustWhitePhosphorus;
        FluidStack[] dyes;
        int baseTime = 600;
        int utilityTime = 100;
        int mixingTime = 20;
        FluidStack sulfur = new FluidStack(Fluids.SULFURIC_ACID, 500);
        CrystallizerRecipes.registerRecipe(OreDictManager.COAL.ore(), new CrystallizerRecipe(ModItems.crystal_coal, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.IRON.ore(), new CrystallizerRecipe(ModItems.crystal_iron, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.GOLD.ore(), new CrystallizerRecipe(ModItems.crystal_gold, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.REDSTONE.ore(), new CrystallizerRecipe(ModItems.crystal_redstone, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.LAPIS.ore(), new CrystallizerRecipe(ModItems.crystal_lapis, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.DIAMOND.ore(), new CrystallizerRecipe(ModItems.crystal_diamond, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.U.ore(), new CrystallizerRecipe(ModItems.crystal_uranium, 600).prod(0.05f), sulfur);
        for (String ore : OreDictManager.TH232.all(MaterialShapes.ONLY_ORE)) {
            CrystallizerRecipes.registerRecipe(ore, new CrystallizerRecipe(ModItems.crystal_thorium, 600).prod(0.05f), sulfur);
        }
        CrystallizerRecipes.registerRecipe(OreDictManager.PU.ore(), new CrystallizerRecipe(ModItems.crystal_plutonium, 600).prod(0.05f), sulfur);
        CrystallizerRecipes.registerRecipe(OreDictManager.TI.ore(), new CrystallizerRecipe(ModItems.crystal_titanium, 600).prod(0.05f), sulfur);
        CrystallizerRecipes.registerRecipe(OreDictManager.S.ore(), new CrystallizerRecipe(ModItems.crystal_sulfur, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.KNO.ore(), new CrystallizerRecipe(ModItems.crystal_niter, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.CU.ore(), new CrystallizerRecipe(ModItems.crystal_copper, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.W.ore(), new CrystallizerRecipe(ModItems.crystal_tungsten, 600).prod(0.05f), sulfur);
        CrystallizerRecipes.registerRecipe(OreDictManager.AL.ore(), new CrystallizerRecipe(ModItems.crystal_aluminium, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.F.ore(), new CrystallizerRecipe(ModItems.crystal_fluorite, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.BE.ore(), new CrystallizerRecipe(ModItems.crystal_beryllium, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.PB.ore(), new CrystallizerRecipe(ModItems.crystal_lead, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.SA326.ore(), new CrystallizerRecipe(ModItems.crystal_schrabidium, 600).prod(0.05f), sulfur);
        CrystallizerRecipes.registerRecipe(OreDictManager.LI.ore(), new CrystallizerRecipe(ModItems.crystal_lithium, 600).prod(0.05f), sulfur);
        CrystallizerRecipes.registerRecipe(OreDictManager.CO.ore(), new CrystallizerRecipe(ModItems.crystal_cobalt, 600).prod(0.05f), sulfur);
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.powder_calcium), new CrystallizerRecipe(new ItemStack(ModItems.powder_cement, 8), 100).prod(0.1f), new FluidStack(Fluids.REDMUD, 75));
        CrystallizerRecipes.registerRecipe(OreDictManager.MALACHITE.ingot(), new CrystallizerRecipe(ItemScraps.create(new Mats.MaterialStack(Mats.MAT_COPPER, MaterialShapes.INGOT.q(1))), 300).prod(0.1f), new FluidStack(Fluids.SULFURIC_ACID, 250));
        CrystallizerRecipes.registerRecipe("oreRareEarth", new CrystallizerRecipe(ModItems.crystal_rare, 600).prod(0.05f), sulfur);
        CrystallizerRecipes.registerRecipe("oreCinnabar", new CrystallizerRecipe(ModItems.crystal_cinnebar, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModBlocks.ore_nether_fire), new CrystallizerRecipe(ModItems.crystal_phosphorus, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModBlocks.ore_tikite), new CrystallizerRecipe(ModItems.crystal_trixite, 600).prod(0.05f), sulfur);
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModBlocks.gravel_diamond), new CrystallizerRecipe(ModItems.crystal_diamond, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe(OreDictManager.SRN.ingot(), new CrystallizerRecipe(ModItems.crystal_schraranium, 600).prod(0.05f));
        CrystallizerRecipes.registerRecipe("sand", new CrystallizerRecipe(ModItems.ingot_fiberglass, 100).prod(0.15f));
        CrystallizerRecipes.registerRecipe(OreDictManager.SI.ingot(), new CrystallizerRecipe(new ItemStack(Items.field_151128_bU, 2), 100).prod(0.1f), new FluidStack(Fluids.OXYGEN, 250));
        CrystallizerRecipes.registerRecipe(OreDictManager.REDSTONE.block(), new CrystallizerRecipe(ModItems.ingot_mercury, 600).prod(0.25f));
        CrystallizerRecipes.registerRecipe(OreDictManager.CINNABAR.crystal(), new CrystallizerRecipe(new ItemStack(ModItems.ingot_mercury, 3), 600).prod(0.25f));
        CrystallizerRecipes.registerRecipe(OreDictManager.BORAX.dust(), new CrystallizerRecipe(new ItemStack(ModItems.powder_boron_tiny, 3), 600).prod(0.25f), sulfur);
        CrystallizerRecipes.registerRecipe(OreDictManager.COAL.block(), new CrystallizerRecipe(ModBlocks.block_graphite, 600));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(Blocks.field_150347_e), new CrystallizerRecipe(ModBlocks.reinforced_stone, 100));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModBlocks.gravel_obsidian), new CrystallizerRecipe(ModBlocks.brick_obsidian, 100));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(Items.field_151078_bh), new CrystallizerRecipe(Items.field_151116_aA, 100).prod(0.25f));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.coal_infernal), new CrystallizerRecipe(ModItems.solid_fuel, 100));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModBlocks.stone_gneiss), new CrystallizerRecipe(ModItems.powder_lithium, 100).prod(0.25f));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(Items.field_151100_aR, 1, 15), new CrystallizerRecipe(new ItemStack(Items.field_151123_aH, 4), 20), new FluidStack(Fluids.SULFURIC_ACID, 250));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(Items.field_151103_aS), new CrystallizerRecipe(new ItemStack(Items.field_151123_aH, 16), 20), new FluidStack(Fluids.SULFURIC_ACID, 1000));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.plant_item, (Enum)ItemEnums.EnumPlantType.MUSTARDWILLOW)), new CrystallizerRecipe(new ItemStack(ModItems.powder_cadmium), 100).setReq(10), new FluidStack(Fluids.RADIOSOLVENT, 250));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.scrap_oil), new CrystallizerRecipe(new ItemStack(ModItems.nugget_arsenic), 100).prod(0.3f).setReq(16), new FluidStack(Fluids.RADIOSOLVENT, 100));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.powder_ash, (Enum)ItemEnums.EnumAshType.FULLERENE)), new CrystallizerRecipe(new ItemStack(ModItems.ingot_cft), 600).prod(0.1f).setReq(4), new FluidStack(Fluids.XYLENE, 1000));
        CrystallizerRecipes.registerRecipe(OreDictManager.DIAMOND.dust(), new CrystallizerRecipe(Items.field_151045_i, 100));
        CrystallizerRecipes.registerRecipe(OreDictManager.EMERALD.dust(), new CrystallizerRecipe(Items.field_151166_bC, 100));
        CrystallizerRecipes.registerRecipe(OreDictManager.LAPIS.dust(), new CrystallizerRecipe(new ItemStack(Items.field_151100_aR, 1, 4), 100));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.powder_semtex_mix), new CrystallizerRecipe(ModItems.ingot_semtex, 600));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.powder_desh_ready), new CrystallizerRecipe(ModItems.ingot_desh, 600));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.powder_meteorite), new CrystallizerRecipe(ModItems.fragment_meteorite, 100));
        CrystallizerRecipes.registerRecipe(OreDictManager.CD.dust(), new CrystallizerRecipe(ModItems.ingot_rubber, 100), new FluidStack(Fluids.FISHOIL, 250));
        CrystallizerRecipes.registerRecipe(OreDictManager.LATEX.ingot(), new CrystallizerRecipe(ModItems.ingot_rubber, 20).prod(0.15f), new FluidStack(Fluids.SOURGAS, 25));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.powder_sawdust), new CrystallizerRecipe(ModItems.cordite, 20).prod(0.25f), new FluidStack(Fluids.NITROGLYCERIN, 250));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.meteorite_sword_treated), new CrystallizerRecipe(ModItems.meteorite_sword_etched, 600));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.powder_impure_osmiridium), new CrystallizerRecipe(ModItems.crystal_osmiridium, 600), new FluidStack(Fluids.SCHRABIDIC, 1000));
        for (int i = 0; i < ItemPlasticScrap.ScrapType.values().length; ++i) {
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.scrap_plastic, 1, i), new CrystallizerRecipe(new ItemStack((Item)ModItems.circuit_star_piece, 1, i), 600));
        }
        FluidStack nitric = new FluidStack(Fluids.NITRIC_ACID, 500);
        FluidStack organic = new FluidStack(Fluids.SOLVENT, 500);
        FluidStack hiperf = new FluidStack(Fluids.RADIOSOLVENT, 500);
        int oreTime = 200;
        for (ItemBedrockOre.EnumBedrockOre ore : ItemBedrockOre.EnumBedrockOre.values()) {
            int i = ore.ordinal();
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.ore_centrifuged, 1, i), new CrystallizerRecipe(new ItemStack(ModItems.ore_cleaned, 1, i), oreTime));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.ore_separated, 1, i), new CrystallizerRecipe(new ItemStack(ModItems.ore_purified, 1, i), oreTime), sulfur);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.ore_separated, 1, i), new CrystallizerRecipe(new ItemStack(ModItems.ore_nitrated, 1, i), oreTime), nitric);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.ore_nitrocrystalline, 1, i), new CrystallizerRecipe(new ItemStack(ModItems.ore_deepcleaned, 1, i), oreTime), organic);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModItems.ore_nitrocrystalline, 1, i), new CrystallizerRecipe(new ItemStack(ModItems.ore_seared, 1, i), oreTime), hiperf);
        }
        int bedrock = 200;
        int washing = 100;
        for (ItemBedrockOreNew.BedrockOreType type : ItemBedrockOreNew.BedrockOreType.values()) {
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE_WASHED, type), washing), new FluidStack(Fluids.WATER, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE_ROASTED, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE_WASHED, type), washing), new FluidStack(Fluids.WATER, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SULFURIC, type), bedrock), new FluidStack(Fluids.SULFURIC_ACID, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_ROASTED, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SULFURIC, type), bedrock), new FluidStack(Fluids.SULFURIC_ACID, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SOLVENT, type), bedrock), new FluidStack(Fluids.SOLVENT, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_ROASTED, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SOLVENT, type), bedrock), new FluidStack(Fluids.SOLVENT, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSULFURIC, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SOLVENT, type), bedrock), new FluidStack(Fluids.SOLVENT, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_RAD, type), bedrock), new FluidStack(Fluids.RADIOSOLVENT, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_ROASTED, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_RAD, type), bedrock), new FluidStack(Fluids.RADIOSOLVENT, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSULFURIC, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_RAD, type), bedrock), new FluidStack(Fluids.RADIOSOLVENT, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSOLVENT, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_RAD, type), bedrock), new FluidStack(Fluids.RADIOSOLVENT, 250));
            int sulf = 4;
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_BYPRODUCT, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_WASHED, type), washing).setReq(sulf), new FluidStack(Fluids.WATER, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_ROASTED, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_WASHED, type), washing).setReq(sulf), new FluidStack(Fluids.WATER, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_ARC, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SULFURIC_WASHED, type), washing).setReq(sulf), new FluidStack(Fluids.WATER, 250));
            int solv = 4;
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_BYPRODUCT, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_WASHED, type), washing).setReq(solv), new FluidStack(Fluids.WATER, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_ROASTED, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_WASHED, type), washing).setReq(solv), new FluidStack(Fluids.WATER, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_ARC, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.SOLVENT_WASHED, type), washing).setReq(solv), new FluidStack(Fluids.WATER, 250));
            int rad = 4;
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_BYPRODUCT, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_WASHED, type), washing).setReq(rad), new FluidStack(Fluids.WATER, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_ROASTED, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_WASHED, type), washing).setReq(rad), new FluidStack(Fluids.WATER, 250));
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_ARC, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.RAD_WASHED, type), washing).setReq(rad), new FluidStack(Fluids.WATER, 250));
            FluidStack primary = new FluidStack(Fluids.HYDROGEN, 250);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, type), bedrock), primary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_ROASTED, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, type), bedrock), primary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SULFURIC, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, type), bedrock), primary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSULFURIC, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, type), bedrock), primary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SOLVENT, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, type), bedrock), primary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSOLVENT, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, type), bedrock), primary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_RAD, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, type), bedrock), primary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NORAD, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_FIRST, type), bedrock), primary);
            FluidStack secondary = new FluidStack(Fluids.CHLORINE, 250);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SECOND, type), bedrock), secondary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_ROASTED, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SECOND, type), bedrock), secondary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SULFURIC, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SECOND, type), bedrock), secondary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSULFURIC, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SECOND, type), bedrock), secondary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SOLVENT, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SECOND, type), bedrock), secondary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NOSOLVENT, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SECOND, type), bedrock), secondary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_RAD, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SECOND, type), bedrock), secondary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_NORAD, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.PRIMARY_SECOND, type), bedrock), secondary);
            CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.CRUMBS, type)), new CrystallizerRecipe(ItemBedrockOreNew.make(ItemBedrockOreNew.BedrockOreGrade.BASE, type), bedrock).setReq(64), new FluidStack(Fluids.NITRIC_ACID, 1000));
        }
        for (FluidStack dye : dyes = new FluidStack[]{new FluidStack(Fluids.WOODOIL, 100), new FluidStack(Fluids.FISHOIL, 100), new FluidStack(Fluids.LIGHTOIL, 100)}) {
            CrystallizerRecipes.registerRecipe(OreDictManager.COAL.dust(), new CrystallizerRecipe(OreDictManager.DictFrame.fromOne(ModItems.chemical_dye, (Enum)ItemChemicalDye.EnumChemDye.BLACK, 4), 20).prod(0.15f), dye);
            CrystallizerRecipes.registerRecipe(OreDictManager.TI.dust(), new CrystallizerRecipe(OreDictManager.DictFrame.fromOne(ModItems.chemical_dye, (Enum)ItemChemicalDye.EnumChemDye.WHITE, 4), 20).prod(0.15f), dye);
            CrystallizerRecipes.registerRecipe(OreDictManager.IRON.dust(), new CrystallizerRecipe(OreDictManager.DictFrame.fromOne(ModItems.chemical_dye, (Enum)ItemChemicalDye.EnumChemDye.RED, 4), 20).prod(0.15f), dye);
            CrystallizerRecipes.registerRecipe(OreDictManager.W.dust(), new CrystallizerRecipe(OreDictManager.DictFrame.fromOne(ModItems.chemical_dye, (Enum)ItemChemicalDye.EnumChemDye.YELLOW, 4), 20).prod(0.15f), dye);
            CrystallizerRecipes.registerRecipe(OreDictManager.CU.dust(), new CrystallizerRecipe(OreDictManager.DictFrame.fromOne(ModItems.chemical_dye, (Enum)ItemChemicalDye.EnumChemDye.GREEN, 4), 20).prod(0.15f), dye);
            CrystallizerRecipes.registerRecipe(OreDictManager.CO.dust(), new CrystallizerRecipe(OreDictManager.DictFrame.fromOne(ModItems.chemical_dye, (Enum)ItemChemicalDye.EnumChemDye.BLUE, 4), 20).prod(0.15f), dye);
        }
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE)), new CrystallizerRecipe(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.WAX), 20), new FluidStack(Fluids.CHLORINE, 250));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRACK)), new CrystallizerRecipe(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.WAX), 20), new FluidStack(Fluids.CHLORINE, 100));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.PARAFFIN)), new CrystallizerRecipe(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.WAX), 20), new FluidStack(Fluids.CHLORINE, 100));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.WAX)), new CrystallizerRecipe(new ItemStack(ModItems.pellet_charged), 200), new FluidStack(Fluids.IONGEL, 500));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.PARAFFIN)), new CrystallizerRecipe(new ItemStack(ModItems.pill_red), 200), new FluidStack(Fluids.ESTRADIOL, 250));
        CrystallizerRecipes.registerRecipe("sand", new CrystallizerRecipe(Blocks.field_150435_aG, 20), new FluidStack(Fluids.COLLOID, 1000));
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModBlocks.sand_quartz), new CrystallizerRecipe(new ItemStack(ModItems.ball_dynamite, 16), 20), new FluidStack(Fluids.NITROGLYCERIN, 1000));
        CrystallizerRecipes.registerRecipe(OreDictManager.NETHERQUARTZ.dust(), new CrystallizerRecipe(new ItemStack(ModItems.ball_dynamite, 4), 20), new FluidStack(Fluids.NITROGLYCERIN, 250));
        ArrayList quartz = OreDictionary.getOres((String)"crystalCertusQuartz");
        if (quartz != null && !quartz.isEmpty()) {
            ItemStack qItem = ((ItemStack)quartz.get(0)).func_77946_l();
            qItem.field_77994_a = 12;
            CrystallizerRecipes.registerRecipe("oreCertusQuartz", new CrystallizerRecipe(qItem, 600));
        }
        if ((dustWhitePhosphorus = OreDictionary.getOres((String)OreDictManager.P_WHITE.dust())) != null && !dustWhitePhosphorus.isEmpty()) {
            CrystallizerRecipes.registerRecipe(OreDictManager.P_WHITE.dust(), new CrystallizerRecipe(new ItemStack(ModItems.ingot_phosphorus), 100), new FluidStack(Fluids.AROMATICS, 50));
        }
        if ((dustCinnabar = OreDictionary.getOres((String)OreDictManager.CINNABAR.dust())) != null && !dustCinnabar.isEmpty()) {
            CrystallizerRecipes.registerRecipe(OreDictManager.CINNABAR.dust(), new CrystallizerRecipe(new ItemStack(ModItems.cinnebar), 100), new FluidStack(Fluids.PEROXIDE, 50));
        }
        CrystallizerRecipes.registerRecipe(new RecipesCommon.ComparableStack(ModBlocks.moon_turf, 16), new CrystallizerRecipe(new ItemStack(ModItems.chunk_ore, 1, ItemEnums.EnumChunkType.MOONSTONE.ordinal()), 1200));
        if (!IMCCrystallizer.buffer.isEmpty()) {
            recipes.putAll(IMCCrystallizer.buffer);
            MainRegistry.logger.info("Fetched " + IMCCrystallizer.buffer.size() + " IMC crystallizer recipes!");
            IMCCrystallizer.buffer.clear();
        }
    }

    public static CrystallizerRecipe getOutput(ItemStack stack, FluidType type) {
        String[] dictKeys;
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack.func_77973_b(), 1, stack.func_77960_j());
        Tuple.Pair<RecipesCommon.ComparableStack, FluidType> compKey = new Tuple.Pair<RecipesCommon.ComparableStack, FluidType>(comp, type);
        if (recipes.containsKey(compKey)) {
            return recipes.get(compKey);
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            Tuple.Pair<String, FluidType> dictKey = new Tuple.Pair<String, FluidType>(key, type);
            if (!recipes.containsKey(dictKey)) continue;
            return recipes.get(dictKey);
        }
        comp.meta = Short.MAX_VALUE;
        if (recipes.containsKey(compKey)) {
            return recipes.get(compKey);
        }
        return null;
    }

    public static int getAmount(ItemStack stack) {
        String[] dictKeys;
        if (stack == null || stack.func_77973_b() == null) {
            return 0;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack.func_77973_b(), 1, stack.func_77960_j());
        if (amounts.containsKey(comp)) {
            return amounts.get(comp);
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            if (!amounts.containsKey(key)) continue;
            return amounts.get(key);
        }
        comp.meta = Short.MAX_VALUE;
        if (amounts.containsKey(comp)) {
            return amounts.get(comp);
        }
        return 0;
    }

    public static HashMap getRecipes() {
        HashMap<Object[], ItemStack> recipes = new HashMap<Object[], ItemStack>();
        for (Map.Entry<Tuple.Pair<Object, FluidType>, CrystallizerRecipe> entry : CrystallizerRecipes.recipes.entrySet()) {
            RecipesCommon.AStack stack;
            CrystallizerRecipe recipe = entry.getValue();
            Tuple.Pair<Object, FluidType> key = entry.getKey();
            Object input = key.getKey();
            FluidType acid = key.getValue();
            if (input instanceof String) {
                stack = new RecipesCommon.OreDictStack((String)input, recipe.itemAmount);
                recipes.put(new Object[]{ItemFluidIcon.make(acid, recipe.acidAmount), stack}, recipe.output);
                continue;
            }
            stack = (RecipesCommon.ComparableStack)input;
            stack = (RecipesCommon.ComparableStack)stack.copy();
            stack.stacksize = recipe.itemAmount;
            if (stack.item == ModItems.scrap_plastic) continue;
            recipes.put(new Object[]{ItemFluidIcon.make(acid, recipe.acidAmount), stack}, recipe.output);
        }
        return recipes;
    }

    public static void registerRecipe(Object input, CrystallizerRecipe recipe) {
        CrystallizerRecipes.registerRecipe(input, recipe, new FluidStack(Fluids.PEROXIDE, 500));
    }

    public static void registerRecipe(Object input, CrystallizerRecipe recipe, FluidStack stack) {
        recipe.acidAmount = stack.fill;
        recipes.put(new Tuple.Pair<Object, FluidType>(input, stack.type), recipe);
        amounts.put(input, recipe.itemAmount);
    }

    @Override
    public String getFileName() {
        return "hbmCrystallizer.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        ItemStack output = CrystallizerRecipes.readItemStack(obj.get("output").getAsJsonArray());
        RecipesCommon.AStack input = CrystallizerRecipes.readAStack(obj.get("input").getAsJsonArray());
        FluidStack fluid = CrystallizerRecipes.readFluidStack(obj.get("fluid").getAsJsonArray());
        int duration = obj.get("duration").getAsInt();
        CrystallizerRecipe cRecipe = new CrystallizerRecipe(output, duration).setReq(input.stacksize);
        input.stacksize = 1;
        cRecipe.acidAmount = fluid.fill;
        if (input instanceof RecipesCommon.ComparableStack) {
            recipes.put(new Tuple.Pair<RecipesCommon.ComparableStack, FluidType>((RecipesCommon.ComparableStack)input, fluid.type), cRecipe);
        } else if (input instanceof RecipesCommon.OreDictStack) {
            recipes.put(new Tuple.Pair<String, FluidType>(((RecipesCommon.OreDictStack)input).name, fluid.type), cRecipe);
        }
        if (obj.has("productivity")) {
            cRecipe.prod(obj.get("productivity").getAsFloat());
        }
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        CrystallizerRecipe cRecipe = (CrystallizerRecipe)rec.getValue();
        Tuple.Pair pair = (Tuple.Pair)rec.getKey();
        RecipesCommon.AStack input = pair.getKey() instanceof String ? new RecipesCommon.OreDictStack((String)pair.getKey()) : ((RecipesCommon.ComparableStack)pair.getKey()).copy();
        input.stacksize = cRecipe.itemAmount;
        FluidStack fluid = new FluidStack((FluidType)pair.value, cRecipe.acidAmount);
        writer.name("duration").value((long)cRecipe.duration);
        writer.name("fluid");
        CrystallizerRecipes.writeFluidStack(fluid, writer);
        writer.name("input");
        CrystallizerRecipes.writeAStack(input, writer);
        writer.name("output");
        CrystallizerRecipes.writeItemStack(cRecipe.output, writer);
        writer.name("productivity").value((double)cRecipe.productivity);
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
        amounts.clear();
    }

    @Override
    public String getComment() {
        return "The acidizer also supports stack size requirements for input items, eg. the cadmium recipe requires 10 willow leaves.";
    }

    public static class CrystallizerRecipe {
        public int acidAmount;
        public int itemAmount = 1;
        public int duration;
        public float productivity = 0.0f;
        public ItemStack output;

        public CrystallizerRecipe(Block output, int duration) {
            this(new ItemStack(output), duration);
        }

        public CrystallizerRecipe(Item output, int duration) {
            this(new ItemStack(output), duration);
        }

        public CrystallizerRecipe setReq(int amount) {
            this.itemAmount = amount;
            return this;
        }

        public CrystallizerRecipe(ItemStack output, int duration) {
            this.output = output;
            this.duration = duration;
            this.acidAmount = 500;
        }

        public CrystallizerRecipe prod(float productivity) {
            this.productivity = productivity;
            return this;
        }
    }
}

