/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes.loader;

import com.hbm.inventory.FluidStack;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.BobMathUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class GenericRecipe {
    protected final String name;
    public RecipesCommon.AStack[] inputItem;
    public FluidStack[] inputFluid;
    public GenericRecipes.IOutput[] outputItem;
    public FluidStack[] outputFluid;
    public int duration;
    public long power;
    protected ItemStack icon;
    public boolean writeIcon = false;
    public boolean customLocalization = false;

    public GenericRecipe(String name) {
        this.name = name;
    }

    public GenericRecipe setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public GenericRecipe setPower(long power) {
        this.power = power;
        return this;
    }

    public GenericRecipe setup(int duration, long power) {
        return this.setDuration(duration).setPower(power);
    }

    public GenericRecipe setupNamed(int duration, long power) {
        return this.setDuration(duration).setPower(power).setNamed();
    }

    public GenericRecipe setIcon(ItemStack icon) {
        this.icon = icon;
        this.writeIcon = true;
        return this;
    }

    public GenericRecipe setIcon(Item item, int meta) {
        return this.setIcon(new ItemStack(item, 1, meta));
    }

    public GenericRecipe setIcon(Item item) {
        return this.setIcon(new ItemStack(item));
    }

    public GenericRecipe setIcon(Block block) {
        return this.setIcon(new ItemStack(block));
    }

    public GenericRecipe setNamed() {
        this.customLocalization = true;
        return this;
    }

    public GenericRecipe inputItems(RecipesCommon.AStack ... input) {
        this.inputItem = input;
        return this;
    }

    public GenericRecipe inputFluids(FluidStack ... input) {
        this.inputFluid = input;
        return this;
    }

    public GenericRecipe outputItems(GenericRecipes.IOutput ... output) {
        this.outputItem = output;
        return this;
    }

    public GenericRecipe outputFluids(FluidStack ... output) {
        this.outputFluid = output;
        return this;
    }

    public GenericRecipe outputItems(ItemStack ... output) {
        this.outputItem = new GenericRecipes.IOutput[output.length];
        for (int i = 0; i < this.outputItem.length; ++i) {
            this.outputItem[i] = new GenericRecipes.ChanceOutput(output[i]);
        }
        return this;
    }

    public ItemStack getIcon() {
        if (this.icon == null) {
            if (this.outputItem != null) {
                if (this.outputItem[0] instanceof GenericRecipes.ChanceOutput) {
                    this.icon = ((GenericRecipes.ChanceOutput)this.outputItem[0]).stack.func_77946_l();
                }
                if (this.outputItem[0] instanceof GenericRecipes.ChanceOutputMulti) {
                    this.icon = ((GenericRecipes.ChanceOutputMulti)this.outputItem[0]).pool.get((int)0).stack.func_77946_l();
                }
                return this.icon;
            }
            if (this.outputFluid != null) {
                this.icon = ItemFluidIcon.make(this.outputFluid[0]);
            }
        }
        if (this.icon == null) {
            this.icon = new ItemStack(ModItems.nothing);
        }
        return this.icon;
    }

    public String getInternalName() {
        return this.name;
    }

    public String getLocalizedName() {
        if (this.customLocalization) {
            return I18nUtil.resolveKey(this.name, new Object[0]);
        }
        return this.getIcon().func_82833_r();
    }

    public List<String> print() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(EnumChatFormatting.YELLOW + this.getLocalizedName());
        if (this.duration > 0) {
            list.add(EnumChatFormatting.RED + "Duration: " + (double)this.duration / 20.0 + "s");
        }
        if (this.power > 0L) {
            list.add(EnumChatFormatting.RED + "Consumption: " + BobMathUtil.getShortNumber(this.power) + "HE/t");
        }
        list.add(EnumChatFormatting.BOLD + "Input:");
        if (this.inputItem != null) {
            for (RecipesCommon.AStack aStack : this.inputItem) {
                ItemStack display = aStack.extractForCyclingDisplay(20);
                list.add("  " + EnumChatFormatting.GRAY + display.field_77994_a + "x " + display.func_82833_r());
            }
        }
        if (this.inputFluid != null) {
            for (FluidStack fluidStack : this.inputFluid) {
                list.add("  " + EnumChatFormatting.BLUE + fluidStack.fill + "mB " + fluidStack.type.getLocalizedName() + (fluidStack.pressure == 0 ? "" : " at " + EnumChatFormatting.RED + fluidStack.pressure + " PU"));
            }
        }
        list.add(EnumChatFormatting.BOLD + "Output:");
        if (this.outputItem != null) {
            for (GenericRecipes.IOutput iOutput : this.outputItem) {
                for (String line : iOutput.getLabel()) {
                    list.add("  " + line);
                }
            }
        }
        if (this.outputFluid != null) {
            for (FluidStack fluidStack : this.outputFluid) {
                list.add("  " + EnumChatFormatting.BLUE + fluidStack.fill + "mB " + fluidStack.type.getLocalizedName() + (fluidStack.pressure == 0 ? "" : " at " + EnumChatFormatting.RED + fluidStack.pressure + " PU"));
            }
        }
        return list;
    }

    public boolean matchesSearch(String substring) {
        return this.getLocalizedName().toLowerCase(Locale.US).contains(substring.toLowerCase(Locale.US));
    }
}

