/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import api.hbm.item.IDepthRockTool;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.HbmKeybinds;
import com.hbm.handler.ability.AvailableAbilities;
import com.hbm.handler.ability.IBaseAbility;
import com.hbm.handler.ability.IToolAreaAbility;
import com.hbm.handler.ability.IToolHarvestAbility;
import com.hbm.handler.ability.ToolPreset;
import com.hbm.inventory.gui.GUIScreenToolAbility;
import com.hbm.items.IItemControlReceiver;
import com.hbm.items.IKeybindReceiver;
import com.hbm.main.MainRegistry;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toclient.PlayerInformPacket;
import com.hbm.tileentity.IGUIProvider;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.world.BlockEvent;

public class ItemToolAbility
extends ItemTool
implements IDepthRockTool,
IGUIProvider,
IItemControlReceiver,
IKeybindReceiver {
    protected boolean isShears = false;
    protected EnumToolType toolType;
    protected EnumRarity rarity = EnumRarity.common;
    protected float damage;
    protected double movement;
    protected AvailableAbilities availableAbilities = new AvailableAbilities().addToolAbilities();
    protected boolean rockBreaker = false;
    public static int dropX;
    public static int dropY;
    public static int dropZ;
    private static Method blockCaptureDrops;

    public ItemToolAbility setShears() {
        this.isShears = true;
        return this;
    }

    public ItemToolAbility(float damage, double movement, Item.ToolMaterial material, EnumToolType type) {
        super(0.0f, material, type.blocks);
        this.damage = damage;
        this.movement = movement;
        this.toolType = type;
        if (type == EnumToolType.MINER) {
            this.setHarvestLevel("pickaxe", material.func_77996_d());
            this.setHarvestLevel("shovel", material.func_77996_d());
        } else {
            this.setHarvestLevel(type.toString().toLowerCase(Locale.US), material.func_77996_d());
        }
    }

    public ItemToolAbility addAbility(IBaseAbility ability, int level) {
        this.availableAbilities.addAbility(ability, level);
        return this;
    }

    public ItemToolAbility setDepthRockBreaker() {
        this.rockBreaker = true;
        return this;
    }

    public ItemToolAbility setRarity(EnumRarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity != EnumRarity.common ? this.rarity : super.func_77613_e(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase victim, EntityLivingBase attacker) {
        if (!attacker.field_70170_p.field_72995_K && attacker instanceof EntityPlayer && this.canOperate(stack)) {
            this.availableAbilities.getWeaponAbilities().forEach((ability, level) -> ability.onHit((int)level, attacker.field_70170_p, (EntityPlayer)attacker, (Entity)victim, (Item)this));
        }
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        Block block = world.func_147439_a(x, y, z);
        if (block == ModBlocks.stone_keyhole || block == ModBlocks.stone_keyhole_meta) {
            return false;
        }
        if (!world.field_72995_K && (this.canHarvestBlock(block, stack) || this.canShearBlock(block, stack, world, x, y, z)) && this.canOperate(stack)) {
            Configuration config = this.getConfiguration(stack);
            ToolPreset preset = config.getActivePreset();
            dropX = x;
            dropY = y;
            dropZ = z;
            preset.harvestAbility.preHarvestAll(preset.harvestAbilityLevel, world, player);
            boolean skipRef = preset.areaAbility.onDig(preset.areaAbilityLevel, world, x, y, z, player, this);
            if (!skipRef) {
                this.breakExtraBlock(world, x, y, z, player, x, y, z);
            }
            preset.harvestAbility.postHarvestAll(preset.harvestAbilityLevel, world, player);
            return true;
        }
        return false;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase player) {
        return super.func_150894_a(stack, world, block, x, y, z, player);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!this.canOperate(stack)) {
            return 1.0f;
        }
        if (this.toolType == null) {
            return super.getDigSpeed(stack, block, meta);
        }
        if (this.toolType.blocks.contains(block) || this.toolType.materials.contains(block.func_149688_o())) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean canOperate(ItemStack stack) {
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        if (!this.canOperate(stack)) {
            return false;
        }
        if (this.getConfiguration((ItemStack)stack).getActivePreset().harvestAbility == IToolHarvestAbility.SILK) {
            return true;
        }
        return this.getDigSpeed(stack, block, 0) > 1.0f;
    }

    @Override
    public boolean canBreakRock(World world, EntityPlayer player, ItemStack tool, Block block, int x, int y, int z) {
        return this.canOperate(tool) && this.rockBreaker;
    }

    public boolean canShearBlock(Block block, ItemStack stack, World world, int x, int y, int z) {
        return this.isShears(stack) && block instanceof IShearable && ((IShearable)block).isShearable(stack, (IBlockAccess)world, x, y, z);
    }

    public boolean isShears(ItemStack stack) {
        return this.isShears;
    }

    public Multimap func_111205_h() {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.damage, 0));
        multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.movement, 1));
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77948_v() || !this.getConfiguration(stack).getActivePreset().isNone();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.availableAbilities.addInformation(list);
        if (this.rockBreaker) {
            list.add("");
            list.add(EnumChatFormatting.RED + "Can break depth rock!");
        }
    }

    public void breakExtraBlock(World world, int x, int y, int z, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        ItemStack stack = player.func_70694_bm();
        if (stack == null) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!this.canHarvestBlock(block, stack) && !this.canShearBlock(block, stack, world, x, y, z) || block.func_149712_f(world, x, y, z) == -1.0f && block.func_149737_a((EntityPlayer)player, world, x, y, z) == 0.0f || block == ModBlocks.stone_keyhole) {
            return;
        }
        Block refBlock = world.func_147439_a(refX, refY, refZ);
        float refStrength = ForgeHooks.blockStrength((Block)refBlock, (EntityPlayer)player, (World)world, (int)refX, (int)refY, (int)refZ);
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) || refStrength / strength > 10.0f || refBlock.func_149737_a((EntityPlayer)player, world, refX, refY, refZ) < 0.0f) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        Configuration config = this.getConfiguration(stack);
        ToolPreset preset = config.getActivePreset();
        preset.harvestAbility.onHarvestBlock(preset.harvestAbilityLevel, world, x, y, z, (EntityPlayer)player, block, meta);
    }

    public static void shearBlock(World world, int x, int y, int z, Block block, EntityPlayer player) {
        IShearable target = (IShearable)block;
        ItemStack held = player.func_70694_bm();
        if (target.isShearable(held, (IBlockAccess)player.field_70170_p, x, y, z)) {
            ArrayList drops = target.onSheared(held, (IBlockAccess)player.field_70170_p, x, y, z, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)held));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)dropX + d, (double)dropY + d1, (double)dropZ + d2, stack);
                entityitem.field_145804_b = 10;
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            held.func_77972_a(1, (EntityLivingBase)player);
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
    }

    public static void standardDigPost(World world, int x, int y, int z, EntityPlayerMP player) {
        Block block = world.func_147439_a(x, y, z);
        int l = world.func_72805_g(x, y, z);
        world.func_72889_a((EntityPlayer)player, 2001, x, y, z, Block.func_149682_b((Block)block) + (world.func_72805_g(x, y, z) << 12));
        boolean removedByPlayer = false;
        if (player.field_71075_bZ.field_75098_d) {
            removedByPlayer = ItemToolAbility.removeBlock(world, x, y, z, false, player);
            player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            ItemStack itemstack = player.func_71045_bC();
            boolean canHarvest = block.canHarvestBlock((EntityPlayer)player, l);
            removedByPlayer = ItemToolAbility.removeBlock(world, x, y, z, canHarvest, player);
            if (itemstack != null) {
                itemstack.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
                if (itemstack.field_77994_a == 0) {
                    player.func_71028_bD();
                }
            }
            if (removedByPlayer && canHarvest) {
                try {
                    blockCaptureDrops.invoke((Object)block, true);
                    block.func_149636_a(world, (EntityPlayer)player, x, y, z, l);
                    List drops = (List)blockCaptureDrops.invoke((Object)block, false);
                    for (ItemStack stack : drops) {
                        block.func_149642_a(world, dropX, dropY, dropZ, stack);
                    }
                }
                catch (IllegalAccessException e) {
                    MainRegistry.logger.error("Failed to capture drops for block " + block, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    MainRegistry.logger.error("Failed to capture drops for block " + block, (Throwable)e);
                }
            }
        }
    }

    public static boolean removeBlock(World world, int x, int y, int z, boolean canHarvest, EntityPlayerMP player) {
        Block block = world.func_147439_a(x, y, z);
        int l = world.func_72805_g(x, y, z);
        block.func_149681_a(world, x, y, z, l, (EntityPlayer)player);
        boolean flag = block.removedByPlayer(world, (EntityPlayer)player, x, y, z, canHarvest);
        if (flag) {
            block.func_149664_b(world, x, y, z, l);
        }
        return flag;
    }

    public Configuration getConfiguration(ItemStack stack) {
        Configuration config = new Configuration();
        if (!(stack != null && stack.func_77942_o() && stack.field_77990_d.func_74764_b("ability") && stack.field_77990_d.func_74764_b("abilityPresets"))) {
            config.reset(this.availableAbilities);
            return config;
        }
        config.readFromNBT(stack.field_77990_d);
        config.restrictTo(this.availableAbilities);
        return config;
    }

    public void setConfiguration(ItemStack stack, Configuration config) {
        if (stack == null) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        config.writeToNBT(stack.field_77990_d);
    }

    @Override
    public void receiveControl(ItemStack stack, NBTTagCompound data) {
        Configuration config = new Configuration();
        config.readFromNBT(data);
        config.restrictTo(this.availableAbilities);
        this.setConfiguration(stack, config);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIScreenToolAbility(this.availableAbilities);
    }

    @Override
    public boolean canHandleKeybind(EntityPlayer player, ItemStack stack, HbmKeybinds.EnumKeybind keybind) {
        if (player.field_70170_p.field_72995_K) {
            return keybind == HbmKeybinds.EnumKeybind.ABILITY_ALT;
        }
        return keybind == HbmKeybinds.EnumKeybind.ABILITY_CYCLE;
    }

    @Override
    public void handleKeybind(EntityPlayer player, ItemStack stack, HbmKeybinds.EnumKeybind keybind, boolean state) {
        if (keybind == HbmKeybinds.EnumKeybind.ABILITY_CYCLE && state) {
            World world = player.field_70170_p;
            if (!this.canOperate(stack)) {
                return;
            }
            Configuration config = this.getConfiguration(stack);
            if (config.presets.size() < 2 || world.field_72995_K) {
                return;
            }
            config.currentPreset = player.func_70093_af() ? 0 : (config.currentPreset + 1) % config.presets.size();
            this.setConfiguration(stack, config);
            PacketDispatcher.wrapper.sendTo(new PlayerInformPacket((IChatComponent)config.getActivePreset().getMessage(), 11), (EntityPlayerMP)player);
            world.func_72956_a((Entity)player, "random.orb", 0.25f, config.getActivePreset().isNone() ? 0.75f : 1.25f);
        }
    }

    @Override
    public void handleKeybindClient(EntityPlayer player, ItemStack stack, HbmKeybinds.EnumKeybind keybind, boolean state) {
        if (state) {
            player.openGui((Object)MainRegistry.instance, 0, player.field_70170_p, 0, 0, 0);
        }
    }

    static {
        blockCaptureDrops = ReflectionHelper.findMethod(Block.class, null, (String[])new String[]{"captureDrops"}, (Class[])new Class[]{Boolean.TYPE});
    }

    public static class Configuration {
        public List<ToolPreset> presets;
        public int currentPreset;

        public Configuration() {
            this.presets = null;
            this.currentPreset = 0;
        }

        public Configuration(List<ToolPreset> presets, int currentPreset) {
            this.presets = presets;
            this.currentPreset = currentPreset;
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("ability", this.currentPreset);
            NBTTagList nbtPresets = new NBTTagList();
            for (ToolPreset preset : this.presets) {
                NBTTagCompound nbtPreset = new NBTTagCompound();
                preset.writeToNBT(nbtPreset);
                nbtPresets.func_74742_a((NBTBase)nbtPreset);
            }
            nbt.func_74782_a("abilityPresets", (NBTBase)nbtPresets);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.currentPreset = nbt.func_74762_e("ability");
            NBTTagList nbtPresets = nbt.func_150295_c("abilityPresets", 10);
            int numPresets = Math.min(nbtPresets.func_74745_c(), 99);
            this.presets = new ArrayList<ToolPreset>(numPresets);
            for (int i = 0; i < numPresets; ++i) {
                NBTTagCompound nbtPreset = nbtPresets.func_150305_b(i);
                ToolPreset preset = new ToolPreset();
                preset.readFromNBT(nbtPreset);
                this.presets.add(preset);
            }
            this.currentPreset = Math.max(0, Math.min(this.currentPreset, this.presets.size() - 1));
        }

        public void reset(AvailableAbilities availableAbilities) {
            this.currentPreset = 0;
            this.presets = new ArrayList<ToolPreset>(availableAbilities.size());
            this.presets.add(new ToolPreset());
            availableAbilities.getToolAreaAbilities().forEach((ability, level) -> {
                if (ability == IToolAreaAbility.NONE) {
                    return;
                }
                this.presets.add(new ToolPreset((IToolAreaAbility)ability, (int)level, IToolHarvestAbility.NONE, 0));
            });
            availableAbilities.getToolHarvestAbilities().forEach((ability, level) -> {
                if (ability == IToolHarvestAbility.NONE) {
                    return;
                }
                this.presets.add(new ToolPreset(IToolAreaAbility.NONE, 0, (IToolHarvestAbility)ability, (int)level));
            });
            this.presets.sort(Comparator.comparing(p -> p.harvestAbility).thenComparingInt(p -> p.harvestAbilityLevel).thenComparing(p -> p.areaAbility).thenComparingInt(p -> p.areaAbilityLevel));
        }

        public void restrictTo(AvailableAbilities availableAbilities) {
            for (ToolPreset preset : this.presets) {
                preset.restrictTo(availableAbilities);
            }
        }

        public ToolPreset getActivePreset() {
            return this.presets.get(this.currentPreset);
        }
    }

    public static enum EnumToolType {
        PICKAXE(Sets.newHashSet((Object[])new Material[]{Material.field_151573_f, Material.field_151574_g, Material.field_151576_e, Material.field_151592_s}), Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150334_T, Blocks.field_150333_U, Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150341_Y, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150365_q, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150432_aD, Blocks.field_150424_aL, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc})),
        AXE(Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_151585_k, Material.field_151582_l}), Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP})),
        SHOVEL(Sets.newHashSet((Object[])new Material[]{Material.field_151571_B, Material.field_151595_p, Material.field_151578_c, Material.field_151597_y, Material.field_151596_z}), Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh})),
        MINER(Sets.newHashSet((Object[])new Material[]{Material.field_151577_b, Material.field_151573_f, Material.field_151574_g, Material.field_151592_s, Material.field_151576_e, Material.field_151571_B, Material.field_151595_p, Material.field_151578_c, Material.field_151597_y, Material.field_151596_z}));

        public Set<Material> materials = new HashSet<Material>();
        public Set<Block> blocks = new HashSet<Block>();

        private EnumToolType(Set<Material> materials) {
            this.materials = materials;
        }

        private EnumToolType(Set<Material> materials, Set<Block> blocks) {
            this.materials = materials;
            this.blocks = blocks;
        }
    }
}

