/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.items.special.ItemLootCrate;
import com.hbm.main.MainRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ItemCustomMissilePart
extends Item {
    public PartType type;
    public PartSize top;
    public PartSize bottom;
    public Rarity rarity;
    public float health;
    private String title;
    private String author;
    private String witty;
    public static HashMap<Integer, ItemCustomMissilePart> parts = new HashMap();
    public Object[] attributes;

    public ItemCustomMissilePart() {
        this.func_77625_d(1);
        this.func_77637_a(MainRegistry.missileTab);
    }

    public ItemCustomMissilePart makeChip(float inaccuracy) {
        this.type = PartType.CHIP;
        this.top = PartSize.ANY;
        this.bottom = PartSize.ANY;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeWarhead(WarheadType type, float punch, float weight, PartSize size) {
        this.type = PartType.WARHEAD;
        this.top = PartSize.NONE;
        this.bottom = size;
        this.attributes = new Object[]{type, Float.valueOf(punch), Float.valueOf(weight)};
        this.func_111206_d("hbm:mp_warhead");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeFuselage(FuelType type, float fuel, PartSize top, PartSize bottom) {
        this.type = PartType.FUSELAGE;
        this.top = top;
        this.bottom = bottom;
        this.attributes = new Object[]{type, Float.valueOf(fuel)};
        this.func_111206_d("hbm:mp_fuselage");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeStability(float inaccuracy, PartSize size) {
        this.type = PartType.FINS;
        this.top = size;
        this.bottom = size;
        this.attributes = new Object[]{Float.valueOf(inaccuracy)};
        this.func_111206_d("hbm:mp_stability");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public ItemCustomMissilePart makeThruster(FuelType type, float consumption, float lift, PartSize size) {
        this.type = PartType.THRUSTER;
        this.top = size;
        this.bottom = PartSize.NONE;
        this.attributes = new Object[]{type, Float.valueOf(consumption), Float.valueOf(lift)};
        this.func_111206_d("hbm:mp_thruster");
        parts.put(((Object)((Object)this)).hashCode(), this);
        return this;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (this.title != null) {
            list.add(EnumChatFormatting.DARK_PURPLE + "\"" + this.title + "\"");
        }
        try {
            switch (this.type) {
                case CHIP: {
                    list.add(EnumChatFormatting.BOLD + "Inaccuracy: " + EnumChatFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case WARHEAD: {
                    list.add(EnumChatFormatting.BOLD + "Size: " + EnumChatFormatting.GRAY + this.getSize(this.bottom));
                    list.add(EnumChatFormatting.BOLD + "Type: " + EnumChatFormatting.GRAY + this.getWarhead((WarheadType)((Object)this.attributes[0])));
                    list.add(EnumChatFormatting.BOLD + "Strength: " + EnumChatFormatting.GRAY + (Float)this.attributes[1]);
                    list.add(EnumChatFormatting.BOLD + "Weight: " + EnumChatFormatting.GRAY + (Float)this.attributes[2] + "t");
                    break;
                }
                case FUSELAGE: {
                    list.add(EnumChatFormatting.BOLD + "Top size: " + EnumChatFormatting.GRAY + this.getSize(this.top));
                    list.add(EnumChatFormatting.BOLD + "Bottom size: " + EnumChatFormatting.GRAY + this.getSize(this.bottom));
                    list.add(EnumChatFormatting.BOLD + "Fuel type: " + EnumChatFormatting.GRAY + this.getFuel((FuelType)((Object)this.attributes[0])));
                    list.add(EnumChatFormatting.BOLD + "Fuel amount: " + EnumChatFormatting.GRAY + (Float)this.attributes[1] + "l");
                    break;
                }
                case FINS: {
                    list.add(EnumChatFormatting.BOLD + "Size: " + EnumChatFormatting.GRAY + this.getSize(this.top));
                    list.add(EnumChatFormatting.BOLD + "Inaccuracy: " + EnumChatFormatting.GRAY + ((Float)this.attributes[0]).floatValue() * 100.0f + "%");
                    break;
                }
                case THRUSTER: {
                    list.add(EnumChatFormatting.BOLD + "Size: " + EnumChatFormatting.GRAY + this.getSize(this.top));
                    list.add(EnumChatFormatting.BOLD + "Fuel type: " + EnumChatFormatting.GRAY + this.getFuel((FuelType)((Object)this.attributes[0])));
                    list.add(EnumChatFormatting.BOLD + "Fuel consumption: " + EnumChatFormatting.GRAY + (Float)this.attributes[1] + "l/tick");
                    list.add(EnumChatFormatting.BOLD + "Max. payload: " + EnumChatFormatting.GRAY + (Float)this.attributes[2] + "t");
                }
            }
        }
        catch (Exception ex) {
            list.add("### I AM ERROR ###");
        }
        if (this.type != PartType.CHIP) {
            list.add(EnumChatFormatting.BOLD + "Health: " + EnumChatFormatting.GRAY + this.health + "HP");
        }
        if (this.rarity != null) {
            list.add(EnumChatFormatting.BOLD + "Rarity: " + EnumChatFormatting.GRAY + this.rarity.name);
        }
        if (this.author != null) {
            list.add(EnumChatFormatting.WHITE + "   by " + this.author);
        }
        if (this.witty != null) {
            list.add(EnumChatFormatting.GOLD + "   " + EnumChatFormatting.ITALIC + "\"" + this.witty + "\"");
        }
    }

    public String getSize(PartSize size) {
        switch (size) {
            case ANY: {
                return "Any";
            }
            case SIZE_10: {
                return "1.0m";
            }
            case SIZE_15: {
                return "1.5m";
            }
            case SIZE_20: {
                return "2.0m";
            }
        }
        return "None";
    }

    public String getWarhead(WarheadType type) {
        if (type.labelCustom != null) {
            return type.labelCustom;
        }
        switch (type) {
            case HE: {
                return EnumChatFormatting.YELLOW + "HE";
            }
            case INC: {
                return EnumChatFormatting.GOLD + "Incendiary";
            }
            case CLUSTER: {
                return EnumChatFormatting.GRAY + "Cluster";
            }
            case BUSTER: {
                return EnumChatFormatting.WHITE + "Bunker Buster";
            }
            case NUCLEAR: {
                return EnumChatFormatting.DARK_GREEN + "Nuclear";
            }
            case TX: {
                return EnumChatFormatting.DARK_PURPLE + "Thermonuclear (TX)";
            }
            case N2: {
                return EnumChatFormatting.RED + "N\u00b2";
            }
            case BALEFIRE: {
                return EnumChatFormatting.GREEN + "BF";
            }
            case SCHRAB: {
                return EnumChatFormatting.AQUA + "Schrabidium";
            }
            case TAINT: {
                return EnumChatFormatting.DARK_PURPLE + "Taint";
            }
            case CLOUD: {
                return EnumChatFormatting.LIGHT_PURPLE + "Cloud";
            }
            case TURBINE: {
                return (System.currentTimeMillis() % 1000L < 500L ? EnumChatFormatting.RED : EnumChatFormatting.LIGHT_PURPLE) + "Turbine";
            }
        }
        return EnumChatFormatting.BOLD + "N/A";
    }

    public String getFuel(FuelType type) {
        switch (type) {
            case KEROSENE: {
                return EnumChatFormatting.LIGHT_PURPLE + "Kerosene / Peroxide";
            }
            case SOLID: {
                return EnumChatFormatting.GOLD + "Solid Fuel";
            }
            case HYDROGEN: {
                return EnumChatFormatting.DARK_AQUA + "Hydrogen / Oxygen";
            }
            case XENON: {
                return EnumChatFormatting.DARK_PURPLE + "Xenon Gas";
            }
            case BALEFIRE: {
                return EnumChatFormatting.GREEN + "BF Rocket Fuel / Peroxide";
            }
        }
        return EnumChatFormatting.BOLD + "N/A";
    }

    public ItemCustomMissilePart copy() {
        ItemCustomMissilePart part = new ItemCustomMissilePart();
        part.type = this.type;
        part.top = this.top;
        part.bottom = this.bottom;
        part.health = this.health;
        part.attributes = this.attributes;
        part.health = this.health;
        part.func_111206_d(this.field_111218_cA);
        return part;
    }

    public ItemCustomMissilePart setAuthor(String author) {
        this.author = author;
        return this;
    }

    public ItemCustomMissilePart setTitle(String title) {
        this.title = title;
        return this;
    }

    public ItemCustomMissilePart setWittyText(String witty) {
        this.witty = witty;
        return this;
    }

    public ItemCustomMissilePart setHealth(float health) {
        this.health = health;
        return this;
    }

    public ItemCustomMissilePart setRarity(Rarity rarity) {
        this.rarity = rarity;
        if (this.type == PartType.FUSELAGE) {
            if (this.top == PartSize.SIZE_10) {
                ItemLootCrate.list10.add(this);
            }
            if (this.top == PartSize.SIZE_15) {
                ItemLootCrate.list15.add(this);
            }
        } else {
            ItemLootCrate.listMisc.add(this);
        }
        return this;
    }

    public static enum Rarity {
        COMMON(EnumChatFormatting.GRAY + "Common"),
        UNCOMMON(EnumChatFormatting.YELLOW + "Uncommon"),
        RARE(EnumChatFormatting.AQUA + "Rare"),
        EPIC(EnumChatFormatting.LIGHT_PURPLE + "Epic"),
        LEGENDARY(EnumChatFormatting.DARK_GREEN + "Legendary"),
        SEWS_CLOTHES_AND_SUCKS_HORSE_COCK(EnumChatFormatting.DARK_AQUA + "Strange");

        String name;

        private Rarity(String name) {
            this.name = name;
        }
    }

    public static enum FuelType {
        KEROSENE,
        SOLID,
        HYDROGEN,
        XENON,
        BALEFIRE;

    }

    public static enum WarheadType {
        HE,
        INC,
        BUSTER,
        CLUSTER,
        NUCLEAR,
        TX,
        N2,
        BALEFIRE,
        SCHRAB,
        TAINT,
        CLOUD,
        TURBINE,
        CUSTOM0,
        CUSTOM1,
        CUSTOM2,
        CUSTOM3,
        CUSTOM4,
        CUSTOM5,
        CUSTOM6,
        CUSTOM7,
        CUSTOM8,
        CUSTOM9;

        public Consumer<EntityMissileCustom> impactCustom = null;
        public Consumer<EntityMissileCustom> updateCustom = null;
        public String labelCustom = null;
    }

    public static enum PartSize {
        ANY,
        NONE,
        SIZE_10,
        SIZE_15,
        SIZE_20;

    }

    public static enum PartType {
        CHIP,
        WARHEAD,
        FUSELAGE,
        FINS,
        THRUSTER;

    }
}

